/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.ViewResourceDelegate;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.util.JavaClassHelper;

public class ExprAndNode
extends ExprNode {
    private static final long serialVersionUID = 8105121208330622813L;

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        for (ExprNode child : this.getChildNodes()) {
            Class childType = child.getType();
            if (JavaClassHelper.isBoolean(childType)) continue;
            throw new ExprValidationException("Incorrect use of AND clause, sub-expressions do not return boolean");
        }
        if (this.getChildNodes().size() <= 1) {
            throw new ExprValidationException("The AND operator requires at least 2 child expressions");
        }
    }

    public boolean isConstantResult() {
        return false;
    }

    public Class getType() {
        return Boolean.class;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        for (ExprNode child : this.getChildNodes()) {
            Boolean evaluated = (Boolean)child.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (evaluated == null) {
                return null;
            }
            if (evaluated.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('(');
        String appendStr = "";
        for (ExprNode child : this.getChildNodes()) {
            buffer.append(appendStr);
            buffer.append(child.toExpressionString());
            appendStr = " AND ";
        }
        buffer.append(')');
        return buffer.toString();
    }

    public boolean equalsNode(ExprNode node) {
        return node instanceof ExprAndNode;
    }
}

