/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.ViewResourceDelegate;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.util.CoercionException;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleNumberCoercer;
import com.espertech.esper.util.SimpleNumberCoercerFactory;
import java.lang.reflect.Array;
import java.util.LinkedList;

public class ExprArrayNode
extends ExprNode {
    private Class arrayReturnType;
    private transient SimpleNumberCoercer coercer;
    private boolean mustCoerce;
    private int length;
    private transient Object constantResult;
    private static final long serialVersionUID = 5533223915923867651L;

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        this.length = this.getChildNodes().size();
        if (this.getChildNodes().size() == 0) {
            this.arrayReturnType = Object.class;
            this.constantResult = new Object[0];
            return;
        }
        LinkedList<Class> comparedTypes = new LinkedList<Class>();
        for (int i = 0; i < this.length; ++i) {
            comparedTypes.add(this.getChildNodes().get(i).getType());
        }
        try {
            this.arrayReturnType = JavaClassHelper.getCommonCoercionType(comparedTypes.toArray(new Class[comparedTypes.size()]));
            if (JavaClassHelper.isNumeric(this.arrayReturnType)) {
                this.mustCoerce = false;
                for (Class comparedType : comparedTypes) {
                    if (comparedType == this.arrayReturnType) continue;
                    this.mustCoerce = true;
                }
                if (this.mustCoerce) {
                    this.coercer = SimpleNumberCoercerFactory.getCoercer(null, this.arrayReturnType);
                }
            }
        }
        catch (CoercionException ex) {
            // empty catch block
        }
        if (this.arrayReturnType == null) {
            this.arrayReturnType = Object.class;
        }
        Object[] results = new Object[this.length];
        int index = 0;
        for (ExprNode child : this.getChildNodes()) {
            if (!child.isConstantResult()) {
                results = null;
                break;
            }
            results[index++] = child.evaluate(null, false, exprEvaluatorContext);
        }
        if (results != null) {
            this.constantResult = Array.newInstance(this.arrayReturnType, this.length);
            for (int i = 0; i < this.length; ++i) {
                if (this.mustCoerce) {
                    Number boxed = (Number)results[i];
                    if (boxed == null) continue;
                    Number coercedResult = this.coercer.coerceBoxed(boxed);
                    Array.set(this.constantResult, i, coercedResult);
                    continue;
                }
                Array.set(this.constantResult, i, results[i]);
            }
        }
    }

    public boolean isConstantResult() {
        return this.constantResult != null;
    }

    public Class getType() {
        return Array.newInstance(this.arrayReturnType, 0).getClass();
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (this.constantResult != null) {
            return this.constantResult;
        }
        Object array = Array.newInstance(this.arrayReturnType, this.length);
        if (this.length == 0) {
            return array;
        }
        int index = 0;
        for (ExprNode child : this.getChildNodes()) {
            Object result = child.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (result != null) {
                if (this.mustCoerce) {
                    Number boxed = (Number)result;
                    Number coercedResult = this.coercer.coerceBoxed(boxed);
                    Array.set(array, index, coercedResult);
                } else {
                    Array.set(array, index, result);
                }
            }
            ++index;
        }
        return array;
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        String delimiter = "";
        buffer.append("{");
        for (ExprNode expr : this.getChildNodes()) {
            buffer.append(delimiter);
            buffer.append(expr.toExpressionString());
            delimiter = ",";
        }
        buffer.append('}');
        return buffer.toString();
    }

    public boolean equalsNode(ExprNode node) {
        return node instanceof ExprArrayNode;
    }
}

