/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.ViewResourceDelegate;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleTypeCaster;
import com.espertech.esper.util.SimpleTypeCasterAnyType;
import com.espertech.esper.util.SimpleTypeCasterFactory;
import com.espertech.esper.util.SimpleTypeParser;
import com.espertech.esper.util.SimpleTypeParserFactory;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ExprCastNode
extends ExprNode {
    private final String classIdentifier;
    private Class targetType;
    private transient CasterParserComputer casterParserComputer;
    private static final long serialVersionUID = 7448449031028156455L;

    public ExprCastNode(String classIdentifier) {
        this.classIdentifier = classIdentifier;
    }

    public String getClassIdentifier() {
        return this.classIdentifier;
    }

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        boolean numeric;
        SimpleTypeCaster caster;
        if (this.getChildNodes().size() != 1) {
            throw new ExprValidationException("Cast function node must have exactly 1 child node");
        }
        Class fromType = this.getChildNodes().get(0).getType();
        this.targetType = JavaClassHelper.getPrimitiveClassForName(this.classIdentifier.trim());
        if (this.targetType != null) {
            this.targetType = JavaClassHelper.getBoxedType(this.targetType);
            caster = SimpleTypeCasterFactory.getCaster(fromType, this.targetType);
            numeric = caster.isNumericCast();
        } else if (this.classIdentifier.trim().toLowerCase().equals("BigInteger".toLowerCase())) {
            this.targetType = BigInteger.class;
            caster = SimpleTypeCasterFactory.getCaster(fromType, this.targetType);
            numeric = true;
        } else if (this.classIdentifier.trim().toLowerCase().equals("BigDecimal".toLowerCase())) {
            this.targetType = BigDecimal.class;
            caster = SimpleTypeCasterFactory.getCaster(fromType, this.targetType);
            numeric = true;
        } else {
            try {
                this.targetType = JavaClassHelper.getClassForName(this.classIdentifier.trim());
            }
            catch (ClassNotFoundException e2) {
                throw new ExprValidationException("Class as listed in cast function by name '" + this.classIdentifier + "' cannot be loaded", e2);
            }
            numeric = JavaClassHelper.isNumeric(this.targetType);
            caster = numeric ? SimpleTypeCasterFactory.getCaster(fromType, this.targetType) : new SimpleTypeCasterAnyType(this.targetType);
        }
        if (this.targetType == String.class) {
            this.casterParserComputer = new StringXFormComputer();
        } else if (fromType == String.class) {
            SimpleTypeParser parser = SimpleTypeParserFactory.getParser(JavaClassHelper.getBoxedType(this.targetType));
            this.casterParserComputer = new StringParserComputer(parser);
        } else {
            this.casterParserComputer = numeric ? new NumberCasterComputer(caster) : new NonnumericCasterComputer(caster);
        }
    }

    public boolean isConstantResult() {
        return false;
    }

    public Class getType() {
        return this.targetType;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object result = this.getChildNodes().get(0).evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (result == null) {
            return null;
        }
        return this.casterParserComputer.compute(result);
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("cast(");
        buffer.append(this.getChildNodes().get(0).toExpressionString());
        buffer.append(", ");
        buffer.append(this.classIdentifier);
        buffer.append(')');
        return buffer.toString();
    }

    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprCastNode)) {
            return false;
        }
        ExprCastNode other = (ExprCastNode)node;
        return other.classIdentifier.equals(this.classIdentifier);
    }

    public static class NonnumericCasterComputer
    implements CasterParserComputer {
        private final SimpleTypeCaster caster;

        public NonnumericCasterComputer(SimpleTypeCaster numericTypeCaster) {
            this.caster = numericTypeCaster;
        }

        public Object compute(Object input) {
            return this.caster.cast(input);
        }
    }

    public static class StringParserComputer
    implements CasterParserComputer {
        private final SimpleTypeParser parser;

        public StringParserComputer(SimpleTypeParser parser) {
            this.parser = parser;
        }

        public Object compute(Object input) {
            return this.parser.parse(input.toString());
        }
    }

    public static class NumberCasterComputer
    implements CasterParserComputer {
        private final SimpleTypeCaster numericTypeCaster;

        public NumberCasterComputer(SimpleTypeCaster numericTypeCaster) {
            this.numericTypeCaster = numericTypeCaster;
        }

        public Object compute(Object input) {
            if (input instanceof Number) {
                return this.numericTypeCaster.cast(input);
            }
            return null;
        }
    }

    public static class StringXFormComputer
    implements CasterParserComputer {
        public Object compute(Object input) {
            return input.toString();
        }
    }

    public static interface CasterParserComputer {
        public Object compute(Object var1);
    }
}

