/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.ViewResourceDelegate;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.util.CoercionException;
import com.espertech.esper.util.JavaClassHelper;

public class ExprCoalesceNode
extends ExprNode {
    private Class resultType;
    private boolean[] isNumericCoercion;
    private static final long serialVersionUID = -8276568753875819730L;

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        if (this.getChildNodes().size() < 2) {
            throw new ExprValidationException("Coalesce node must have at least 2 child nodes");
        }
        Class[] childTypes = new Class[this.getChildNodes().size()];
        int count = 0;
        for (ExprNode child : this.getChildNodes()) {
            childTypes[count] = child.getType();
            ++count;
        }
        try {
            this.resultType = JavaClassHelper.getCommonCoercionType(childTypes);
        }
        catch (CoercionException ex) {
            throw new ExprValidationException("Implicit conversion not allowed: " + ex.getMessage());
        }
        this.isNumericCoercion = new boolean[this.getChildNodes().size()];
        count = 0;
        for (ExprNode child : this.getChildNodes()) {
            if (JavaClassHelper.getBoxedType(child.getType()) != this.resultType && child.getType() != null && this.resultType != null) {
                if (!JavaClassHelper.isNumeric(this.resultType)) {
                    throw new ExprValidationException("Implicit conversion from datatype '" + this.resultType.getSimpleName() + "' to " + child.getType() + " is not allowed");
                }
                this.isNumericCoercion[count] = true;
            }
            ++count;
        }
    }

    public boolean isConstantResult() {
        return false;
    }

    public Class getType() {
        return this.resultType;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        int count = 0;
        for (ExprNode childNode : this.getChildNodes()) {
            Object value = childNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (value != null) {
                if (this.isNumericCoercion[count]) {
                    return JavaClassHelper.coerceBoxed((Number)value, this.resultType);
                }
                return value;
            }
            ++count;
        }
        return null;
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("coalesce(");
        String delimiter = "";
        for (int i = 0; i < this.getChildNodes().size(); ++i) {
            buffer.append(delimiter);
            buffer.append(this.getChildNodes().get(i).toExpressionString());
            delimiter = ",";
        }
        buffer.append(')');
        return buffer.toString();
    }

    public boolean equalsNode(ExprNode node) {
        return node instanceof ExprCoalesceNode;
    }
}

