/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.ViewResourceDelegate;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.schedule.TimeProvider;

public class ExprConcatNode
extends ExprNode {
    private StringBuffer buffer = new StringBuffer();
    private static final long serialVersionUID = 5811427566733004327L;

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        if (this.getChildNodes().size() < 2) {
            throw new ExprValidationException("Concat node must have at least 2 child nodes");
        }
        for (int i = 0; i < this.getChildNodes().size(); ++i) {
            Class childType = this.getChildNodes().get(i).getType();
            if (childType == String.class) continue;
            throw new ExprValidationException("Implicit conversion from datatype '" + childType.getSimpleName() + "' to string is not allowed");
        }
    }

    public Class getType() {
        return String.class;
    }

    public boolean isConstantResult() {
        return false;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        this.buffer.delete(0, this.buffer.length());
        for (ExprNode child : this.getChildNodes()) {
            String result = (String)child.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (result == null) {
                return null;
            }
            this.buffer.append(result);
        }
        return this.buffer.toString();
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        String delimiter = "(";
        for (ExprNode child : this.getChildNodes()) {
            buffer.append(delimiter);
            buffer.append(child.toExpressionString());
            delimiter = "||";
        }
        buffer.append(')');
        return buffer.toString();
    }

    public boolean equalsNode(ExprNode node) {
        return node instanceof ExprConcatNode;
    }
}

