/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.ViewResourceDelegate;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.util.CoercionException;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleNumberCoercer;
import com.espertech.esper.util.SimpleNumberCoercerFactory;

public class ExprEqualsNode
extends ExprNode {
    private final boolean isNotEquals;
    private boolean mustCoerce;
    private SimpleNumberCoercer numberCoercerLHS;
    private SimpleNumberCoercer numberCoercerRHS;
    private static final long serialVersionUID = 5504809379222369952L;

    public ExprEqualsNode(boolean isNotEquals) {
        this.isNotEquals = isNotEquals;
    }

    public boolean isNotEquals() {
        return this.isNotEquals;
    }

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        Class coercionType;
        if (this.getChildNodes().size() != 2) {
            throw new IllegalStateException("Equals node does not have exactly 2 child nodes");
        }
        Class typeOne = JavaClassHelper.getBoxedType(this.getChildNodes().get(0).getType());
        Class typeTwo = JavaClassHelper.getBoxedType(this.getChildNodes().get(1).getType());
        if (typeOne == null || typeTwo == null) {
            return;
        }
        if (typeOne.equals(typeTwo) || typeOne.isAssignableFrom(typeTwo)) {
            this.mustCoerce = false;
            return;
        }
        try {
            coercionType = JavaClassHelper.getCompareToCoercionType(typeOne, typeTwo);
        }
        catch (CoercionException ex) {
            throw new ExprValidationException("Implicit conversion from datatype '" + typeTwo.getSimpleName() + "' to '" + typeOne.getSimpleName() + "' is not allowed");
        }
        if (coercionType == JavaClassHelper.getBoxedType(typeOne) && coercionType == JavaClassHelper.getBoxedType(typeTwo)) {
            this.mustCoerce = false;
        } else {
            if (!JavaClassHelper.isNumeric(coercionType)) {
                throw new IllegalStateException("Coercion type " + coercionType + " not numeric");
            }
            this.mustCoerce = true;
            this.numberCoercerLHS = SimpleNumberCoercerFactory.getCoercer(typeOne, coercionType);
            this.numberCoercerRHS = SimpleNumberCoercerFactory.getCoercer(typeTwo, coercionType);
        }
    }

    public boolean isConstantResult() {
        return false;
    }

    public Class getType() {
        return Boolean.class;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object leftResult = this.getChildNodes().get(0).evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        Object rightResult = this.getChildNodes().get(1).evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (leftResult == null) {
            return rightResult == null ^ this.isNotEquals;
        }
        if (rightResult == null) {
            return this.isNotEquals;
        }
        if (!this.mustCoerce) {
            return leftResult.equals(rightResult) ^ this.isNotEquals;
        }
        Number left = this.numberCoercerLHS.coerceBoxed((Number)leftResult);
        Number right = this.numberCoercerRHS.coerceBoxed((Number)rightResult);
        return left.equals(right) ^ this.isNotEquals;
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getChildNodes().get(0).toExpressionString());
        buffer.append(" = ");
        buffer.append(this.getChildNodes().get(1).toExpressionString());
        return buffer.toString();
    }

    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprEqualsNode)) {
            return false;
        }
        ExprEqualsNode other = (ExprEqualsNode)node;
        return other.isNotEquals == this.isNotEquals;
    }
}

