/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.ViewResourceDelegate;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.util.CoercionException;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleNumberCoercer;
import com.espertech.esper.util.SimpleNumberCoercerFactory;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class ExprInNode
extends ExprNode {
    private final boolean isNotIn;
    private boolean mustCoerce;
    private boolean hasCollectionOrArray;
    private SimpleNumberCoercer coercer;
    private static final long serialVersionUID = -601723009914169907L;

    public ExprInNode(boolean isNotIn) {
        this.isNotIn = isNotIn;
    }

    public boolean isNotIn() {
        return this.isNotIn;
    }

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        Class coercionType;
        if (this.getChildNodes().size() < 2) {
            throw new ExprValidationException("The IN operator requires at least 2 child expressions");
        }
        Class typeOne = JavaClassHelper.getBoxedType(this.getChildNodes().get(0).getType());
        if (typeOne.isArray() || JavaClassHelper.isImplementsInterface(typeOne, Collection.class) || JavaClassHelper.isImplementsInterface(typeOne, Map.class)) {
            throw new ExprValidationException("Collection or array comparison is not allowed for the IN, ANY, SOME or ALL keywords");
        }
        ArrayList<Class> comparedTypes = new ArrayList<Class>();
        comparedTypes.add(typeOne);
        this.hasCollectionOrArray = false;
        for (int i = 0; i < this.getChildNodes().size() - 1; ++i) {
            Class propType = this.getChildNodes().get(i + 1).getType();
            if (propType == null) continue;
            if (propType.isArray()) {
                this.hasCollectionOrArray = true;
                if (propType.getComponentType() == Object.class) continue;
                comparedTypes.add(propType.getComponentType());
                continue;
            }
            if (JavaClassHelper.isImplementsInterface(propType, Collection.class)) {
                this.hasCollectionOrArray = true;
                continue;
            }
            if (JavaClassHelper.isImplementsInterface(propType, Map.class)) {
                this.hasCollectionOrArray = true;
                continue;
            }
            comparedTypes.add(propType);
        }
        try {
            coercionType = JavaClassHelper.getCommonCoercionType(comparedTypes.toArray(new Class[comparedTypes.size()]));
        }
        catch (CoercionException ex) {
            throw new ExprValidationException("Implicit conversion not allowed: " + ex.getMessage());
        }
        this.mustCoerce = false;
        if (JavaClassHelper.isNumeric(coercionType)) {
            for (Class compareType : comparedTypes) {
                if (coercionType == JavaClassHelper.getBoxedType(compareType)) continue;
                this.mustCoerce = true;
            }
            if (this.mustCoerce) {
                this.coercer = SimpleNumberCoercerFactory.getCoercer(null, JavaClassHelper.getBoxedType(coercionType));
            }
        }
    }

    public Class getType() {
        return Boolean.class;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object inPropResult = this.getChildNodes().get(0).evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (!this.hasCollectionOrArray) {
            int len;
            if (this.mustCoerce && inPropResult != null) {
                inPropResult = this.coercer.coerceBoxed((Number)inPropResult);
            }
            if ((len = this.getChildNodes().size() - 1) > 0 && inPropResult == null) {
                return null;
            }
            boolean hasNullRow = false;
            for (int i = 1; i <= len; ++i) {
                Number right;
                Object rightResult = this.getChildNodes().get(i).evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                if (rightResult == null) {
                    hasNullRow = true;
                    continue;
                }
                if (!(!this.mustCoerce ? rightResult.equals(inPropResult) : (right = this.coercer.coerceBoxed((Number)rightResult)).equals(inPropResult))) continue;
                return !this.isNotIn;
            }
            if (hasNullRow) {
                return null;
            }
            return this.isNotIn;
        }
        int len = this.getChildNodes().size() - 1;
        boolean hasNullRow = false;
        for (int i = 1; i <= len; ++i) {
            Number right;
            Number left;
            Object rightResult = this.getChildNodes().get(i).evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (rightResult == null) continue;
            if (rightResult instanceof Collection) {
                if (inPropResult == null) {
                    return null;
                }
                Collection coll = (Collection)rightResult;
                if (!coll.contains(inPropResult)) continue;
                return !this.isNotIn;
            }
            if (rightResult instanceof Map) {
                if (inPropResult == null) {
                    return null;
                }
                Map coll = (Map)rightResult;
                if (!coll.containsKey(inPropResult)) continue;
                return !this.isNotIn;
            }
            if (rightResult.getClass().isArray()) {
                int arrayLength = Array.getLength(rightResult);
                if (arrayLength > 0 && inPropResult == null) {
                    return null;
                }
                for (int index = 0; index < arrayLength; ++index) {
                    Number right2;
                    Number left2;
                    Object item = Array.get(rightResult, index);
                    if (item == null) {
                        hasNullRow = true;
                        continue;
                    }
                    if (!(!this.mustCoerce ? inPropResult.equals(item) : item instanceof Number && (left2 = this.coercer.coerceBoxed((Number)inPropResult)).equals(right2 = this.coercer.coerceBoxed((Number)item)))) continue;
                    return !this.isNotIn;
                }
                continue;
            }
            if (inPropResult == null) {
                return null;
            }
            if (!(!this.mustCoerce ? inPropResult.equals(rightResult) : (left = this.coercer.coerceBoxed((Number)inPropResult)).equals(right = this.coercer.coerceBoxed((Number)rightResult)))) continue;
            return !this.isNotIn;
        }
        if (hasNullRow) {
            return null;
        }
        return this.isNotIn;
    }

    public boolean isConstantResult() {
        return false;
    }

    public boolean equalsNode(ExprNode node_) {
        if (!(node_ instanceof ExprInNode)) {
            return false;
        }
        ExprInNode other = (ExprInNode)node_;
        return other.isNotIn == this.isNotIn;
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        String delimiter = "";
        Iterator<ExprNode> it = this.getChildNodes().iterator();
        buffer.append(it.next().toExpressionString());
        if (this.isNotIn) {
            buffer.append(" not in (");
        } else {
            buffer.append(" in (");
        }
        do {
            ExprNode inSetValueExpr = it.next();
            buffer.append(delimiter);
            buffer.append(inSetValueExpr.toExpressionString());
            delimiter = ",";
        } while (it.hasNext());
        buffer.append(')');
        return buffer.toString();
    }
}

