/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.ViewResourceDelegate;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.LikeUtil;

public class ExprLikeNode
extends ExprNode {
    private final boolean isNot;
    private boolean isNumericValue;
    private boolean isConstantPattern;
    private LikeUtil likeUtil;
    private static final long serialVersionUID = 34888860063217132L;

    public ExprLikeNode(boolean not) {
        this.isNot = not;
    }

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        ExprNode escapeChildNode;
        if (this.getChildNodes().size() != 2 && this.getChildNodes().size() != 3) {
            throw new ExprValidationException("The 'like' operator requires 2 (no escape) or 3 (with escape) child expressions");
        }
        Class evalChildType = this.getChildNodes().get(0).getType();
        this.isNumericValue = JavaClassHelper.isNumeric(evalChildType);
        if (evalChildType != String.class && !this.isNumericValue) {
            throw new ExprValidationException("The 'like' operator requires a String or numeric type left-hand expression");
        }
        ExprNode patternChildNode = this.getChildNodes().get(1);
        Class patternChildType = patternChildNode.getType();
        if (patternChildType != String.class) {
            throw new ExprValidationException("The 'like' operator requires a String-type pattern expression");
        }
        if (this.getChildNodes().get(1).isConstantResult()) {
            this.isConstantPattern = true;
        }
        if (this.getChildNodes().size() == 3 && (escapeChildNode = this.getChildNodes().get(2)).getType() != String.class) {
            throw new ExprValidationException("The 'like' operator escape parameter requires a character-type value");
        }
    }

    public Class getType() {
        return Boolean.class;
    }

    public boolean isConstantResult() {
        return false;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        String patternVal;
        if (this.likeUtil == null) {
            patternVal = (String)this.getChildNodes().get(1).evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (patternVal == null) {
                return null;
            }
            String escape = "\\";
            Character escapeCharacter = null;
            if (this.getChildNodes().size() == 3) {
                escape = (String)this.getChildNodes().get(2).evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            }
            if (escape.length() > 0) {
                escapeCharacter = Character.valueOf(escape.charAt(0));
            }
            this.likeUtil = new LikeUtil(patternVal, escapeCharacter, false);
        } else if (!this.isConstantPattern) {
            patternVal = (String)this.getChildNodes().get(1).evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (patternVal == null) {
                return null;
            }
            this.likeUtil.resetPattern(patternVal);
        }
        Object evalValue = this.getChildNodes().get(0).evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (evalValue == null) {
            return null;
        }
        if (this.isNumericValue) {
            evalValue = evalValue.toString();
        }
        Boolean result = this.likeUtil.compare((String)evalValue);
        if (this.isNot) {
            return result == false;
        }
        return result;
    }

    public boolean equalsNode(ExprNode node_) {
        if (!(node_ instanceof ExprLikeNode)) {
            return false;
        }
        ExprLikeNode other = (ExprLikeNode)node_;
        return this.isNot == other.isNot;
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getChildNodes().get(0).toExpressionString());
        if (this.isNot) {
            buffer.append(" not");
        }
        buffer.append(" like ");
        buffer.append(this.getChildNodes().get(1).toExpressionString());
        if (this.getChildNodes().size() == 3) {
            buffer.append(" escape ");
            buffer.append(this.getChildNodes().get(2).toExpressionString());
        }
        return buffer.toString();
    }

    public boolean isNot() {
        return this.isNot;
    }
}

