/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.ViewResourceDelegate;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.type.MathArithTypeEnum;
import com.espertech.esper.util.JavaClassHelper;
import java.math.BigDecimal;

public class ExprMathNode
extends ExprNode {
    private final MathArithTypeEnum mathArithTypeEnum;
    private final boolean isIntegerDivision;
    private final boolean isDivisionByZeroReturnsNull;
    private MathArithTypeEnum.Computer arithTypeEnumComputer;
    private Class resultType;
    private static final long serialVersionUID = 6479683588602862158L;

    public ExprMathNode(MathArithTypeEnum mathArithTypeEnum, boolean isIntegerDivision, boolean isDivisionByZeroReturnsNull) {
        this.mathArithTypeEnum = mathArithTypeEnum;
        this.isIntegerDivision = isIntegerDivision;
        this.isDivisionByZeroReturnsNull = isDivisionByZeroReturnsNull;
    }

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        Class childTypeTwo;
        if (this.getChildNodes().size() != 2) {
            throw new ExprValidationException("Arithmatic node must have 2 child nodes");
        }
        for (ExprNode child : this.getChildNodes()) {
            Class childType = child.getType();
            if (JavaClassHelper.isNumeric(childType)) continue;
            throw new ExprValidationException("Implicit conversion from datatype '" + childType.getSimpleName() + "' to numeric is not allowed");
        }
        Class childTypeOne = this.getChildNodes().get(0).getType();
        this.resultType = childTypeOne.equals(childTypeTwo = this.getChildNodes().get(1).getType()) ? JavaClassHelper.getBoxedType(childTypeTwo) : JavaClassHelper.getArithmaticCoercionType(childTypeOne, childTypeTwo);
        if (this.mathArithTypeEnum == MathArithTypeEnum.DIVIDE && !this.isIntegerDivision && this.resultType != BigDecimal.class) {
            this.resultType = Double.class;
        }
        this.arithTypeEnumComputer = this.mathArithTypeEnum.getComputer(this.resultType, childTypeOne, childTypeTwo, this.isIntegerDivision, this.isDivisionByZeroReturnsNull);
    }

    public Class getType() {
        return this.resultType;
    }

    public boolean isConstantResult() {
        return false;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object valueChildOne = this.getChildNodes().get(0).evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        Object valueChildTwo = this.getChildNodes().get(1).evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (valueChildOne == null || valueChildTwo == null) {
            return null;
        }
        return this.arithTypeEnumComputer.compute((Number)valueChildOne, (Number)valueChildTwo);
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('(');
        buffer.append(this.getChildNodes().get(0).toExpressionString());
        buffer.append(this.mathArithTypeEnum.getExpressionText());
        buffer.append(this.getChildNodes().get(1).toExpressionString());
        buffer.append(')');
        return buffer.toString();
    }

    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprMathNode)) {
            return false;
        }
        ExprMathNode other = (ExprMathNode)node;
        return other.mathArithTypeEnum == this.mathArithTypeEnum;
    }

    public MathArithTypeEnum getMathArithTypeEnum() {
        return this.mathArithTypeEnum;
    }
}

