/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.epl.agg.AggregationMethod;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.expression.ExprAggregateNode;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.type.MinMaxTypeEnum;

public class ExprMinMaxAggrNode
extends ExprAggregateNode {
    private final MinMaxTypeEnum minMaxTypeEnum;
    private static final long serialVersionUID = -7828413362615586145L;

    public ExprMinMaxAggrNode(boolean distinct, MinMaxTypeEnum minMaxTypeEnum) {
        super(distinct);
        this.minMaxTypeEnum = minMaxTypeEnum;
    }

    public AggregationMethod validateAggregationChild(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        if (this.getChildNodes().size() != 1) {
            throw new ExprValidationException(this.minMaxTypeEnum.toString() + " node must have exactly 1 child node");
        }
        ExprNode child = this.getChildNodes().get(0);
        boolean hasDataWindows = ExprNodeUtility.hasRemoveStream(child, streamTypeService);
        return methodResolutionService.makeMinMaxAggregator(this.minMaxTypeEnum, child.getType(), hasDataWindows);
    }

    public final boolean equalsNodeAggregate(ExprAggregateNode node) {
        if (!(node instanceof ExprMinMaxAggrNode)) {
            return false;
        }
        ExprMinMaxAggrNode other = (ExprMinMaxAggrNode)node;
        return other.minMaxTypeEnum == this.minMaxTypeEnum;
    }

    public MinMaxTypeEnum getMinMaxTypeEnum() {
        return this.minMaxTypeEnum;
    }

    protected String getAggregationFunctionName() {
        return this.minMaxTypeEnum.getExpressionText();
    }
}

