/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.expression.ExprAggregateNode;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeIdentifierCollectVisitor;
import com.espertech.esper.epl.expression.ExprNodeSubselectVisitor;
import com.espertech.esper.epl.expression.ExprNodeViewResourceVisitor;
import com.espertech.esper.event.EventBeanUtility;
import java.util.LinkedList;

public class ExprNodeUtility {
    public static boolean hasRemoveStream(ExprNode child, StreamTypeService streamTypeService) {
        boolean[] isIStreamOnly = streamTypeService.getIStreamOnly();
        boolean isAllIStream = true;
        boolean isAllIRStream = true;
        for (boolean anIsIStreamOnly : isIStreamOnly) {
            if (!anIsIStreamOnly) {
                isAllIStream = false;
                continue;
            }
            isAllIRStream = false;
        }
        boolean hasDataWindows = true;
        if (isAllIStream) {
            hasDataWindows = false;
        } else if (!isAllIRStream) {
            hasDataWindows = false;
            ExprNodeIdentifierCollectVisitor visitor = new ExprNodeIdentifierCollectVisitor();
            child.accept(visitor);
            for (ExprIdentNode node : visitor.getExprProperties()) {
                if (isIStreamOnly[node.getStreamId()]) continue;
                hasDataWindows = true;
                break;
            }
        }
        return hasDataWindows;
    }

    public static EventBean[] applyFilterExpression(ExprNode filter, EventBean streamZeroEvent, EventBean[] streamOneEvents, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean[] eventsPerStream = new EventBean[2];
        eventsPerStream[0] = streamZeroEvent;
        EventBean[] filtered = new EventBean[streamOneEvents.length];
        int countPass = 0;
        EventBean[] arr$ = streamOneEvents;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            EventBean eventBean;
            eventsPerStream[1] = eventBean = arr$[i$];
            Boolean result = (Boolean)filter.evaluate(eventsPerStream, true, exprEvaluatorContext);
            if (result == null || !result.booleanValue()) continue;
            filtered[countPass] = eventBean;
            ++countPass;
        }
        if (countPass == streamOneEvents.length) {
            return streamOneEvents;
        }
        return EventBeanUtility.resizeArray(filtered, countPass);
    }

    public static boolean applyFilterExpression(ExprNode filter, EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        Boolean result = (Boolean)filter.evaluate(eventsPerStream, true, exprEvaluatorContext);
        return result != null && result != false;
    }

    public static boolean deepEquals(ExprNode nodeOne, ExprNode nodeTwo) {
        if (nodeOne.getChildNodes().size() != nodeTwo.getChildNodes().size()) {
            return false;
        }
        if (!nodeOne.equalsNode(nodeTwo)) {
            return false;
        }
        for (int i = 0; i < nodeOne.getChildNodes().size(); ++i) {
            ExprNode childNodeTwo;
            ExprNode childNodeOne = nodeOne.getChildNodes().get(i);
            if (ExprNodeUtility.deepEquals(childNodeOne, childNodeTwo = nodeTwo.getChildNodes().get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean deepEquals(ExprNode[] one, ExprNode[] two) {
        if (one.length != two.length) {
            return false;
        }
        for (int i = 0; i < one.length; ++i) {
            if (ExprNodeUtility.deepEquals(one[i], two[i])) continue;
            return false;
        }
        return true;
    }

    public static String isMinimalExpression(ExprNode expression) {
        ExprNodeSubselectVisitor subselectVisitor = new ExprNodeSubselectVisitor();
        expression.accept(subselectVisitor);
        if (subselectVisitor.getSubselects().size() > 0) {
            return "a subselect";
        }
        ExprNodeViewResourceVisitor viewResourceVisitor = new ExprNodeViewResourceVisitor();
        expression.accept(viewResourceVisitor);
        if (viewResourceVisitor.getExprNodes().size() > 0) {
            return "a function that requires view resources (prior, prev)";
        }
        LinkedList<ExprAggregateNode> aggregateNodes = new LinkedList<ExprAggregateNode>();
        ExprAggregateNode.getAggregatesBottomUp(expression, aggregateNodes);
        if (!aggregateNodes.isEmpty()) {
            return "an aggregation function";
        }
        return null;
    }
}

