/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.epl.agg.AggregationMethod;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.expression.ExprAggregateNode;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;

public class ExprNthAggNode
extends ExprAggregateNode {
    private static final long serialVersionUID = -843689785630260527L;

    public ExprNthAggNode(boolean distinct) {
        super(distinct);
    }

    public AggregationMethod validateAggregationChild(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        String message = "The nth aggregation function requires two parameters, an expression returning aggregation values and a numeric index constant";
        if (this.getChildNodes().size() != 2) {
            throw new ExprValidationException(message);
        }
        ExprNode first = this.getChildNodes().get(0);
        ExprNode second = this.getChildNodes().get(1);
        if (!second.isConstantResult()) {
            throw new ExprValidationException(message);
        }
        Number num = (Number)second.evaluate(null, true, exprEvaluatorContext);
        int size = num.intValue();
        return methodResolutionService.makeNthAggregator(first.getType(), size);
    }

    protected String getAggregationFunctionName() {
        return "nth";
    }

    public final boolean equalsNodeAggregate(ExprAggregateNode node) {
        return node instanceof ExprNthAggNode;
    }
}

