/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.ViewResourceDelegate;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.type.CronOperatorEnum;
import com.espertech.esper.type.CronParameter;
import com.espertech.esper.util.JavaClassHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExprNumberSetCronParam
extends ExprNode {
    private static final Log log = LogFactory.getLog(ExprNumberSetCronParam.class);
    private final CronOperatorEnum cronOperator;
    private TimeProvider timeProvider;
    private static final long serialVersionUID = -1315999998249935318L;

    public ExprNumberSetCronParam(CronOperatorEnum cronOperator) {
        this.cronOperator = cronOperator;
    }

    public CronOperatorEnum getCronOperator() {
        return this.cronOperator;
    }

    public String toExpressionString() {
        if (this.getChildNodes().isEmpty()) {
            return this.cronOperator.getSyntax();
        }
        return this.getChildNodes().get(0).toExpressionString() + " " + this.cronOperator.getSyntax();
    }

    public boolean isConstantResult() {
        if (this.getChildNodes().size() == 0) {
            return true;
        }
        return this.getChildNodes().get(0).isConstantResult();
    }

    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprNumberSetCronParam)) {
            return false;
        }
        ExprNumberSetCronParam other = (ExprNumberSetCronParam)node;
        return other.cronOperator.equals((Object)this.cronOperator);
    }

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        this.timeProvider = timeProvider;
        if (this.getChildNodes().isEmpty()) {
            return;
        }
        Class type = this.getChildNodes().get(0).getType();
        if (!JavaClassHelper.isNumericNonFP(type)) {
            throw new ExprValidationException("Frequency operator requires an integer-type parameter");
        }
    }

    public Class getType() {
        return CronParameter.class;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (this.timeProvider == null) {
            throw new EPException("Expression node has not been validated");
        }
        if (this.getChildNodes().isEmpty()) {
            return new CronParameter(this.cronOperator, null, this.timeProvider.getTime());
        }
        Object value = this.getChildNodes().get(0).evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (value == null) {
            log.warn("Null value returned for cron parameter");
            return new CronParameter(this.cronOperator, null, this.timeProvider.getTime());
        }
        int intValue = ((Number)value).intValue();
        return new CronParameter(this.cronOperator, intValue, this.timeProvider.getTime());
    }
}

