/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.ViewResourceDelegate;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.rowregex.RegexPartitionStateRandomAccess;
import com.espertech.esper.rowregex.RegexPartitionStateRandomAccessGetter;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.util.JavaClassHelper;

public class ExprPreviousMatchRecognizeNode
extends ExprNode {
    private static final long serialVersionUID = 0L;
    private Class resultType;
    private int streamNumber;
    private Integer constantIndexNumber;
    private transient RegexPartitionStateRandomAccessGetter getter;
    private int assignedIndex;

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        if (this.getChildNodes().size() != 2) {
            throw new ExprValidationException("Match-Recognize Previous expression must have 2 child nodes");
        }
        if (!(this.getChildNodes().get(0) instanceof ExprIdentNode)) {
            throw new ExprValidationException("Match-Recognize Previous expression requires an property identifier as the first parameter");
        }
        if (!this.getChildNodes().get(1).isConstantResult() || !JavaClassHelper.isNumericNonFP(this.getChildNodes().get(1).getType())) {
            throw new ExprValidationException("Match-Recognize Previous expression requires an integer index parameter or expression as the second parameter");
        }
        ExprNode constantNode = this.getChildNodes().get(1);
        Object value = constantNode.evaluate(null, false, exprEvaluatorContext);
        if (!(value instanceof Number)) {
            throw new ExprValidationException("Match-Recognize Previous expression requires an integer index parameter or expression as the second parameter");
        }
        this.constantIndexNumber = ((Number)value).intValue();
        ExprIdentNode identNode = (ExprIdentNode)this.getChildNodes().get(0);
        this.streamNumber = identNode.getStreamId();
        this.resultType = this.getChildNodes().get(0).getType();
    }

    public Integer getConstantIndexNumber() {
        if (this.constantIndexNumber == null) {
            ExprNode constantNode = this.getChildNodes().get(1);
            Object value = constantNode.evaluate(null, false, null);
            this.constantIndexNumber = ((Number)value).intValue();
        }
        return this.constantIndexNumber;
    }

    public Class getType() {
        return this.resultType;
    }

    public boolean isConstantResult() {
        return false;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        RegexPartitionStateRandomAccess access = this.getter.getAccessor();
        EventBean substituteEvent = access.getPreviousEvent(this.assignedIndex);
        if (substituteEvent == null) {
            return null;
        }
        EventBean originalEvent = eventsPerStream[this.streamNumber];
        eventsPerStream[this.streamNumber] = substituteEvent;
        Object evalResult = this.getChildNodes().get(0).evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        eventsPerStream[this.streamNumber] = originalEvent;
        return evalResult;
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("prev(");
        buffer.append(this.getChildNodes().get(0).toExpressionString());
        buffer.append(',');
        buffer.append(this.getChildNodes().get(1).toExpressionString());
        buffer.append(')');
        return buffer.toString();
    }

    public boolean equalsNode(ExprNode node) {
        return node instanceof ExprPreviousMatchRecognizeNode;
    }

    public void setGetter(RegexPartitionStateRandomAccessGetter getter) {
        this.getter = getter;
    }

    public void setAssignedIndex(int assignedIndex) {
        this.assignedIndex = assignedIndex;
    }
}

