/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.ViewResourceCallback;
import com.espertech.esper.epl.core.ViewResourceDelegate;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprStreamUnderlyingNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.view.ViewCapPriorEventAccess;
import com.espertech.esper.view.window.RandomAccessByIndex;
import com.espertech.esper.view.window.RelativeAccessByEventNIndex;

public class ExprPriorNode
extends ExprNode
implements ViewResourceCallback {
    private Class resultType;
    private int streamNumber;
    private int constantIndexNumber;
    private RelativeAccessByEventNIndex relativeAccess;
    private RandomAccessByIndex randomAccess;
    private static final long serialVersionUID = -2115346817501589366L;

    public int getConstantIndexNumber() {
        return this.constantIndexNumber;
    }

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        if (this.getChildNodes().size() != 2) {
            throw new ExprValidationException("Prior node must have 2 child nodes");
        }
        if (!this.getChildNodes().get(0).isConstantResult()) {
            throw new ExprValidationException("Prior function requires an integer index parameter");
        }
        ExprNode constantNode = this.getChildNodes().get(0);
        if (constantNode.getType() != Integer.class) {
            throw new ExprValidationException("Prior function requires an integer index parameter");
        }
        Object value = constantNode.evaluate(null, false, exprEvaluatorContext);
        this.constantIndexNumber = ((Number)value).intValue();
        if (this.getChildNodes().get(1) instanceof ExprIdentNode) {
            ExprIdentNode identNode = (ExprIdentNode)this.getChildNodes().get(1);
            this.streamNumber = identNode.getStreamId();
            this.resultType = this.getChildNodes().get(1).getType();
        } else if (this.getChildNodes().get(1) instanceof ExprStreamUnderlyingNode) {
            ExprStreamUnderlyingNode streamNode = (ExprStreamUnderlyingNode)this.getChildNodes().get(1);
            this.streamNumber = streamNode.getStreamId();
            this.resultType = this.getChildNodes().get(1).getType();
        } else {
            throw new ExprValidationException("Previous function requires an event property as parameter");
        }
        if (viewResourceDelegate == null) {
            throw new ExprValidationException("Prior function cannot be used in this context");
        }
        if (!viewResourceDelegate.requestCapability(this.streamNumber, new ViewCapPriorEventAccess(this.constantIndexNumber), this)) {
            throw new ExprValidationException("Prior function requires the prior event view resource");
        }
    }

    public Class getType() {
        return this.resultType;
    }

    public boolean isConstantResult() {
        return false;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean originalEvent = eventsPerStream[this.streamNumber];
        EventBean substituteEvent = this.randomAccess != null ? (isNewData ? this.randomAccess.getNewData(this.constantIndexNumber) : this.randomAccess.getOldData(this.constantIndexNumber)) : this.relativeAccess.getRelativeToEvent(originalEvent, this.constantIndexNumber);
        eventsPerStream[this.streamNumber] = substituteEvent;
        Object evalResult = this.getChildNodes().get(1).evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        eventsPerStream[this.streamNumber] = originalEvent;
        return evalResult;
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("prior(");
        buffer.append(this.getChildNodes().get(0).toExpressionString());
        buffer.append(',');
        buffer.append(this.getChildNodes().get(1).toExpressionString());
        buffer.append(')');
        return buffer.toString();
    }

    public boolean equalsNode(ExprNode node) {
        return node instanceof ExprPriorNode;
    }

    public void setViewResource(Object resource) {
        if (resource instanceof RelativeAccessByEventNIndex) {
            this.relativeAccess = (RelativeAccessByEventNIndex)resource;
        } else if (resource instanceof RandomAccessByIndex) {
            this.randomAccess = (RandomAccessByIndex)resource;
        } else {
            throw new IllegalArgumentException("View resource " + resource.getClass() + " not recognized by expression node");
        }
    }
}

