/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.epl.agg.AggregationMethod;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.expression.ExprAggregateNode;
import com.espertech.esper.epl.expression.ExprConstantNode;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprTimePeriod;
import com.espertech.esper.epl.expression.ExprTimestampNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.util.JavaClassHelper;

public class ExprRateAggNode
extends ExprAggregateNode {
    private static final long serialVersionUID = -1616393720555472129L;

    public ExprRateAggNode(boolean distinct) {
        super(distinct);
    }

    public AggregationMethod validateAggregationChild(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        if (this.getChildNodes().size() == 0) {
            throw new ExprValidationException("The rate aggregation function minimally requires a numeric constant or expression as a parameter.");
        }
        ExprNode first = this.getChildNodes().get(0);
        if (first.isConstantResult()) {
            long intervalMSec;
            String message = "The rate aggregation function requires a numeric constant or time period as the first parameter in the constant-value notation";
            if (first instanceof ExprTimePeriod) {
                double secInterval = (Double)((ExprTimePeriod)first).evaluate(null, true, exprEvaluatorContext);
                intervalMSec = Math.round(secInterval * 1000.0);
            } else if (first instanceof ExprConstantNode) {
                if (!JavaClassHelper.isNumeric(first.getType())) {
                    throw new ExprValidationException(message);
                }
                Number num = (Number)first.evaluate(null, true, exprEvaluatorContext);
                intervalMSec = Math.round(num.doubleValue() * 1000.0);
            } else {
                throw new ExprValidationException(message);
            }
            return methodResolutionService.makeRateEverAggregator(intervalMSec);
        }
        String message = "The rate aggregation function requires a property or expression returning a non-constant long-type value as the first parameter in the timestamp-property notation";
        Class boxedParamOne = JavaClassHelper.getBoxedType(first.getType());
        if (boxedParamOne != Long.class) {
            throw new ExprValidationException(message);
        }
        if (first.isConstantResult()) {
            throw new ExprValidationException(message);
        }
        if (first instanceof ExprTimestampNode) {
            throw new ExprValidationException("The rate aggregation function does not allow the current engine timestamp as a parameter");
        }
        if (this.getChildNodes().size() > 1 && !JavaClassHelper.isNumeric(this.getChildNodes().get(1).getType())) {
            throw new ExprValidationException("The rate aggregation function accepts an expression returning a numeric value to accumulate as an optional second parameter");
        }
        boolean hasDataWindows = ExprNodeUtility.hasRemoveStream(first, streamTypeService);
        if (!hasDataWindows) {
            throw new ExprValidationException("The rate aggregation function in the timestamp-property notation requires data windows");
        }
        return methodResolutionService.makeRateAggregator();
    }

    protected String getAggregationFunctionName() {
        return "rate";
    }

    public final boolean equalsNodeAggregate(ExprAggregateNode node) {
        return node instanceof ExprRateAggNode;
    }
}

