/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.ViewResourceDelegate;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.util.JavaClassHelper;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ExprRegexpNode
extends ExprNode {
    private final boolean isNot;
    private Pattern pattern;
    private boolean isNumericValue;
    private boolean isConstantPattern;
    private static final long serialVersionUID = -837177267278295664L;

    public ExprRegexpNode(boolean not) {
        this.isNot = not;
    }

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        if (this.getChildNodes().size() != 2) {
            throw new ExprValidationException("The regexp operator requires 2 child expressions");
        }
        ExprNode patternChildNode = this.getChildNodes().get(1);
        Class patternChildType = patternChildNode.getType();
        if (patternChildType != String.class) {
            throw new ExprValidationException("The regexp operator requires a String-type pattern expression");
        }
        if (this.getChildNodes().get(1).isConstantResult()) {
            this.isConstantPattern = true;
        }
        Class evalChildType = this.getChildNodes().get(0).getType();
        this.isNumericValue = JavaClassHelper.isNumeric(evalChildType);
        if (evalChildType != String.class && !this.isNumericValue) {
            throw new ExprValidationException("The regexp operator requires a String or numeric type left-hand expression");
        }
    }

    public Class getType() {
        return Boolean.class;
    }

    public boolean isConstantResult() {
        return false;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object evalValue;
        String patternText;
        if (this.pattern == null) {
            patternText = (String)this.getChildNodes().get(1).evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (patternText == null) {
                return null;
            }
            try {
                this.pattern = Pattern.compile(patternText);
            }
            catch (PatternSyntaxException ex) {
                throw new EPException("Error compiling regex pattern '" + patternText + '\'', ex);
            }
        }
        if (!this.isConstantPattern) {
            patternText = (String)this.getChildNodes().get(1).evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (patternText == null) {
                return null;
            }
            try {
                this.pattern = Pattern.compile(patternText);
            }
            catch (PatternSyntaxException ex) {
                throw new EPException("Error compiling regex pattern '" + patternText + '\'', ex);
            }
        }
        if ((evalValue = this.getChildNodes().get(0).evaluate(eventsPerStream, isNewData, exprEvaluatorContext)) == null) {
            return null;
        }
        if (this.isNumericValue) {
            evalValue = evalValue.toString();
        }
        Boolean result = this.pattern.matcher((CharSequence)evalValue).matches();
        if (this.isNot) {
            return result == false;
        }
        return result;
    }

    public boolean equalsNode(ExprNode node_) {
        if (!(node_ instanceof ExprRegexpNode)) {
            return false;
        }
        ExprRegexpNode other = (ExprRegexpNode)node_;
        return this.isNot == other.isNot;
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getChildNodes().get(0).toExpressionString());
        if (this.isNot) {
            buffer.append(" not");
        }
        buffer.append(" regexp ");
        buffer.append(this.getChildNodes().get(1).toExpressionString());
        return buffer.toString();
    }

    public boolean isNot() {
        return this.isNot;
    }
}

