/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.ViewResourceDelegate;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.type.RelationalOpEnum;
import com.espertech.esper.util.JavaClassHelper;

public class ExprRelationalOpNode
extends ExprNode {
    private final RelationalOpEnum relationalOpEnum;
    private RelationalOpEnum.Computer computer;
    private static final long serialVersionUID = -6170161542681634598L;

    public ExprRelationalOpNode(RelationalOpEnum relationalOpEnum) {
        this.relationalOpEnum = relationalOpEnum;
    }

    public boolean isConstantResult() {
        return false;
    }

    public RelationalOpEnum getRelationalOpEnum() {
        return this.relationalOpEnum;
    }

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        if (this.getChildNodes().size() != 2) {
            throw new IllegalStateException("Relational op node does not have exactly 2 child nodes");
        }
        Class typeOne = JavaClassHelper.getBoxedType(this.getChildNodes().get(0).getType());
        Class typeTwo = JavaClassHelper.getBoxedType(this.getChildNodes().get(1).getType());
        if (typeOne != String.class || typeTwo != String.class) {
            if (!JavaClassHelper.isNumeric(typeOne)) {
                throw new ExprValidationException("Implicit conversion from datatype '" + typeOne.getSimpleName() + "' to numeric is not allowed");
            }
            if (!JavaClassHelper.isNumeric(typeTwo)) {
                throw new ExprValidationException("Implicit conversion from datatype '" + typeTwo.getSimpleName() + "' to numeric is not allowed");
            }
        }
        Class compareType = JavaClassHelper.getCompareToCoercionType(typeOne, typeTwo);
        this.computer = this.relationalOpEnum.getComputer(compareType, typeOne, typeTwo);
    }

    public Class getType() {
        return Boolean.class;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object valueLeft = this.getChildNodes().get(0).evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (valueLeft == null) {
            return null;
        }
        Object valueRight = this.getChildNodes().get(1).evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (valueRight == null) {
            return null;
        }
        return this.computer.compare(valueLeft, valueRight);
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getChildNodes().get(0).toExpressionString());
        buffer.append(this.relationalOpEnum.getExpressionText());
        buffer.append(this.getChildNodes().get(1).toExpressionString());
        return buffer.toString();
    }

    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprRelationalOpNode)) {
            return false;
        }
        ExprRelationalOpNode other = (ExprRelationalOpNode)node;
        return other.relationalOpEnum == this.relationalOpEnum;
    }
}

