/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.ViewResourceDelegate;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.schedule.TimeProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExprStaticMethodNode
extends ExprNode {
    private static final Log log = LogFactory.getLog(ExprStaticMethodNode.class);
    private final String className;
    private final String methodName;
    private Class[] paramTypes;
    private FastMethod staticMethod;
    private boolean isConstantParameters;
    private boolean isCachedResult;
    private Object cachedResult;
    private boolean isUseCache;
    private static final long serialVersionUID = -2237283743896280252L;

    public ExprStaticMethodNode(String className, String methodName, boolean isUseCache) {
        if (className == null) {
            throw new NullPointerException("Class name is null");
        }
        if (methodName == null) {
            throw new NullPointerException("Method name is null");
        }
        this.className = className;
        this.methodName = methodName;
        this.isUseCache = isUseCache;
    }

    public boolean isConstantResult() {
        return this.isConstantParameters;
    }

    protected Method getStaticMethod() {
        return this.staticMethod.getJavaMethod();
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class[] getParamTypes() {
        return this.paramTypes;
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.className);
        buffer.append('.');
        buffer.append(this.methodName);
        buffer.append('(');
        String appendString = "";
        for (ExprNode child : this.getChildNodes()) {
            buffer.append(appendString);
            buffer.append(child.toExpressionString());
            appendString = ", ";
        }
        buffer.append(')');
        return buffer.toString();
    }

    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprStaticMethodNode)) {
            return false;
        }
        if (this.staticMethod == null) {
            throw new IllegalStateException("ExprStaticMethodNode has not been validated");
        }
        ExprStaticMethodNode otherNode = (ExprStaticMethodNode)node;
        return this.staticMethod.equals(otherNode.staticMethod);
    }

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        ArrayList<ExprNode> childNodes = this.getChildNodes();
        this.paramTypes = new Class[childNodes.size()];
        int count = 0;
        boolean allConstants = true;
        for (ExprNode childNode : childNodes) {
            this.paramTypes[count++] = childNode.getType();
            if (childNode.isConstantResult()) continue;
            allConstants = false;
        }
        this.isConstantParameters = allConstants && this.isUseCache;
        try {
            Method method = methodResolutionService.resolveMethod(this.className, this.methodName, this.paramTypes);
            FastClass declaringClass = FastClass.create(Thread.currentThread().getContextClassLoader(), method.getDeclaringClass());
            this.staticMethod = declaringClass.getMethod(method);
        }
        catch (Exception e2) {
            throw new ExprValidationException(e2.getMessage());
        }
    }

    public Class getType() {
        if (this.staticMethod == null) {
            throw new IllegalStateException("ExprStaticMethodNode has not been validated");
        }
        return this.staticMethod.getReturnType();
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (this.isConstantParameters && this.isCachedResult) {
            return this.cachedResult;
        }
        ArrayList<ExprNode> childNodes = this.getChildNodes();
        Object[] args = new Object[childNodes.size()];
        int count = 0;
        for (ExprNode childNode : childNodes) {
            args[count++] = childNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        }
        Object obj = null;
        try {
            Object result = this.staticMethod.invoke(obj, args);
            if (this.isConstantParameters) {
                this.cachedResult = result;
                this.isCachedResult = true;
            }
            return result;
        }
        catch (InvocationTargetException e2) {
            String message = "Method '" + this.staticMethod.getName() + "' of class '" + this.className + "' reported an exception: " + e2.getTargetException();
            log.error(message, e2.getTargetException());
            return null;
        }
    }
}

