/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.ViewResourceDelegate;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.schedule.TimeProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExprStreamInstanceMethodNode
extends ExprNode {
    private static final Log log = LogFactory.getLog(ExprNode.class);
    private final String streamName;
    private final String methodName;
    private int streamNum = -1;
    private Class[] paramTypes;
    private FastMethod instanceMethod;
    private static final long serialVersionUID = 3422689488586035557L;

    public ExprStreamInstanceMethodNode(String streamName, String methodName) {
        if (streamName == null) {
            throw new NullPointerException("Stream name is null");
        }
        if (methodName == null) {
            throw new NullPointerException("Method name is null");
        }
        this.streamName = streamName;
        this.methodName = methodName;
    }

    public boolean isConstantResult() {
        return false;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class[] getParamTypes() {
        return this.paramTypes;
    }

    public int getStreamId() {
        if (this.streamNum == -1) {
            throw new IllegalStateException("Stream underlying node has not been validated");
        }
        return this.streamNum;
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.streamName);
        buffer.append('.');
        buffer.append(this.methodName);
        buffer.append('(');
        String appendString = "";
        for (ExprNode child : this.getChildNodes()) {
            buffer.append(appendString);
            buffer.append(child.toExpressionString());
            appendString = ", ";
        }
        buffer.append(')');
        return buffer.toString();
    }

    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprStreamInstanceMethodNode)) {
            return false;
        }
        if (this.instanceMethod == null) {
            throw new IllegalStateException("ExprStreamInstanceMethodNode has not been validated");
        }
        ExprStreamInstanceMethodNode otherNode = (ExprStreamInstanceMethodNode)node;
        return this.streamName.equals(otherNode.streamName) && this.instanceMethod.equals(otherNode.instanceMethod);
    }

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        ArrayList<ExprNode> childNodes = this.getChildNodes();
        this.paramTypes = new Class[childNodes.size()];
        int count = 0;
        for (ExprNode childNode : childNodes) {
            this.paramTypes[count++] = childNode.getType();
        }
        String[] streams = streamTypeService.getStreamNames();
        for (int i = 0; i < streams.length; ++i) {
            if (streams[i] == null || !streams[i].equals(this.streamName)) continue;
            this.streamNum = i;
            break;
        }
        if (this.streamNum == -1) {
            throw new ExprValidationException("Stream by name '" + this.streamName + "' could not be found among all streams");
        }
        EventType eventType = streamTypeService.getEventTypes()[this.streamNum];
        Class type = eventType.getUnderlyingType();
        try {
            Method method = methodResolutionService.resolveMethod(type, this.methodName, this.paramTypes);
            FastClass declaringClass = FastClass.create(Thread.currentThread().getContextClassLoader(), method.getDeclaringClass());
            this.instanceMethod = declaringClass.getMethod(method);
        }
        catch (Exception e2) {
            log.debug("Error resolving method for instance", e2);
            throw new ExprValidationException(e2.getMessage(), e2);
        }
    }

    public Class getType() {
        if (this.instanceMethod == null) {
            throw new IllegalStateException("ExprStaticMethodNode has not been validated");
        }
        return this.instanceMethod.getReturnType();
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean event = eventsPerStream[this.streamNum];
        if (event == null) {
            return null;
        }
        Object underlying = event.getUnderlying();
        ArrayList<ExprNode> childNodes = this.getChildNodes();
        Object[] args = new Object[childNodes.size()];
        int count = 0;
        for (ExprNode childNode : childNodes) {
            args[count++] = childNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        }
        try {
            return this.instanceMethod.invoke(underlying, args);
        }
        catch (InvocationTargetException e2) {
            log.warn("Error evaluating instance method by name '" + this.instanceMethod.getName() + "': " + e2.getMessage(), e2);
            return null;
        }
    }
}

