/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.ViewResourceDelegate;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.schedule.TimeProvider;

public class ExprStreamUnderlyingNode
extends ExprNode {
    private final String streamName;
    private int streamNum = -1;
    private Class type;
    private static final long serialVersionUID = 6611578192872250478L;

    public ExprStreamUnderlyingNode(String streamName) {
        if (streamName == null) {
            throw new IllegalArgumentException("Stream name is null");
        }
        this.streamName = streamName;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        String[] streams = streamTypeService.getStreamNames();
        for (int i = 0; i < streams.length; ++i) {
            if (streams[i] == null || !streams[i].equals(this.streamName)) continue;
            this.streamNum = i;
            break;
        }
        if (this.streamNum == -1) {
            throw new ExprValidationException("Stream by name '" + this.streamName + "' could not be found among all streams");
        }
        EventType eventType = streamTypeService.getEventTypes()[this.streamNum];
        this.type = eventType.getUnderlyingType();
    }

    public Class getType() {
        if (this.streamNum == -1) {
            throw new IllegalStateException("Stream underlying node has not been validated");
        }
        return this.type;
    }

    public boolean isConstantResult() {
        return false;
    }

    public int getStreamId() {
        if (this.streamNum == -1) {
            throw new IllegalStateException("Stream underlying node has not been validated");
        }
        return this.streamNum;
    }

    public String toString() {
        return "streamName=" + this.streamName + " streamNum=" + this.streamNum;
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean event = eventsPerStream[this.streamNum];
        if (event == null) {
            return null;
        }
        return event.getUnderlying();
    }

    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.streamName);
        return buffer.toString();
    }

    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprStreamUnderlyingNode)) {
            return false;
        }
        ExprStreamUnderlyingNode other = (ExprStreamUnderlyingNode)node;
        return this.streamName.equals(other.streamName);
    }
}

