/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.ViewResourceDelegate;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.expression.ExprVariableNode;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.util.JavaClassHelper;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExprTimePeriod
extends ExprNode {
    private static final Log log = LogFactory.getLog(ExprTimePeriod.class);
    private final boolean hasDay;
    private final boolean hasHour;
    private final boolean hasMinute;
    private final boolean hasSecond;
    private final boolean hasMillisecond;
    private boolean hasVariable;
    private static final long serialVersionUID = -7229827032500659319L;

    public ExprTimePeriod(boolean hasDay, boolean hasHour, boolean hasMinute, boolean hasSecond, boolean hasMillisecond) {
        this.hasDay = hasDay;
        this.hasHour = hasHour;
        this.hasMinute = hasMinute;
        this.hasSecond = hasSecond;
        this.hasMillisecond = hasMillisecond;
    }

    public boolean isHasDay() {
        return this.hasDay;
    }

    public boolean isHasHour() {
        return this.hasHour;
    }

    public boolean isHasMinute() {
        return this.hasMinute;
    }

    public boolean isHasSecond() {
        return this.hasSecond;
    }

    public boolean isHasMillisecond() {
        return this.hasMillisecond;
    }

    public boolean hasVariable() {
        return this.hasVariable;
    }

    public void validate(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        for (ExprNode childNode : this.getChildNodes()) {
            this.validate(childNode);
        }
    }

    private void validate(ExprNode expression) throws ExprValidationException {
        if (expression == null) {
            return;
        }
        Class returnType = expression.getType();
        if (!JavaClassHelper.isNumeric(returnType)) {
            throw new ExprValidationException("Time period expression requires a numeric parameter type");
        }
        if (expression instanceof ExprVariableNode) {
            this.hasVariable = true;
        }
    }

    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Double result;
        double seconds = 0.0;
        int exprCtr = 0;
        if (this.hasDay) {
            result = this.eval(this.getChildNodes().get(exprCtr++), eventsPerStream, exprEvaluatorContext);
            if (result == null) {
                return null;
            }
            seconds += result * 24.0 * 60.0 * 60.0;
        }
        if (this.hasHour) {
            result = this.eval(this.getChildNodes().get(exprCtr++), eventsPerStream, exprEvaluatorContext);
            if (result == null) {
                return null;
            }
            seconds += result * 60.0 * 60.0;
        }
        if (this.hasMinute) {
            result = this.eval(this.getChildNodes().get(exprCtr++), eventsPerStream, exprEvaluatorContext);
            if (result == null) {
                return null;
            }
            seconds += result * 60.0;
        }
        if (this.hasSecond) {
            result = this.eval(this.getChildNodes().get(exprCtr++), eventsPerStream, exprEvaluatorContext);
            if (result == null) {
                return null;
            }
            seconds += result.doubleValue();
        }
        if (this.hasMillisecond) {
            result = this.eval(this.getChildNodes().get(exprCtr), eventsPerStream, exprEvaluatorContext);
            if (result == null) {
                return null;
            }
            if (result != 0.0) {
                seconds += result / 1000.0;
            }
        }
        return seconds;
    }

    public Class getType() {
        return Double.class;
    }

    public boolean isConstantResult() {
        for (ExprNode child : this.getChildNodes()) {
            if (child.isConstantResult()) continue;
            return false;
        }
        return true;
    }

    public String toExpressionString() {
        StringBuffer buf = new StringBuffer();
        int exprCtr = 0;
        if (this.hasDay) {
            buf.append(this.getChildNodes().get(exprCtr++).toExpressionString());
            buf.append(" days ");
        }
        if (this.hasHour) {
            buf.append(this.getChildNodes().get(exprCtr++).toExpressionString());
            buf.append(" hours ");
        }
        if (this.hasMinute) {
            buf.append(this.getChildNodes().get(exprCtr++).toExpressionString());
            buf.append(" minutes ");
        }
        if (this.hasSecond) {
            buf.append(this.getChildNodes().get(exprCtr++).toExpressionString());
            buf.append(" seconds ");
        }
        if (this.hasMillisecond) {
            buf.append(this.getChildNodes().get(exprCtr).toExpressionString());
            buf.append(" milliseconds ");
        }
        return buf.toString();
    }

    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprTimePeriod)) {
            return false;
        }
        ExprTimePeriod other = (ExprTimePeriod)node;
        if (this.hasDay != other.hasDay) {
            return false;
        }
        if (this.hasHour != other.hasHour) {
            return false;
        }
        if (this.hasMinute != other.hasMinute) {
            return false;
        }
        if (this.hasSecond != other.hasSecond) {
            return false;
        }
        return this.hasMillisecond == other.hasMillisecond;
    }

    private Double eval(ExprNode expr, EventBean[] events, ExprEvaluatorContext exprEvaluatorContext) {
        Object value = expr.evaluate(events, true, exprEvaluatorContext);
        if (value == null) {
            log.warn("Time period expression returned a null value for expression '" + expr.toExpressionString() + "'");
            return null;
        }
        if (value instanceof BigDecimal) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof BigInteger) {
            return ((Number)value).doubleValue();
        }
        return ((Number)value).doubleValue();
    }
}

