/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprSubselectNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.expression.SubselectEvalStrategy;
import com.espertech.esper.epl.expression.SubselectEvalStrategyEqualsAll;
import com.espertech.esper.epl.expression.SubselectEvalStrategyEqualsAny;
import com.espertech.esper.epl.expression.SubselectEvalStrategyEqualsIn;
import com.espertech.esper.epl.expression.SubselectEvalStrategyRelOpAll;
import com.espertech.esper.epl.expression.SubselectEvalStrategyRelOpAny;
import com.espertech.esper.type.RelationalOpEnum;
import com.espertech.esper.util.CoercionException;
import com.espertech.esper.util.JavaClassHelper;
import java.util.Collection;
import java.util.Map;

public class SubselectEvalStrategyFactory {
    public static SubselectEvalStrategy createStrategy(ExprSubselectNode subselectExpression, boolean isNot, boolean isAll, boolean isAny, RelationalOpEnum relationalOp) throws ExprValidationException {
        Class coercionType;
        if (subselectExpression.getChildNodes().size() != 1) {
            throw new ExprValidationException("The Subselect-IN requires 1 child expression");
        }
        ExprNode valueExpr = subselectExpression.getChildNodes().get(0);
        Class typeOne = JavaClassHelper.getBoxedType(subselectExpression.getChildNodes().get(0).getType());
        if (typeOne.isArray() || JavaClassHelper.isImplementsInterface(typeOne, Collection.class) || JavaClassHelper.isImplementsInterface(typeOne, Map.class)) {
            throw new ExprValidationException("Collection or array comparison is not allowed for the IN, ANY, SOME or ALL keywords");
        }
        Class typeTwo = subselectExpression.getSelectClause() != null ? subselectExpression.getSelectClause().getType() : subselectExpression.getRawEventType().getUnderlyingType();
        if (relationalOp != null) {
            if (typeOne != String.class || typeTwo != String.class) {
                if (!JavaClassHelper.isNumeric(typeOne)) {
                    throw new ExprValidationException("Implicit conversion from datatype '" + typeOne.getSimpleName() + "' to numeric is not allowed");
                }
                if (!JavaClassHelper.isNumeric(typeTwo)) {
                    throw new ExprValidationException("Implicit conversion from datatype '" + typeTwo.getSimpleName() + "' to numeric is not allowed");
                }
            }
            Class compareType = JavaClassHelper.getCompareToCoercionType(typeOne, typeTwo);
            RelationalOpEnum.Computer computer = relationalOp.getComputer(compareType, typeOne, typeTwo);
            if (isAny) {
                return new SubselectEvalStrategyRelOpAny(computer, valueExpr, subselectExpression.getSelectClause(), subselectExpression.getFilterExpr());
            }
            return new SubselectEvalStrategyRelOpAll(computer, valueExpr, subselectExpression.getSelectClause(), subselectExpression.getFilterExpr());
        }
        try {
            coercionType = JavaClassHelper.getCompareToCoercionType(typeOne, typeTwo);
        }
        catch (CoercionException ex) {
            throw new ExprValidationException("Implicit conversion from datatype '" + typeTwo.getSimpleName() + "' to '" + typeOne.getSimpleName() + "' is not allowed");
        }
        boolean mustCoerce = false;
        if ((coercionType != JavaClassHelper.getBoxedType(typeOne) || coercionType != JavaClassHelper.getBoxedType(typeTwo)) && JavaClassHelper.isNumeric(coercionType)) {
            mustCoerce = true;
        }
        if (isAll) {
            return new SubselectEvalStrategyEqualsAll(isNot, mustCoerce, coercionType, valueExpr, subselectExpression.getSelectClause(), subselectExpression.getFilterExpr());
        }
        if (isAny) {
            return new SubselectEvalStrategyEqualsAny(isNot, mustCoerce, coercionType, valueExpr, subselectExpression.getSelectClause(), subselectExpression.getFilterExpr());
        }
        return new SubselectEvalStrategyEqualsIn(isNot, mustCoerce, coercionType, valueExpr, subselectExpression.getSelectClause(), subselectExpression.getFilterExpr());
    }
}

