/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.join.HistoricalIndexLookupStrategy;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTable;
import com.espertech.esper.event.EventBeanUtility;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoricalIndexLookupStrategyIndex
implements HistoricalIndexLookupStrategy {
    private final EventPropertyGetter[] propertyGetters;

    public HistoricalIndexLookupStrategyIndex(EventType eventType, String[] properties) {
        this.propertyGetters = new EventPropertyGetter[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            this.propertyGetters[i] = eventType.getGetter(properties[i]);
            if (this.propertyGetters[i] != null) continue;
            throw new IllegalArgumentException("Property named '" + properties[i] + "' is invalid for type " + eventType);
        }
    }

    @Override
    public Iterator<EventBean> lookup(EventBean lookupEvent, EventTable indexTable) {
        if (indexTable instanceof PropertyIndexedEventTable) {
            PropertyIndexedEventTable index = (PropertyIndexedEventTable)indexTable;
            Object[] keys = this.getKeys(lookupEvent);
            Set<EventBean> events = index.lookup(keys);
            if (events != null) {
                return events.iterator();
            }
            return null;
        }
        return indexTable.iterator();
    }

    private Object[] getKeys(EventBean event) {
        return EventBeanUtility.getPropertyArray(event, this.propertyGetters);
    }
}

