/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.join.JoinSetComposer;
import com.espertech.esper.epl.join.QueryStrategy;
import com.espertech.esper.epl.join.table.EventTable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinSetComposerImpl
implements JoinSetComposer {
    private final EventTable[][] repositories;
    private final QueryStrategy[] queryStrategies;
    private final boolean isPureSelfJoin;
    private final ExprEvaluatorContext exprEvaluatorContext;
    private Set<MultiKey<EventBean>> oldResults = new LinkedHashSet<MultiKey<EventBean>>();
    private Set<MultiKey<EventBean>> newResults = new LinkedHashSet<MultiKey<EventBean>>();

    public JoinSetComposerImpl(EventTable[][] repositories, QueryStrategy[] queryStrategies, boolean isPureSelfJoin, ExprEvaluatorContext exprEvaluatorContext) {
        this.repositories = repositories;
        this.queryStrategies = queryStrategies;
        this.isPureSelfJoin = isPureSelfJoin;
        this.exprEvaluatorContext = exprEvaluatorContext;
    }

    @Override
    public void init(EventBean[][] eventsPerStream) {
        for (int i = 0; i < eventsPerStream.length; ++i) {
            if (eventsPerStream[i] == null) continue;
            for (int j = 0; j < this.repositories[i].length; ++j) {
                this.repositories[i][j].add(eventsPerStream[i]);
            }
        }
    }

    @Override
    public void destroy() {
        for (int i = 0; i < this.repositories.length; ++i) {
            if (this.repositories[i] == null) continue;
            for (EventTable table : this.repositories[i]) {
                table.clear();
            }
        }
    }

    @Override
    public UniformPair<Set<MultiKey<EventBean>>> join(EventBean[][] newDataPerStream, EventBean[][] oldDataPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        int j;
        int i;
        this.oldResults.clear();
        this.newResults.clear();
        for (i = 0; i < oldDataPerStream.length; ++i) {
            if (oldDataPerStream[i] == null) continue;
            this.queryStrategies[i].lookup(oldDataPerStream[i], this.oldResults, exprEvaluatorContext);
        }
        for (i = 0; i < newDataPerStream.length; ++i) {
            if (newDataPerStream[i] == null) continue;
            for (j = 0; j < this.repositories[i].length; ++j) {
                this.repositories[i][j].add(newDataPerStream[i]);
            }
        }
        for (i = 0; i < oldDataPerStream.length; ++i) {
            if (oldDataPerStream[i] == null) continue;
            for (j = 0; j < this.repositories[i].length; ++j) {
                this.repositories[i][j].remove(oldDataPerStream[i]);
            }
        }
        for (i = 0; i < newDataPerStream.length; ++i) {
            if (newDataPerStream[i] == null) continue;
            this.queryStrategies[i].lookup(newDataPerStream[i], this.newResults, exprEvaluatorContext);
        }
        if (this.isPureSelfJoin) {
            EventTable[][] arr$ = this.repositories;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                EventTable[] repository;
                for (EventTable aRepository : repository = arr$[i$]) {
                    aRepository.clear();
                }
            }
        }
        return new UniformPair<Set<MultiKey<EventBean>>>(this.newResults, this.oldResults);
    }

    protected EventTable[][] getTables() {
        return this.repositories;
    }

    protected QueryStrategy[] getQueryStrategies() {
        return this.queryStrategies;
    }

    @Override
    public Set<MultiKey<EventBean>> staticJoin() {
        LinkedHashSet<MultiKey<EventBean>> result = new LinkedHashSet<MultiKey<EventBean>>();
        EventBean[] lookupEvents = new EventBean[1];
        for (int stream = 0; stream < this.queryStrategies.length; ++stream) {
            if (this.repositories[stream] == null) continue;
            Iterator<EventBean> streamEvents = this.repositories[stream][0].iterator();
            while (streamEvents.hasNext()) {
                lookupEvents[0] = streamEvents.next();
                this.queryStrategies[stream].lookup(lookupEvents, result, this.exprEvaluatorContext);
            }
        }
        return result;
    }
}

