/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.join.JoinSetProcessor;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinSetFilter
implements JoinSetProcessor {
    private ExprNode filterExprNode;

    public JoinSetFilter(ExprNode filterExprNode) {
        this.filterExprNode = filterExprNode;
    }

    @Override
    public void process(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents, ExprEvaluatorContext exprEvaluatorContext) {
        if (this.filterExprNode != null) {
            JoinSetFilter.filter(this.filterExprNode, newEvents, true, exprEvaluatorContext);
            if (oldEvents != null) {
                JoinSetFilter.filter(this.filterExprNode, oldEvents, false, exprEvaluatorContext);
            }
        }
    }

    protected static void filter(ExprNode filterExprNode, Set<MultiKey<EventBean>> events, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Iterator<MultiKey<EventBean>> it = events.iterator();
        while (it.hasNext()) {
            MultiKey<EventBean> key = it.next();
            EventBean[] eventArr = key.getArray();
            Boolean matched = (Boolean)filterExprNode.evaluate(eventArr, isNewData, exprEvaluatorContext);
            if (matched != null && matched.booleanValue()) continue;
            it.remove();
        }
    }
}

