/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.assemble;

import com.espertech.esper.epl.join.assemble.ResultAssembler;
import com.espertech.esper.epl.join.rep.Node;
import com.espertech.esper.util.IndentWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseAssemblyNode
implements ResultAssembler {
    protected ResultAssembler parentNode;
    protected final List<BaseAssemblyNode> childNodes;
    protected final int streamNum;
    protected final int numStreams;

    protected BaseAssemblyNode(int streamNum, int numStreams) {
        this.streamNum = streamNum;
        this.numStreams = numStreams;
        this.childNodes = new LinkedList<BaseAssemblyNode>();
    }

    public abstract void init(List<Node>[] var1);

    public abstract void process(List<Node>[] var1);

    public abstract void print(IndentWriter var1);

    public void setParentAssembler(ResultAssembler resultAssembler) {
        this.parentNode = resultAssembler;
    }

    public void addChild(BaseAssemblyNode childNode) {
        childNode.parentNode = this;
        this.childNodes.add(childNode);
    }

    protected int getStreamNum() {
        return this.streamNum;
    }

    protected List<BaseAssemblyNode> getChildNodes() {
        return this.childNodes;
    }

    protected ResultAssembler getParentAssembler() {
        return this.parentNode;
    }

    protected int[] getSubstreams() {
        LinkedList<Integer> substreams = new LinkedList<Integer>();
        this.recusiveAddSubstreams(substreams);
        int[] substreamArr = new int[substreams.size()];
        int count = 0;
        for (Integer stream : substreams) {
            substreamArr[count++] = stream;
        }
        return substreamArr;
    }

    private void recusiveAddSubstreams(List<Integer> substreams) {
        substreams.add(this.streamNum);
        for (BaseAssemblyNode child : this.childNodes) {
            child.recusiveAddSubstreams(substreams);
        }
    }

    public void printDescendends(IndentWriter indentWriter) {
        this.print(indentWriter);
        for (BaseAssemblyNode child : this.childNodes) {
            indentWriter.incrIndent();
            child.print(indentWriter);
            indentWriter.decrIndent();
        }
    }

    public static List<BaseAssemblyNode> getDescendentNodesBottomUp(BaseAssemblyNode topNode) {
        int deepLevel;
        LinkedList<BaseAssemblyNode> result = new LinkedList<BaseAssemblyNode>();
        TreeMap<Integer, List<BaseAssemblyNode>> nodesPerLevel = new TreeMap<Integer, List<BaseAssemblyNode>>();
        BaseAssemblyNode.recursiveAggregateEnter(topNode, nodesPerLevel, 1);
        if (nodesPerLevel.isEmpty()) {
            throw new IllegalStateException("Empty collection for nodes per level");
        }
        for (int i = deepLevel = nodesPerLevel.lastKey().intValue(); i >= 1; --i) {
            List<BaseAssemblyNode> list = nodesPerLevel.get(i);
            if (list == null) continue;
            result.addAll(list);
        }
        return result;
    }

    private static void recursiveAggregateEnter(BaseAssemblyNode currentNode, Map<Integer, List<BaseAssemblyNode>> nodesPerLevel, int currentLevel) {
        for (BaseAssemblyNode node : currentNode.childNodes) {
            BaseAssemblyNode.recursiveAggregateEnter(node, nodesPerLevel, currentLevel + 1);
        }
        List<BaseAssemblyNode> aggregates = nodesPerLevel.get(currentLevel);
        if (aggregates == null) {
            aggregates = new LinkedList<BaseAssemblyNode>();
            nodesPerLevel.put(currentLevel, aggregates);
        }
        aggregates.add(currentNode);
    }
}

