/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.exec;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.join.HistoricalIndexLookupStrategy;
import com.espertech.esper.epl.join.PollResultIndexingStrategy;
import com.espertech.esper.epl.join.exec.TableLookupStrategy;
import com.espertech.esper.epl.join.rep.Cursor;
import com.espertech.esper.epl.join.rep.Node;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.view.HistoricalEventViewable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoricalTableLookupStrategy
implements TableLookupStrategy {
    private final HistoricalEventViewable viewable;
    private final PollResultIndexingStrategy indexingStrategy;
    private final HistoricalIndexLookupStrategy lookupStrategy;
    private final int streamNum;
    private final int rootStreamNum;
    private final ExprNode outerJoinExprNode;
    private final EventBean[][] lookupEventsPerStream;

    public HistoricalTableLookupStrategy(HistoricalEventViewable viewable, PollResultIndexingStrategy indexingStrategy, HistoricalIndexLookupStrategy lookupStrategy, int numStreams, int streamNum, int rootStreamNum, ExprNode outerJoinExprNode) {
        this.viewable = viewable;
        this.indexingStrategy = indexingStrategy;
        this.lookupStrategy = lookupStrategy;
        this.streamNum = streamNum;
        this.rootStreamNum = rootStreamNum;
        this.outerJoinExprNode = outerJoinExprNode;
        this.lookupEventsPerStream = new EventBean[1][numStreams];
    }

    @Override
    public Set<EventBean> lookup(EventBean event, Cursor cursor, ExprEvaluatorContext exprEvaluatorContext) {
        int currStream = cursor.getStream();
        this.lookupEventsPerStream[0][currStream] = event;
        this.recursiveFill(this.lookupEventsPerStream[0], cursor.getNode());
        EventTable[] indexPerLookupRow = this.viewable.poll(this.lookupEventsPerStream, this.indexingStrategy, exprEvaluatorContext);
        HashSet<EventBean> result = null;
        for (EventTable index : indexPerLookupRow) {
            Iterator<EventBean> subsetIter = this.lookupStrategy.lookup(event, index);
            if (subsetIter == null) continue;
            while (subsetIter.hasNext()) {
                EventBean candidate;
                this.lookupEventsPerStream[0][this.streamNum] = candidate = subsetIter.next();
                Boolean pass = (Boolean)this.outerJoinExprNode.evaluate(this.lookupEventsPerStream[0], true, exprEvaluatorContext);
                if (pass == null || !pass.booleanValue()) continue;
                if (result == null) {
                    result = new HashSet<EventBean>();
                }
                result.add(candidate);
            }
        }
        return result;
    }

    private void recursiveFill(EventBean[] lookupEventsPerStream, Node node) {
        if (node == null) {
            return;
        }
        Node parent = node.getParent();
        if (parent == null) {
            lookupEventsPerStream[this.rootStreamNum] = node.getParentEvent();
            return;
        }
        lookupEventsPerStream[parent.getStream()] = parent.getParentEvent();
        this.recursiveFill(lookupEventsPerStream, parent);
    }
}

