/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.exec;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.join.exec.TableLookupStrategy;
import com.espertech.esper.epl.join.rep.Cursor;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTable;
import com.espertech.esper.event.EventBeanUtility;
import java.util.Arrays;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedTableLookupStrategy
implements TableLookupStrategy {
    private final EventType eventType;
    private final String[] properties;
    private final PropertyIndexedEventTable index;
    private final EventPropertyGetter[] propertyGetters;

    public IndexedTableLookupStrategy(EventType eventType, String[] properties, PropertyIndexedEventTable index) {
        this.eventType = eventType;
        this.properties = properties;
        this.index = index;
        this.propertyGetters = new EventPropertyGetter[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            this.propertyGetters[i] = eventType.getGetter(properties[i]);
            if (this.propertyGetters[i] != null) continue;
            throw new IllegalArgumentException("Property named '" + properties[i] + "' is invalid for type " + eventType);
        }
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public String[] getProperties() {
        return this.properties;
    }

    public PropertyIndexedEventTable getIndex() {
        return this.index;
    }

    @Override
    public Set<EventBean> lookup(EventBean event, Cursor cursor, ExprEvaluatorContext exprEvaluatorContext) {
        Object[] keys = this.getKeys(event);
        return this.index.lookup(keys);
    }

    private Object[] getKeys(EventBean event) {
        return EventBeanUtility.getPropertyArray(event, this.propertyGetters);
    }

    public String toString() {
        return "IndexedTableLookupStrategy indexProps=" + Arrays.toString(this.properties) + " index=(" + this.index + ')';
    }
}

