/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.join.HistoricalIndexLookupStrategy;
import com.espertech.esper.epl.join.PollResultIndexingStrategy;
import com.espertech.esper.epl.join.exec.ExecNode;
import com.espertech.esper.epl.join.exec.HistoricalDataExecNode;
import com.espertech.esper.epl.join.exec.HistoricalTableLookupStrategy;
import com.espertech.esper.epl.join.plan.QueryPlanNode;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.HistoricalStreamIndexList;
import com.espertech.esper.util.IndentWriter;
import com.espertech.esper.view.HistoricalEventViewable;
import com.espertech.esper.view.Viewable;

public class HistoricalDataPlanNode
extends QueryPlanNode {
    private final int streamNum;
    private final int rootStreamNum;
    private final int lookupStreamNum;
    private final int numStreams;
    private final ExprNode outerJoinExprNode;

    public HistoricalDataPlanNode(int streamNum, int rootStreamNum, int lookupStreamNum, int numStreams, ExprNode exprNode) {
        this.streamNum = streamNum;
        this.rootStreamNum = rootStreamNum;
        this.lookupStreamNum = lookupStreamNum;
        this.numStreams = numStreams;
        this.outerJoinExprNode = exprNode;
    }

    public ExecNode makeExec(EventTable[][] indexesPerStream, EventType[] streamTypes, Viewable[] streamViews, HistoricalStreamIndexList[] historicalStreamIndexLists) {
        Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy> pair = historicalStreamIndexLists[this.streamNum].getStrategy(this.lookupStreamNum);
        HistoricalEventViewable viewable = (HistoricalEventViewable)streamViews[this.streamNum];
        return new HistoricalDataExecNode(viewable, pair.getSecond(), pair.getFirst(), this.numStreams, this.streamNum);
    }

    public HistoricalTableLookupStrategy makeOuterJoinStategy(Viewable[] streamViews, int pollingStreamNum, HistoricalStreamIndexList[] historicalStreamIndexLists) {
        Pair<HistoricalIndexLookupStrategy, PollResultIndexingStrategy> pair = historicalStreamIndexLists[this.streamNum].getStrategy(pollingStreamNum);
        HistoricalEventViewable viewable = (HistoricalEventViewable)streamViews[this.streamNum];
        return new HistoricalTableLookupStrategy(viewable, pair.getSecond(), pair.getFirst(), this.numStreams, this.streamNum, this.rootStreamNum, this.outerJoinExprNode);
    }

    protected void print(IndentWriter writer) {
        writer.incrIndent();
        writer.println("HistoricalDataPlanNode streamNum=" + this.streamNum);
    }
}

