/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.join.assemble.BaseAssemblyNode;
import com.espertech.esper.epl.join.exec.ExecNode;
import com.espertech.esper.epl.join.exec.LookupInstructionExec;
import com.espertech.esper.epl.join.exec.LookupInstructionExecNode;
import com.espertech.esper.epl.join.plan.LookupInstructionPlan;
import com.espertech.esper.epl.join.plan.QueryPlanNode;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.HistoricalStreamIndexList;
import com.espertech.esper.util.IndentWriter;
import com.espertech.esper.view.Viewable;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LookupInstructionQueryPlanNode
extends QueryPlanNode {
    private final int rootStream;
    private final String rootStreamName;
    private final int numStreams;
    private final List<LookupInstructionPlan> lookupInstructions;
    private final boolean[] requiredPerStream;
    private final List<BaseAssemblyNode> assemblyInstructions;

    public LookupInstructionQueryPlanNode(int rootStream, String rootStreamName, int numStreams, boolean[] requiredPerStream, List<LookupInstructionPlan> lookupInstructions, List<BaseAssemblyNode> assemblyInstructions) {
        this.rootStream = rootStream;
        this.rootStreamName = rootStreamName;
        this.lookupInstructions = lookupInstructions;
        this.numStreams = numStreams;
        this.requiredPerStream = requiredPerStream;
        this.assemblyInstructions = assemblyInstructions;
    }

    @Override
    public ExecNode makeExec(EventTable[][] indexesPerStream, EventType[] streamTypes, Viewable[] streamViews, HistoricalStreamIndexList[] historicalStreamIndexLists) {
        LookupInstructionExec[] execs = new LookupInstructionExec[this.lookupInstructions.size()];
        int count = 0;
        for (LookupInstructionPlan instruction : this.lookupInstructions) {
            LookupInstructionExec exec;
            execs[count] = exec = instruction.makeExec(indexesPerStream, streamTypes, streamViews, historicalStreamIndexLists);
            ++count;
        }
        return new LookupInstructionExecNode(this.rootStream, this.rootStreamName, this.numStreams, execs, this.requiredPerStream, this.assemblyInstructions.toArray(new BaseAssemblyNode[this.assemblyInstructions.size()]));
    }

    @Override
    protected void print(IndentWriter writer) {
        int i;
        writer.println("LookupInstructionQueryPlanNode rootStream=" + this.rootStream + " requiredPerStream=" + Arrays.toString(this.requiredPerStream));
        writer.incrIndent();
        for (i = 0; i < this.lookupInstructions.size(); ++i) {
            writer.println("lookup step " + i);
            writer.incrIndent();
            this.lookupInstructions.get(i).print(writer);
            writer.decrIndent();
        }
        writer.decrIndent();
        writer.incrIndent();
        for (i = 0; i < this.assemblyInstructions.size(); ++i) {
            writer.println("assembly step " + i);
            writer.incrIndent();
            this.assemblyInstructions.get(i).print(writer);
            writer.decrIndent();
        }
        writer.decrIndent();
    }
}

