/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.NumberSetPermutationEnumeration;
import com.espertech.esper.collection.NumberSetShiftGroupEnumeration;
import com.espertech.esper.epl.join.plan.FullTableScanLookupPlan;
import com.espertech.esper.epl.join.plan.HistoricalDataPlanNode;
import com.espertech.esper.epl.join.plan.IndexedTableLookupPlan;
import com.espertech.esper.epl.join.plan.NestedIterationNode;
import com.espertech.esper.epl.join.plan.QueryGraph;
import com.espertech.esper.epl.join.plan.QueryPlan;
import com.espertech.esper.epl.join.plan.QueryPlanIndex;
import com.espertech.esper.epl.join.plan.QueryPlanIndexBuilder;
import com.espertech.esper.epl.join.plan.QueryPlanNode;
import com.espertech.esper.epl.join.plan.TableLookupNode;
import com.espertech.esper.epl.join.plan.TableLookupPlan;
import com.espertech.esper.epl.join.plan.TwoStreamQueryPlanBuilder;
import com.espertech.esper.epl.join.table.HistoricalStreamIndexList;
import com.espertech.esper.util.DependencyGraph;
import com.espertech.esper.util.JavaClassHelper;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NStreamQueryPlanBuilder {
    private static Log log = LogFactory.getLog(NStreamQueryPlanBuilder.class);

    protected static QueryPlan build(QueryGraph queryGraph, EventType[] typesPerStream, boolean hasHistorical, boolean[] isHistorical, DependencyGraph dependencyGraph, HistoricalStreamIndexList[] historicalStreamIndexLists) {
        if (log.isDebugEnabled()) {
            log.debug(".build queryGraph=" + queryGraph);
        }
        int numStreams = queryGraph.getNumStreams();
        QueryPlanIndex[] indexSpecs = QueryPlanIndexBuilder.buildIndexSpec(queryGraph);
        if (log.isDebugEnabled()) {
            log.debug(".build Index build completed, indexes=" + QueryPlanIndex.print(indexSpecs));
        }
        if (hasHistorical) {
            for (int i = 0; i < isHistorical.length; ++i) {
                if (!isHistorical[i]) continue;
                indexSpecs[i] = null;
            }
        }
        QueryPlanNode[] planNodeSpecs = new QueryPlanNode[numStreams];
        for (int streamNo = 0; streamNo < numStreams; ++streamNo) {
            if (isHistorical[streamNo] && dependencyGraph.hasDependency(streamNo)) continue;
            BestChainResult bestChainResult = NStreamQueryPlanBuilder.computeBestPath(streamNo, queryGraph, dependencyGraph);
            int[] bestChain = bestChainResult.getChain();
            if (log.isDebugEnabled()) {
                log.debug(".build For stream " + streamNo + " bestChain=" + Arrays.toString(bestChain));
            }
            planNodeSpecs[streamNo] = NStreamQueryPlanBuilder.createStreamPlan(streamNo, bestChain, queryGraph, indexSpecs, typesPerStream, isHistorical, historicalStreamIndexLists);
            if (!log.isDebugEnabled()) continue;
            log.debug(".build spec=" + planNodeSpecs[streamNo]);
        }
        return new QueryPlan(indexSpecs, planNodeSpecs);
    }

    protected static QueryPlanNode createStreamPlan(int lookupStream, int[] bestChain, QueryGraph queryGraph, QueryPlanIndex[] indexSpecsPerStream, EventType[] typesPerStream, boolean[] isHistorical, HistoricalStreamIndexList[] historicalStreamIndexLists) {
        NestedIterationNode nestedIterNode = new NestedIterationNode(bestChain);
        int currentLookupStream = lookupStream;
        for (int i = 0; i < bestChain.length; ++i) {
            QueryPlanNode node;
            int indexedStream = bestChain[i];
            if (isHistorical[indexedStream]) {
                if (historicalStreamIndexLists[indexedStream] == null) {
                    historicalStreamIndexLists[indexedStream] = new HistoricalStreamIndexList(indexedStream, typesPerStream, queryGraph);
                }
                historicalStreamIndexLists[indexedStream].addIndex(currentLookupStream);
                node = new HistoricalDataPlanNode(indexedStream, lookupStream, currentLookupStream, typesPerStream.length, null);
            } else {
                TableLookupPlan tableLookupPlan = NStreamQueryPlanBuilder.createLookupPlan(queryGraph, currentLookupStream, indexedStream, indexSpecsPerStream[indexedStream], typesPerStream);
                node = new TableLookupNode(tableLookupPlan);
            }
            nestedIterNode.addChildNode(node);
            currentLookupStream = bestChain[i];
        }
        return nestedIterNode;
    }

    protected static TableLookupPlan createLookupPlan(QueryGraph queryGraph, int currentLookupStream, int indexedStream, QueryPlanIndex indexSpecs, EventType[] typesPerStream) {
        TableLookupPlan tableLookupPlan;
        Object[] indexedStreamIndexProps = queryGraph.getIndexProperties(currentLookupStream, indexedStream);
        if (indexedStreamIndexProps != null) {
            int indexNum = indexSpecs.getIndexNum((String[])indexedStreamIndexProps);
            if (indexNum == -1) {
                throw new IllegalStateException("Failed to query plan as index for " + Arrays.toString(indexedStreamIndexProps) + " could looked up in the index specification");
            }
            String[] keyGenFields = queryGraph.getKeyProperties(currentLookupStream, indexedStream);
            tableLookupPlan = new IndexedTableLookupPlan(currentLookupStream, indexedStream, indexNum, keyGenFields);
            Class[] coercionTypes = TwoStreamQueryPlanBuilder.getCoercionTypes(typesPerStream, currentLookupStream, indexedStream, keyGenFields, (String[])indexedStreamIndexProps);
            if (coercionTypes != null) {
                Class[] existCoercionTypes = indexSpecs.getCoercionTypes((String[])indexedStreamIndexProps);
                if (existCoercionTypes != null) {
                    for (int i = 0; i < existCoercionTypes.length; ++i) {
                        coercionTypes[i] = JavaClassHelper.getCompareToCoercionType(existCoercionTypes[i], coercionTypes[i]);
                    }
                }
                indexSpecs.setCoercionTypes((String[])indexedStreamIndexProps, coercionTypes);
            }
        } else {
            int indexNum = indexSpecs.getIndexNum(new String[0]);
            if (indexNum == -1) {
                indexNum = indexSpecs.addIndex(new String[0], null);
            }
            tableLookupPlan = new FullTableScanLookupPlan(currentLookupStream, indexedStream, indexNum);
        }
        return tableLookupPlan;
    }

    protected static BestChainResult computeBestPath(int lookupStream, QueryGraph queryGraph, DependencyGraph dependencyGraph) {
        int[] defNestingorder = NStreamQueryPlanBuilder.buildDefaultNestingOrder(queryGraph.getNumStreams(), lookupStream);
        Enumeration<int[]> streamEnum = defNestingorder.length < 6 ? new NumberSetPermutationEnumeration(defNestingorder) : new NumberSetShiftGroupEnumeration(defNestingorder);
        int[] bestPermutation = null;
        int bestDepth = -1;
        while (streamEnum.hasMoreElements()) {
            boolean pass;
            int[] permutation = streamEnum.nextElement();
            if (dependencyGraph != null && !(pass = NStreamQueryPlanBuilder.isDependencySatisfied(lookupStream, permutation, dependencyGraph))) continue;
            int permutationDepth = NStreamQueryPlanBuilder.computeNavigableDepth(lookupStream, permutation, queryGraph);
            if (permutationDepth > bestDepth) {
                bestPermutation = permutation;
                bestDepth = permutationDepth;
            }
            if (permutationDepth != queryGraph.getNumStreams() - 1) continue;
            break;
        }
        return new BestChainResult(bestDepth, bestPermutation);
    }

    protected static boolean isDependencySatisfied(int lookupStream, int[] permutation, DependencyGraph dependencyGraph) {
        for (Map.Entry<Integer, SortedSet<Integer>> entry : dependencyGraph.getDependencies().entrySet()) {
            int target = entry.getKey();
            int positionTarget = NStreamQueryPlanBuilder.positionOf(target, lookupStream, permutation);
            if (positionTarget == -1) {
                throw new IllegalArgumentException("Target dependency not found in permutation for target " + target + " and permutation " + Arrays.toString(permutation) + " and lookup stream " + lookupStream);
            }
            Iterator i$ = entry.getValue().iterator();
            while (i$.hasNext()) {
                int dependency = (Integer)i$.next();
                int positonDep = NStreamQueryPlanBuilder.positionOf(dependency, lookupStream, permutation);
                if (positonDep == -1) {
                    throw new IllegalArgumentException("Dependency not found in permutation for dependency " + dependency + " and permutation " + Arrays.toString(permutation) + " and lookup stream " + lookupStream);
                }
                if (positonDep <= positionTarget) continue;
                return false;
            }
        }
        return true;
    }

    private static int positionOf(int stream, int lookupStream, int[] permutation) {
        if (stream == lookupStream) {
            return 0;
        }
        for (int i = 0; i < permutation.length; ++i) {
            if (permutation[i] != stream) continue;
            return i + 1;
        }
        return -1;
    }

    protected static int computeNavigableDepth(int lookupStream, int[] nextStreams, QueryGraph queryGraph) {
        int nextStream;
        int currentStream = lookupStream;
        int currentDepth = 0;
        for (int i = 0; i < nextStreams.length && queryGraph.isNavigable(currentStream, nextStream = nextStreams[i]); ++i) {
            currentStream = nextStream;
            ++currentDepth;
        }
        return currentDepth;
    }

    protected static QueryPlan buildNStreamDefaultQuerySpec(EventType[] eventTypes) {
        QueryPlanIndex[] indexSpecs = new QueryPlanIndex[eventTypes.length];
        QueryPlanNode[] execNodeSpecs = new QueryPlanNode[eventTypes.length];
        for (int i = 0; i < indexSpecs.length; ++i) {
            indexSpecs[i] = new QueryPlanIndex(null, null);
        }
        for (int streamNo = 0; streamNo < eventTypes.length; ++streamNo) {
            int[] nestingOrder = NStreamQueryPlanBuilder.buildDefaultNestingOrder(eventTypes.length, streamNo);
            NestedIterationNode nestedNode = new NestedIterationNode(nestingOrder);
            execNodeSpecs[streamNo] = nestedNode;
            int lookupStream = streamNo;
            for (int j = 0; j < nestingOrder.length; ++j) {
                int indexedStream = nestingOrder[j];
                FullTableScanLookupPlan scanLookupStrategy = new FullTableScanLookupPlan(lookupStream, indexedStream, 0);
                nestedNode.addChildNode(new TableLookupNode(scanLookupStrategy));
                lookupStream = indexedStream;
            }
        }
        return new QueryPlan(indexSpecs, execNodeSpecs);
    }

    protected static int[] buildDefaultNestingOrder(int numStreams, int forStream) {
        int[] nestingOrder = new int[numStreams - 1];
        int count = 0;
        for (int i = 0; i < numStreams; ++i) {
            if (i == forStream) continue;
            nestingOrder[count++] = i;
        }
        return nestingOrder;
    }

    private static Class[] getCoercionTypes(EventType[] typesPerStream, int lookupStream, int indexedStream, String[] keyProps, String[] indexProps) {
        if (indexProps.length != keyProps.length) {
            throw new IllegalStateException("Mismatch in the number of key and index properties");
        }
        Class[] coercionTypes = new Class[indexProps.length];
        boolean mustCoerce = false;
        for (int i = 0; i < keyProps.length; ++i) {
            Class indexedPropType;
            Class keyPropType = JavaClassHelper.getBoxedType(typesPerStream[lookupStream].getPropertyType(keyProps[i]));
            Class coercionType = indexedPropType = JavaClassHelper.getBoxedType(typesPerStream[indexedStream].getPropertyType(indexProps[i]));
            if (keyPropType != indexedPropType) {
                coercionType = JavaClassHelper.getCompareToCoercionType(keyPropType, keyPropType);
                mustCoerce = true;
            }
            coercionTypes[i] = coercionType;
        }
        if (!mustCoerce) {
            return null;
        }
        return coercionTypes;
    }

    public static class BestChainResult {
        private int depth;
        private int[] chain;

        public BestChainResult(int depth, int[] chain) {
            this.depth = depth;
            this.chain = chain;
        }

        public int getDepth() {
            return this.depth;
        }

        public int[] getChain() {
            return this.chain;
        }

        public String toString() {
            return "depth=" + this.depth + " chain=" + Arrays.toString(this.chain);
        }
    }
}

