/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.epl.join.plan.QueryGraph;
import com.espertech.esper.epl.join.plan.QueryPlanIndex;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;

public class QueryPlanIndexBuilder {
    public static QueryPlanIndex[] buildIndexSpec(QueryGraph queryGraph) {
        int numStreams = queryGraph.getNumStreams();
        QueryPlanIndex[] indexSpecs = new QueryPlanIndex[numStreams];
        for (int streamIndexed = 0; streamIndexed < numStreams; ++streamIndexed) {
            String[][] indexProps;
            HashSet<MultiKey<Object>> indexesSetSortedProps = new HashSet<MultiKey<Object>>();
            LinkedList<String[]> indexesList = new LinkedList<String[]>();
            for (int streamLookup = 0; streamLookup < numStreams; ++streamLookup) {
                String[] indexProps2;
                if (streamIndexed == streamLookup || (indexProps2 = queryGraph.getIndexProperties(streamLookup, streamIndexed)) == null) continue;
                Object[] indexPropsSorted = new String[indexProps2.length];
                System.arraycopy(indexProps2, 0, indexPropsSorted, 0, indexProps2.length);
                Arrays.sort(indexPropsSorted);
                MultiKey<Object> indexPropsUniqueKey = new MultiKey<Object>(indexPropsSorted);
                if (indexesSetSortedProps.contains(indexPropsUniqueKey)) continue;
                indexesSetSortedProps.add(indexPropsUniqueKey);
                indexesList.add(indexProps2);
            }
            if (!indexesList.isEmpty()) {
                indexProps = new String[indexesList.size()][];
                int count = 0;
                for (String[] entry : indexesList) {
                    indexProps[count] = entry;
                    ++count;
                }
            } else {
                indexProps = new String[1][0];
                indexProps[0] = new String[0];
            }
            indexSpecs[streamIndexed] = new QueryPlanIndex(indexProps, new Class[indexProps.length][]);
        }
        return indexSpecs;
    }
}

