/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.table;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKeyUntyped;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyIndexedEventTableIterator
implements Iterator<EventBean> {
    private final Map<MultiKeyUntyped, Set<EventBean>> window;
    private final Iterator<MultiKeyUntyped> keyIterator;
    private Iterator<EventBean> currentListIterator;

    public PropertyIndexedEventTableIterator(Map<MultiKeyUntyped, Set<EventBean>> window) {
        this.window = window;
        this.keyIterator = window.keySet().iterator();
        if (this.keyIterator.hasNext()) {
            MultiKeyUntyped initialKey = this.keyIterator.next();
            this.currentListIterator = window.get(initialKey).iterator();
        }
    }

    @Override
    public final EventBean next() {
        if (this.currentListIterator == null) {
            throw new NoSuchElementException();
        }
        EventBean eventBean = this.currentListIterator.next();
        if (!this.currentListIterator.hasNext()) {
            this.currentListIterator = null;
            if (this.keyIterator.hasNext()) {
                MultiKeyUntyped nextKey = this.keyIterator.next();
                this.currentListIterator = this.window.get(nextKey).iterator();
            }
        }
        return eventBean;
    }

    @Override
    public final boolean hasNext() {
        if (this.currentListIterator == null) {
            return false;
        }
        if (this.currentListIterator.hasNext()) {
            return true;
        }
        this.currentListIterator = null;
        return this.keyIterator.hasNext();
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }
}

