/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.metric;

import com.espertech.esper.client.metric.EngineMetric;
import com.espertech.esper.epl.metric.MetricEventRouter;
import com.espertech.esper.epl.metric.MetricExec;
import com.espertech.esper.epl.metric.MetricExecutionContext;
import com.espertech.esper.epl.metric.MetricScheduleService;

public class MetricExecEngine
implements MetricExec {
    private final MetricEventRouter metricEventRouter;
    private final String engineURI;
    private final MetricScheduleService metricScheduleService;
    private final long interval;

    public MetricExecEngine(MetricEventRouter metricEventRouter, String engineURI, MetricScheduleService metricScheduleService, long interval) {
        this.metricEventRouter = metricEventRouter;
        this.engineURI = engineURI;
        this.metricScheduleService = metricScheduleService;
        this.interval = interval;
    }

    public void execute(MetricExecutionContext context) {
        long inputCount = context.getServices().getFilterService().getNumEventsEvaluated();
        long schedDepth = context.getServices().getSchedulingService().getScheduleHandleCount();
        EngineMetric metric = new EngineMetric(this.engineURI, this.metricScheduleService.getCurrentTime(), inputCount, schedDepth);
        this.metricEventRouter.route(metric);
        this.metricScheduleService.add(this.interval, this);
    }

    public long getInterval() {
        return this.interval;
    }
}

