/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.PropertyIndTableCoerceAdd;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTable;
import com.espertech.esper.epl.named.IndexedPropDesc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedWindowIndexRepository {
    private List<PropertyIndexedEventTable> tables = new ArrayList<PropertyIndexedEventTable>();
    private Map<MultiKey<IndexedPropDesc>, Pair<PropertyIndexedEventTable, Integer>> tableIndexes = new HashMap<MultiKey<IndexedPropDesc>, Pair<PropertyIndexedEventTable, Integer>>();

    public PropertyIndexedEventTable addTable(IndexedPropDesc[] indexedPropDescs, Iterable<EventBean> prefilledEvents, EventType indexedType, boolean mustCoerce) {
        MultiKey<IndexedPropDesc> indexPropKey = new MultiKey<IndexedPropDesc>(indexedPropDescs);
        Pair<PropertyIndexedEventTable, Integer> refTablePair = this.tableIndexes.get(indexPropKey);
        if (refTablePair != null) {
            refTablePair.setSecond(refTablePair.getSecond() + 1);
            return refTablePair.getFirst();
        }
        String[] indexProps = IndexedPropDesc.getIndexProperties(indexedPropDescs);
        Class[] coercionTypes = IndexedPropDesc.getCoercionTypes(indexedPropDescs);
        PropertyIndexedEventTable table = !mustCoerce ? new PropertyIndexedEventTable(0, indexedType, indexProps, coercionTypes) : new PropertyIndTableCoerceAdd(0, indexedType, indexProps, coercionTypes);
        EventBean[] events = new EventBean[1];
        Iterator<EventBean> i$ = prefilledEvents.iterator();
        while (i$.hasNext()) {
            EventBean prefilledEvent;
            events[0] = prefilledEvent = i$.next();
            table.add(events);
        }
        this.tables.add(table);
        this.tableIndexes.put(indexPropKey, new Pair<PropertyIndexedEventTable, Integer>(table, 1));
        return table;
    }

    public void removeTableReference(EventTable table) {
        for (Map.Entry<MultiKey<IndexedPropDesc>, Pair<PropertyIndexedEventTable, Integer>> entry : this.tableIndexes.entrySet()) {
            if (entry.getValue().getFirst() != table) continue;
            int current = entry.getValue().getSecond();
            if (current > 1) {
                entry.getValue().setSecond(--current);
                break;
            }
            this.tables.remove(table);
            this.tableIndexes.remove(entry.getKey());
            break;
        }
    }

    public List<PropertyIndexedEventTable> getTables() {
        return this.tables;
    }

    public void destroy() {
        this.tables.clear();
        this.tableIndexes.clear();
    }
}

