/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ArrayEventIterator;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.EPStatementHandle;
import com.espertech.esper.core.InternalEventRouter;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.core.StatementResultService;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.named.LookupStrategy;
import com.espertech.esper.epl.named.NamedWindowOnExprBaseView;
import com.espertech.esper.epl.named.NamedWindowRootView;
import com.espertech.esper.event.EventBeanReader;
import com.espertech.esper.event.EventBeanReaderDefaultImpl;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.view.StatementStopService;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedWindowOnSelectView
extends NamedWindowOnExprBaseView {
    private static final Log log = LogFactory.getLog(NamedWindowOnSelectView.class);
    private final InternalEventRouter internalEventRouter;
    private final boolean addToFront;
    private final ResultSetProcessor resultSetProcessor;
    private final EPStatementHandle statementHandle;
    private final StatementResultService statementResultService;
    private final StatementContext statementContext;
    private EventBean[] lastResult;
    private Set<MultiKey<EventBean>> oldEvents = new HashSet<MultiKey<EventBean>>();
    private boolean isDistinct;
    private EventBeanReader eventBeanReader;

    public NamedWindowOnSelectView(StatementStopService statementStopService, LookupStrategy lookupStrategy, NamedWindowRootView rootView, InternalEventRouter internalEventRouter, boolean addToFront, ResultSetProcessor resultSetProcessor, EPStatementHandle statementHandle, StatementResultService statementResultService, StatementContext statementContext, boolean isDistinct) {
        super(statementStopService, lookupStrategy, rootView, statementContext);
        this.internalEventRouter = internalEventRouter;
        this.addToFront = addToFront;
        this.resultSetProcessor = resultSetProcessor;
        this.statementHandle = statementHandle;
        this.statementResultService = statementResultService;
        this.statementContext = statementContext;
        this.isDistinct = isDistinct;
        if (isDistinct) {
            if (resultSetProcessor.getResultEventType() instanceof EventTypeSPI) {
                this.eventBeanReader = ((EventTypeSPI)resultSetProcessor.getResultEventType()).getReader();
            }
            if (this.eventBeanReader == null) {
                this.eventBeanReader = new EventBeanReaderDefaultImpl(resultSetProcessor.getResultEventType());
            }
        }
    }

    @Override
    public void handleMatching(EventBean[] triggerEvents, EventBean[] matchingEvents) {
        EventBean[] newData;
        this.resultSetProcessor.clear();
        HashSet<MultiKey<EventBean>> newEvents = new HashSet<MultiKey<EventBean>>();
        for (int i = 0; i < triggerEvents.length; ++i) {
            EventBean triggerEvent = triggerEvents[0];
            if (matchingEvents == null) continue;
            for (int j = 0; j < matchingEvents.length; ++j) {
                EventBean[] eventsPerStream = new EventBean[]{matchingEvents[j], triggerEvent};
                newEvents.add(new MultiKey<EventBean>(eventsPerStream));
            }
        }
        UniformPair<EventBean[]> pair = this.resultSetProcessor.processJoinResult(newEvents, this.oldEvents, false);
        EventBean[] eventBeanArray = newData = pair != null ? pair.getFirst() : null;
        if (this.isDistinct) {
            newData = EventBeanUtility.getDistinctByProp(newData, this.eventBeanReader);
        }
        if (this.internalEventRouter != null && newData != null) {
            for (int i = 0; i < newData.length; ++i) {
                this.internalEventRouter.route(newData[i], this.statementHandle, this.statementContext.getInternalEventEngineRouteDest(), this.statementContext, this.addToFront);
            }
        }
        if (newData != null && newData.length > 0 && (this.statementResultService.isMakeNatural() || this.statementResultService.isMakeSynthetic())) {
            this.updateChildren(newData, null);
        }
        this.lastResult = newData;
    }

    @Override
    public EventType getEventType() {
        if (this.resultSetProcessor != null) {
            return this.resultSetProcessor.getResultEventType();
        }
        return this.namedWindowEventType;
    }

    @Override
    public Iterator<EventBean> iterator() {
        return new ArrayEventIterator(this.lastResult);
    }
}

