/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.EPStatementHandle;
import com.espertech.esper.core.StatementLockFactory;
import com.espertech.esper.core.StatementResultService;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.named.NamedWindowConsumerDispatchUnit;
import com.espertech.esper.epl.named.NamedWindowConsumerView;
import com.espertech.esper.epl.named.NamedWindowDeltaData;
import com.espertech.esper.epl.named.NamedWindowLifecycleEvent;
import com.espertech.esper.epl.named.NamedWindowLifecycleObserver;
import com.espertech.esper.epl.named.NamedWindowProcessor;
import com.espertech.esper.epl.named.NamedWindowService;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.event.vaevent.ValueAddEventProcessor;
import com.espertech.esper.util.ManagedLock;
import com.espertech.esper.view.ViewProcessingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedWindowServiceImpl
implements NamedWindowService {
    private final Map<String, NamedWindowProcessor> processors;
    private final Map<String, ManagedLock> windowStatementLocks;
    private final StatementLockFactory statementLockFactory;
    private final VariableService variableService;
    private final Set<NamedWindowLifecycleObserver> observers;
    private final boolean isPrioritized;
    private ThreadLocal<List<NamedWindowConsumerDispatchUnit>> threadLocal = new ThreadLocal<List<NamedWindowConsumerDispatchUnit>>(){

        @Override
        protected synchronized List<NamedWindowConsumerDispatchUnit> initialValue() {
            return new ArrayList<NamedWindowConsumerDispatchUnit>(100);
        }
    };
    private ThreadLocal<Map<EPStatementHandle, Object>> dispatchesPerStmtTL = new ThreadLocal<Map<EPStatementHandle, Object>>(){

        @Override
        protected synchronized Map<EPStatementHandle, Object> initialValue() {
            return new HashMap<EPStatementHandle, Object>();
        }
    };

    public NamedWindowServiceImpl(StatementLockFactory statementLockFactory, VariableService variableService, boolean isPrioritized) {
        this.processors = new HashMap<String, NamedWindowProcessor>();
        this.windowStatementLocks = new HashMap<String, ManagedLock>();
        this.statementLockFactory = statementLockFactory;
        this.variableService = variableService;
        this.observers = new HashSet<NamedWindowLifecycleObserver>();
        this.isPrioritized = isPrioritized;
    }

    @Override
    public void destroy() {
        this.processors.clear();
        this.threadLocal.remove();
        this.dispatchesPerStmtTL.remove();
    }

    @Override
    public String[] getNamedWindows() {
        Set<String> names = this.processors.keySet();
        return names.toArray(new String[names.size()]);
    }

    @Override
    public ManagedLock getNamedWindowLock(String windowName) {
        return this.windowStatementLocks.get(windowName);
    }

    @Override
    public void addNamedWindowLock(String windowName, ManagedLock statementResourceLock) {
        this.windowStatementLocks.put(windowName, statementResourceLock);
    }

    @Override
    public boolean isNamedWindow(String name) {
        return this.processors.containsKey(name);
    }

    @Override
    public NamedWindowProcessor getProcessor(String name) throws ExprValidationException {
        NamedWindowProcessor processor = this.processors.get(name);
        if (processor == null) {
            throw new ExprValidationException("A named window by name '" + name + "' does not exist");
        }
        return processor;
    }

    @Override
    public NamedWindowProcessor addProcessor(String name, EventType eventType, EPStatementHandle createWindowStmtHandle, StatementResultService statementResultService, ValueAddEventProcessor revisionProcessor, String eplExpression, String statementName, boolean isPrioritized, ExprEvaluatorContext exprEvaluatorContext) throws ViewProcessingException {
        if (this.processors.containsKey(name)) {
            throw new ViewProcessingException("A named window by name '" + name + "' has already been created");
        }
        NamedWindowProcessor processor = new NamedWindowProcessor(this, name, eventType, createWindowStmtHandle, statementResultService, revisionProcessor, eplExpression, statementName, isPrioritized, exprEvaluatorContext);
        this.processors.put(name, processor);
        if (!this.observers.isEmpty()) {
            NamedWindowLifecycleEvent event = new NamedWindowLifecycleEvent(name, processor, NamedWindowLifecycleEvent.LifecycleEventType.CREATE, new Object[0]);
            for (NamedWindowLifecycleObserver observer : this.observers) {
                observer.observe(event);
            }
        }
        return processor;
    }

    @Override
    public void removeProcessor(String name) {
        NamedWindowProcessor processor = this.processors.get(name);
        if (processor != null) {
            processor.destroy();
            this.processors.remove(name);
            if (!this.observers.isEmpty()) {
                NamedWindowLifecycleEvent event = new NamedWindowLifecycleEvent(name, processor, NamedWindowLifecycleEvent.LifecycleEventType.DESTROY, new Object[0]);
                for (NamedWindowLifecycleObserver observer : this.observers) {
                    observer.observe(event);
                }
            }
        }
    }

    @Override
    public void addDispatch(NamedWindowDeltaData delta, Map<EPStatementHandle, List<NamedWindowConsumerView>> consumers) {
        NamedWindowConsumerDispatchUnit unit = new NamedWindowConsumerDispatchUnit(delta, consumers);
        this.threadLocal.get().add(unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dispatch(ExprEvaluatorContext exprEvaluatorContext) {
        List<NamedWindowConsumerDispatchUnit> dispatches = this.threadLocal.get();
        if (dispatches.isEmpty()) {
            return false;
        }
        if (dispatches.size() == 1) {
            NamedWindowConsumerDispatchUnit unit = dispatches.get(0);
            EventBean[] newData = unit.getDeltaData().getNewData();
            EventBean[] eventBeanArray = unit.getDeltaData().getOldData();
            for (Map.Entry<EPStatementHandle, List<NamedWindowConsumerView>> entry : unit.getDispatchTo().entrySet()) {
                EPStatementHandle handle = entry.getKey();
                handle.getStatementLock().acquireLock(this.statementLockFactory);
                try {
                    if (handle.isHasVariables()) {
                        this.variableService.setLocalVersion();
                    }
                    for (NamedWindowConsumerView consumerView : entry.getValue()) {
                        consumerView.update(newData, eventBeanArray);
                    }
                    handle.internalDispatch(exprEvaluatorContext);
                }
                finally {
                    handle.getStatementLock().releaseLock(null);
                }
                if (!this.isPrioritized || !handle.isPreemptive()) continue;
                break;
            }
            dispatches.clear();
            return true;
        }
        Map<EPStatementHandle, Object> dispatchesPerStmt = this.dispatchesPerStmtTL.get();
        for (NamedWindowConsumerDispatchUnit namedWindowConsumerDispatchUnit : dispatches) {
            for (Map.Entry<EPStatementHandle, List<NamedWindowConsumerView>> entry : namedWindowConsumerDispatchUnit.getDispatchTo().entrySet()) {
                EPStatementHandle handle = entry.getKey();
                Object perStmtObj = dispatchesPerStmt.get(handle);
                if (perStmtObj == null) {
                    dispatchesPerStmt.put(handle, namedWindowConsumerDispatchUnit);
                    continue;
                }
                if (perStmtObj instanceof List) {
                    List list = (List)perStmtObj;
                    list.add(namedWindowConsumerDispatchUnit);
                    continue;
                }
                NamedWindowConsumerDispatchUnit unitObj = (NamedWindowConsumerDispatchUnit)perStmtObj;
                ArrayList<NamedWindowConsumerDispatchUnit> arrayList = new ArrayList<NamedWindowConsumerDispatchUnit>();
                arrayList.add(unitObj);
                arrayList.add(namedWindowConsumerDispatchUnit);
                dispatchesPerStmt.put(handle, arrayList);
            }
        }
        for (Map.Entry entry : dispatchesPerStmt.entrySet()) {
            EPStatementHandle handle = (EPStatementHandle)entry.getKey();
            Object perStmtObj = entry.getValue();
            if (perStmtObj instanceof NamedWindowConsumerDispatchUnit) {
                NamedWindowConsumerDispatchUnit unit = (NamedWindowConsumerDispatchUnit)perStmtObj;
                EventBean[] newData = unit.getDeltaData().getNewData();
                EventBean[] oldData = unit.getDeltaData().getOldData();
                handle.getStatementLock().acquireLock(this.statementLockFactory);
                try {
                    if (handle.isHasVariables()) {
                        this.variableService.setLocalVersion();
                    }
                    for (NamedWindowConsumerView consumerView : unit.getDispatchTo().get(handle)) {
                        consumerView.update(newData, oldData);
                    }
                    handle.internalDispatch(exprEvaluatorContext);
                }
                finally {
                    handle.getStatementLock().releaseLock(null);
                }
                if (!this.isPrioritized || !handle.isPreemptive()) continue;
                break;
            }
            List list = (List)perStmtObj;
            LinkedHashMap<NamedWindowConsumerView, NamedWindowDeltaData> deltaPerConsumer = new LinkedHashMap<NamedWindowConsumerView, NamedWindowDeltaData>();
            for (NamedWindowConsumerDispatchUnit namedWindowConsumerDispatchUnit : list) {
                for (NamedWindowConsumerView consumerView : namedWindowConsumerDispatchUnit.getDispatchTo().get(handle)) {
                    NamedWindowDeltaData deltaForConsumer = (NamedWindowDeltaData)deltaPerConsumer.get(consumerView);
                    if (deltaForConsumer == null) {
                        deltaPerConsumer.put(consumerView, namedWindowConsumerDispatchUnit.getDeltaData());
                        continue;
                    }
                    NamedWindowDeltaData aggregated = new NamedWindowDeltaData(deltaForConsumer, namedWindowConsumerDispatchUnit.getDeltaData());
                    deltaPerConsumer.put(consumerView, aggregated);
                }
            }
            handle.getStatementLock().acquireLock(this.statementLockFactory);
            try {
                if (handle.isHasVariables()) {
                    this.variableService.setLocalVersion();
                }
                for (Map.Entry entry2 : deltaPerConsumer.entrySet()) {
                    EventBean[] newData = ((NamedWindowDeltaData)entry2.getValue()).getNewData();
                    EventBean[] oldData = ((NamedWindowDeltaData)entry2.getValue()).getOldData();
                    ((NamedWindowConsumerView)entry2.getKey()).update(newData, oldData);
                }
                handle.internalDispatch(exprEvaluatorContext);
            }
            finally {
                handle.getStatementLock().releaseLock(null);
            }
            if (!this.isPrioritized || !handle.isPreemptive()) continue;
            break;
        }
        dispatches.clear();
        dispatchesPerStmt.clear();
        return true;
    }

    @Override
    public void addObserver(NamedWindowLifecycleObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void removeObserver(NamedWindowLifecycleObserver observer) {
        this.observers.remove(observer);
    }
}

