/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.parse;

import com.espertech.esper.type.BoolValue;
import com.espertech.esper.type.DoubleValue;
import com.espertech.esper.type.FloatValue;
import com.espertech.esper.type.IntValue;
import com.espertech.esper.type.LongValue;
import com.espertech.esper.type.StringValue;
import org.antlr.runtime.tree.Tree;

public class ASTConstantHelper {
    public static String removeTicks(String tickedString) {
        int indexLast;
        int indexFirst = tickedString.indexOf(96);
        if (indexFirst != (indexLast = tickedString.lastIndexOf(96)) && indexFirst != -1 && indexLast != -1) {
            return tickedString.substring(indexFirst + 1, indexLast);
        }
        return tickedString;
    }

    public static Object parse(Tree node) {
        switch (node.getType()) {
            case 290: {
                return ASTConstantHelper.parseIntLongByte(node.getText());
            }
            case 240: {
                return ASTConstantHelper.parseIntLongByte(node.getText());
            }
            case 241: {
                return LongValue.parseString(node.getText());
            }
            case 245: {
                return BoolValue.parseString(node.getText());
            }
            case 242: {
                return Float.valueOf(FloatValue.parseString(node.getText()));
            }
            case 243: {
                return DoubleValue.parseString(node.getText());
            }
            case 244: {
                return StringValue.parseString(node.getText());
            }
            case 246: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unexpected constant of non-primitive type " + node.getType() + " encountered");
    }

    private static Object parseIntLongByte(String arg) {
        try {
            return IntValue.parseString(arg);
        }
        catch (NumberFormatException e1) {
            try {
                return LongValue.parseString(arg);
            }
            catch (Exception e2) {
                try {
                    return Byte.decode(arg);
                }
                catch (Exception e3) {
                    throw e1;
                }
            }
        }
    }
}

