/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.parse;

import com.espertech.esper.antlr.ASTUtil;
import com.espertech.esper.client.ConfigurationInformation;
import com.espertech.esper.client.EPException;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.EPAdministratorHelper;
import com.espertech.esper.epl.agg.AggregationSupport;
import com.espertech.esper.epl.core.EngineImportException;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.core.EngineImportUndefinedException;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.ExprAggregateNode;
import com.espertech.esper.epl.expression.ExprAndNode;
import com.espertech.esper.epl.expression.ExprArrayNode;
import com.espertech.esper.epl.expression.ExprAvedevNode;
import com.espertech.esper.epl.expression.ExprAvgNode;
import com.espertech.esper.epl.expression.ExprBetweenNode;
import com.espertech.esper.epl.expression.ExprBitWiseNode;
import com.espertech.esper.epl.expression.ExprCaseNode;
import com.espertech.esper.epl.expression.ExprCastNode;
import com.espertech.esper.epl.expression.ExprCoalesceNode;
import com.espertech.esper.epl.expression.ExprConcatNode;
import com.espertech.esper.epl.expression.ExprConstantNode;
import com.espertech.esper.epl.expression.ExprCountNode;
import com.espertech.esper.epl.expression.ExprEqualsAllAnyNode;
import com.espertech.esper.epl.expression.ExprEqualsNode;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprFirstNode;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprInNode;
import com.espertech.esper.epl.expression.ExprInstanceofNode;
import com.espertech.esper.epl.expression.ExprLastNode;
import com.espertech.esper.epl.expression.ExprLikeNode;
import com.espertech.esper.epl.expression.ExprMathNode;
import com.espertech.esper.epl.expression.ExprMedianNode;
import com.espertech.esper.epl.expression.ExprMinMaxAggrNode;
import com.espertech.esper.epl.expression.ExprMinMaxRowNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNotNode;
import com.espertech.esper.epl.expression.ExprNumberSetCronParam;
import com.espertech.esper.epl.expression.ExprNumberSetFrequency;
import com.espertech.esper.epl.expression.ExprNumberSetList;
import com.espertech.esper.epl.expression.ExprNumberSetRange;
import com.espertech.esper.epl.expression.ExprNumberSetWildcard;
import com.espertech.esper.epl.expression.ExprOrNode;
import com.espertech.esper.epl.expression.ExprOrderedExpr;
import com.espertech.esper.epl.expression.ExprPlugInAggFunctionNode;
import com.espertech.esper.epl.expression.ExprPreviousNode;
import com.espertech.esper.epl.expression.ExprPriorNode;
import com.espertech.esper.epl.expression.ExprPropertyExistsNode;
import com.espertech.esper.epl.expression.ExprRegexpNode;
import com.espertech.esper.epl.expression.ExprRelationalOpAllAnyNode;
import com.espertech.esper.epl.expression.ExprRelationalOpNode;
import com.espertech.esper.epl.expression.ExprStaticMethodNode;
import com.espertech.esper.epl.expression.ExprStddevNode;
import com.espertech.esper.epl.expression.ExprSubselectAllSomeAnyNode;
import com.espertech.esper.epl.expression.ExprSubselectExistsNode;
import com.espertech.esper.epl.expression.ExprSubselectInNode;
import com.espertech.esper.epl.expression.ExprSubselectRowNode;
import com.espertech.esper.epl.expression.ExprSubstitutionNode;
import com.espertech.esper.epl.expression.ExprSumNode;
import com.espertech.esper.epl.expression.ExprTimePeriod;
import com.espertech.esper.epl.expression.ExprTimestampNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.expression.ExprVariableNode;
import com.espertech.esper.epl.generated.EsperEPL2Ast;
import com.espertech.esper.epl.parse.ASTAnnotationHelper;
import com.espertech.esper.epl.parse.ASTConstantHelper;
import com.espertech.esper.epl.parse.ASTFilterSpecHelper;
import com.espertech.esper.epl.parse.ASTMatchRecognizeHelper;
import com.espertech.esper.epl.parse.ASTOutputLimitHelper;
import com.espertech.esper.epl.parse.ASTWalkException;
import com.espertech.esper.epl.spec.ColumnDesc;
import com.espertech.esper.epl.spec.CreateIndexDesc;
import com.espertech.esper.epl.spec.CreateSchemaDesc;
import com.espertech.esper.epl.spec.CreateVariableDesc;
import com.espertech.esper.epl.spec.CreateWindowDesc;
import com.espertech.esper.epl.spec.DBStatementStreamSpec;
import com.espertech.esper.epl.spec.FilterSpecRaw;
import com.espertech.esper.epl.spec.FilterStreamSpecRaw;
import com.espertech.esper.epl.spec.ForClauseItemSpec;
import com.espertech.esper.epl.spec.ForClauseSpec;
import com.espertech.esper.epl.spec.InsertIntoDesc;
import com.espertech.esper.epl.spec.MatchRecognizeDefineItem;
import com.espertech.esper.epl.spec.MatchRecognizeInterval;
import com.espertech.esper.epl.spec.MatchRecognizeMeasureItem;
import com.espertech.esper.epl.spec.MatchRecognizeSkipEnum;
import com.espertech.esper.epl.spec.MatchRecognizeSpec;
import com.espertech.esper.epl.spec.MethodStreamSpec;
import com.espertech.esper.epl.spec.OnTriggerSetAssignment;
import com.espertech.esper.epl.spec.OnTriggerSetDesc;
import com.espertech.esper.epl.spec.OnTriggerSplitStream;
import com.espertech.esper.epl.spec.OnTriggerSplitStreamDesc;
import com.espertech.esper.epl.spec.OnTriggerType;
import com.espertech.esper.epl.spec.OnTriggerWindowDesc;
import com.espertech.esper.epl.spec.OnTriggerWindowUpdateDesc;
import com.espertech.esper.epl.spec.OrderByItem;
import com.espertech.esper.epl.spec.OuterJoinDesc;
import com.espertech.esper.epl.spec.OutputLimitSpec;
import com.espertech.esper.epl.spec.PatternGuardSpec;
import com.espertech.esper.epl.spec.PatternObserverSpec;
import com.espertech.esper.epl.spec.PatternStreamSpecRaw;
import com.espertech.esper.epl.spec.PropertyEvalAtom;
import com.espertech.esper.epl.spec.PropertyEvalSpec;
import com.espertech.esper.epl.spec.RowLimitSpec;
import com.espertech.esper.epl.spec.SelectClauseElementRaw;
import com.espertech.esper.epl.spec.SelectClauseElementWildcard;
import com.espertech.esper.epl.spec.SelectClauseExprRawSpec;
import com.espertech.esper.epl.spec.SelectClauseSpecRaw;
import com.espertech.esper.epl.spec.SelectClauseStreamRawSpec;
import com.espertech.esper.epl.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.epl.spec.StatementSpecRaw;
import com.espertech.esper.epl.spec.StreamSpecBase;
import com.espertech.esper.epl.spec.StreamSpecOptions;
import com.espertech.esper.epl.spec.StreamSpecRaw;
import com.espertech.esper.epl.spec.UpdateDesc;
import com.espertech.esper.epl.spec.ViewSpec;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.pattern.EvalAndNode;
import com.espertech.esper.pattern.EvalEveryDistinctNode;
import com.espertech.esper.pattern.EvalEveryNode;
import com.espertech.esper.pattern.EvalFilterNode;
import com.espertech.esper.pattern.EvalFollowedByNode;
import com.espertech.esper.pattern.EvalGuardNode;
import com.espertech.esper.pattern.EvalMatchUntilNode;
import com.espertech.esper.pattern.EvalMatchUntilSpec;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalNotNode;
import com.espertech.esper.pattern.EvalObserverNode;
import com.espertech.esper.pattern.EvalOrNode;
import com.espertech.esper.pattern.guard.GuardEnum;
import com.espertech.esper.rowregex.RegexNFATypeEnum;
import com.espertech.esper.rowregex.RowRegexExprNode;
import com.espertech.esper.rowregex.RowRegexExprNodeAlteration;
import com.espertech.esper.rowregex.RowRegexExprNodeAtom;
import com.espertech.esper.rowregex.RowRegexExprNodeConcatenation;
import com.espertech.esper.rowregex.RowRegexExprNodeNested;
import com.espertech.esper.schedule.SchedulingService;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.type.BitWiseOpEnum;
import com.espertech.esper.type.CronOperatorEnum;
import com.espertech.esper.type.DoubleValue;
import com.espertech.esper.type.MathArithTypeEnum;
import com.espertech.esper.type.MinMaxTypeEnum;
import com.espertech.esper.type.OuterJoinType;
import com.espertech.esper.type.RelationalOpEnum;
import com.espertech.esper.type.StringValue;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.MetaDefItem;
import com.espertech.esper.util.PlaceholderParseException;
import com.espertech.esper.util.PlaceholderParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeNodeStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPLTreeWalker
extends EsperEPL2Ast {
    private Map<Tree, ExprNode> astExprNodeMap = new HashMap<Tree, ExprNode>();
    private final Stack<Map<Tree, ExprNode>> astExprNodeMapStack;
    private final Map<Tree, EvalNode> astPatternNodeMap = new HashMap<Tree, EvalNode>();
    private final Map<Tree, RowRegexExprNode> astRowRegexNodeMap = new HashMap<Tree, RowRegexExprNode>();
    private FilterSpecRaw filterSpec;
    private final List<ViewSpec> viewSpecs = new LinkedList<ViewSpec>();
    private List<ExprSubstitutionNode> substitutionParamNodes = new ArrayList<ExprSubstitutionNode>();
    private StatementSpecRaw statementSpec;
    private final Stack<StatementSpecRaw> statementSpecStack;
    private List<SelectClauseElementRaw> propertySelectRaw;
    private PropertyEvalSpec propertyEvalSpec;
    private final EngineImportService engineImportService;
    private final VariableService variableService;
    private final TimeProvider timeProvider;
    private final ExprEvaluatorContext exprEvaluatorContext;
    private final SelectClauseStreamSelectorEnum defaultStreamSelector;
    private final String engineURI;
    private final ConfigurationInformation configurationInformation;
    private final SchedulingService schedulingService;
    private static final Log log = LogFactory.getLog(EPLTreeWalker.class);

    public EPLTreeWalker(TreeNodeStream input, EngineImportService engineImportService, VariableService variableService, SchedulingService schedulingService, SelectClauseStreamSelectorEnum defaultStreamSelector, String engineURI, ConfigurationInformation configurationInformation) {
        super(input);
        this.engineImportService = engineImportService;
        this.variableService = variableService;
        this.defaultStreamSelector = defaultStreamSelector;
        this.timeProvider = schedulingService;
        this.exprEvaluatorContext = new ExprEvaluatorContext(){

            public TimeProvider getTimeProvider() {
                return EPLTreeWalker.this.timeProvider;
            }
        };
        this.engineURI = engineURI;
        this.configurationInformation = configurationInformation;
        this.schedulingService = schedulingService;
        if (defaultStreamSelector == null) {
            throw new IllegalArgumentException("Default stream selector is null");
        }
        this.statementSpec = new StatementSpecRaw(defaultStreamSelector);
        this.statementSpecStack = new Stack();
        this.astExprNodeMapStack = new Stack();
    }

    @Override
    protected void pushStmtContext() {
        if (log.isDebugEnabled()) {
            log.debug(".pushStmtContext");
        }
        this.statementSpecStack.push(this.statementSpec);
        this.astExprNodeMapStack.push(this.astExprNodeMap);
        this.statementSpec = new StatementSpecRaw(this.defaultStreamSelector);
        this.astExprNodeMap = new HashMap<Tree, ExprNode>();
    }

    public StatementSpecRaw getStatementSpec() {
        return this.statementSpec;
    }

    @Override
    protected void leaveNode(Tree node) throws ASTWalkException {
        MetaDefItem childEvalNode;
        Tree childNode;
        int i;
        if (log.isDebugEnabled()) {
            log.debug(".leaveNode " + node);
        }
        switch (node.getType()) {
            case 152: {
                this.leaveStreamExpr(node);
                break;
            }
            case 119: {
                this.leaveStreamFilter(node);
                break;
            }
            case 116: {
                this.leavePatternFilter(node);
                break;
            }
            case 137: {
                return;
            }
            case 136: {
                this.leaveView(node);
                break;
            }
            case 149: {
                this.leaveSelectClause(node);
                break;
            }
            case 193: {
                this.leaveWildcardSelect();
                break;
            }
            case 150: {
                this.leaveSelectionElement(node);
                break;
            }
            case 151: {
                this.leaveSelectionStream(node);
                break;
            }
            case 122: {
                this.leavePropertySelectionElement(node);
                break;
            }
            case 123: {
                this.leavePropertySelectionStream(node);
                break;
            }
            case 124: {
                this.leavePropertyWildcardSelect();
                break;
            }
            case 121: {
                this.leavePropertySelectAtom(node);
                break;
            }
            case 161: {
                this.leaveEventPropertyExpr(node);
                break;
            }
            case 142: {
                this.leaveJoinAndExpr(node);
                break;
            }
            case 143: {
                this.leaveJoinOrExpr(node);
                break;
            }
            case 144: 
            case 145: {
                this.leaveEqualsExpr(node);
                break;
            }
            case 146: 
            case 147: {
                this.leaveEqualsGroupExpr(node);
                break;
            }
            case 139: {
                this.leaveWhereClause();
                break;
            }
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 290: {
                this.leaveConstant(node);
                break;
            }
            case 205: {
                this.leaveSubstitution(node);
                break;
            }
            case 269: 
            case 271: 
            case 285: 
            case 286: 
            case 287: {
                this.leaveMath(node);
                break;
            }
            case 270: 
            case 276: 
            case 277: {
                this.leaveBitWise(node);
                break;
            }
            case 280: 
            case 281: 
            case 282: 
            case 283: {
                this.leaveRelationalOp(node);
                break;
            }
            case 22: {
                this.leaveCoalesce(node);
                break;
            }
            case 13: {
                this.leaveExprNot(node);
                break;
            }
            case 117: {
                this.leavePatternNot(node);
                break;
            }
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 232: 
            case 233: {
                this.leaveAggregate(node);
                break;
            }
            case 177: {
                this.leaveLibFunction(node);
                break;
            }
            case 154: 
            case 155: 
            case 156: 
            case 157: {
                this.leaveOuterInnerJoin(node);
                break;
            }
            case 158: {
                this.leaveGroupBy(node);
                break;
            }
            case 140: {
                this.leaveHavingClause();
                break;
            }
            case 159: {
                break;
            }
            case 160: {
                this.leaveOrderByElement(node);
                break;
            }
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 173: {
                this.leaveOutputLimit(node);
                break;
            }
            case 99: {
                this.leaveRowLimit(node);
                break;
            }
            case 174: {
                this.leaveInsertInto(node);
                break;
            }
            case 176: {
                this.leaveConcat(node);
                break;
            }
            case 28: {
                this.leaveCaseNode(node, false);
                break;
            }
            case 29: {
                this.leaveCaseNode(node, true);
                break;
            }
            case 14: {
                this.leaveEvery(node);
                break;
            }
            case 15: {
                this.leaveEveryDistinct(node);
                break;
            }
            case 114: {
                this.leaveFollowedBy(node);
                break;
            }
            case 11: {
                this.leaveOr(node);
                break;
            }
            case 12: {
                this.leaveAnd(node);
                break;
            }
            case 134: {
                this.leaveGuard(node);
                break;
            }
            case 135: {
                this.leaveObserver(node);
                break;
            }
            case 221: {
                this.leaveMatch(node);
                break;
            }
            case 6: 
            case 186: {
                this.leaveInSet(node);
                break;
            }
            case 195: 
            case 196: {
                this.leaveInRange(node);
                break;
            }
            case 7: 
            case 187: {
                this.leaveBetween(node);
                break;
            }
            case 8: 
            case 188: {
                this.leaveLike(node);
                break;
            }
            case 9: 
            case 189: {
                this.leaveRegexp(node);
                break;
            }
            case 69: {
                this.leavePrevious(node);
                break;
            }
            case 70: {
                this.leavePrior(node);
                break;
            }
            case 180: {
                this.leaveArray(node);
                break;
            }
            case 197: {
                this.leaveSubselectRow(node);
                break;
            }
            case 199: {
                this.leaveSubselectExists(node);
                break;
            }
            case 200: 
            case 201: {
                this.leaveSubselectIn(node);
                break;
            }
            case 202: {
                this.leaveSubselectQueryIn(node);
                break;
            }
            case 74: {
                this.leaveInstanceOf(node);
                break;
            }
            case 71: {
                this.leaveExists(node);
                break;
            }
            case 75: {
                this.leaveCast(node);
                break;
            }
            case 76: {
                this.leaveTimestamp(node);
                break;
            }
            case 208: {
                this.leaveCreateWindow(node);
                break;
            }
            case 207: {
                this.leaveCreateIndex(node);
                break;
            }
            case 236: {
                this.leaveCreateSchema(node);
                break;
            }
            case 209: {
                this.leaveCreateWindowSelect(node);
                break;
            }
            case 219: {
                this.leaveCreateVariable(node);
                break;
            }
            case 210: {
                this.leaveOnExpr(node);
                break;
            }
            case 234: {
                this.leaveUpdateExpr(node);
                break;
            }
            case 179: {
                this.leaveTimePeriod(node);
                break;
            }
            case 228: {
                this.leaveNumberSetStar(node);
                break;
            }
            case 112: {
                this.leaveNumberSetFrequency(node);
                break;
            }
            case 110: {
                this.leaveNumberSetRange(node);
                break;
            }
            case 111: {
                this.leaveNumberSetList(node);
                break;
            }
            case 53: 
            case 203: {
                this.leaveLastNumberSetOperator(node);
                break;
            }
            case 73: {
                this.leaveLastWeekdayNumberSetOperator(node);
                break;
            }
            case 204: {
                this.leaveWeekdayNumberSetOperator(node);
                break;
            }
            case 113: {
                this.leaveObjectParamOrderedExpression(node);
                break;
            }
            case 229: {
                this.leaveAnnotation(node);
                break;
            }
            case 259: {
                this.leaveMatchRecognizeMeasureItem(node);
                break;
            }
            case 249: {
                this.leaveMatchRecognizePattern(node);
                break;
            }
            case 253: {
                this.leaveMatchRecognizePatternNested(node);
                break;
            }
            case 251: {
                this.leaveMatchRecognizePatternConcat(node);
                break;
            }
            case 252: {
                this.leaveMatchRecognizePatternAlter(node);
                break;
            }
            case 250: {
                this.leaveMatchRecognizePatternAtom(node);
                break;
            }
            case 257: {
                this.leaveMatchRecognizeDefineItem(node);
                break;
            }
            case 260: {
                this.leaveMatchRecognizePartition(node);
                break;
            }
            case 102: {
                this.leaveMatchRecognize(node);
                break;
            }
            case 213: {
                this.leaveOnSelect(node);
                break;
            }
            case 211: {
                this.leaveOnStream(node);
                break;
            }
            case 108: {
                this.leaveForClause(node);
                break;
            }
            default: {
                throw new ASTWalkException("Unhandled node type encountered, type '" + node.getType() + "' with text '" + node.getText() + '\'');
            }
        }
        if (!this.astExprNodeMap.isEmpty()) {
            ExprNode thisEvalNode = this.astExprNodeMap.get(node);
            for (i = 0; i < node.getChildCount(); ++i) {
                childNode = node.getChild(i);
                childEvalNode = this.astExprNodeMap.get(childNode);
                if (childEvalNode == null || thisEvalNode == null) continue;
                thisEvalNode.addChildNode((ExprNode)childEvalNode);
                this.astExprNodeMap.remove(childNode);
            }
        }
        if (!this.astPatternNodeMap.isEmpty()) {
            EvalNode thisPatternNode = this.astPatternNodeMap.get(node);
            for (i = 0; i < node.getChildCount(); ++i) {
                childNode = node.getChild(i);
                childEvalNode = this.astPatternNodeMap.get(childNode);
                if (childEvalNode == null) continue;
                thisPatternNode.addChildNode((EvalNode)childEvalNode);
                this.astPatternNodeMap.remove(childNode);
            }
        }
        if (!this.astRowRegexNodeMap.isEmpty()) {
            RowRegexExprNode thisRegexNode = this.astRowRegexNodeMap.get(node);
            for (i = 0; i < node.getChildCount(); ++i) {
                childNode = node.getChild(i);
                childEvalNode = this.astRowRegexNodeMap.get(childNode);
                if (childEvalNode == null) continue;
                thisRegexNode.addChildNode((RowRegexExprNode)childEvalNode);
                this.astRowRegexNodeMap.remove(childNode);
            }
        }
    }

    private void leaveCreateWindow(Tree node) {
        log.debug(".leaveCreateWindow");
        String windowName = node.getChild(0).getText();
        String eventName = null;
        Tree eventNameNode = ASTUtil.findFirstNode(node, 133);
        if (eventNameNode != null) {
            eventName = eventNameNode.getText();
        }
        if (eventName == null) {
            eventName = "java.lang.Object";
        }
        boolean isRetainUnion = false;
        boolean isRetainIntersection = false;
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (node.getChild(i).getType() == 64) {
                isRetainUnion = true;
                break;
            }
            if (node.getChild(i).getType() != 65) continue;
            isRetainIntersection = true;
            break;
        }
        StreamSpecOptions streamSpecOptions = new StreamSpecOptions(false, isRetainUnion, isRetainIntersection);
        this.statementSpec.getSelectClauseSpec().addAll(this.getColTypeList(node));
        boolean isInsert = false;
        ExprNode insertWhereExpr = null;
        Tree insertNode = ASTUtil.findFirstNode(node, 54);
        if (insertNode != null) {
            isInsert = true;
            if (insertNode.getChildCount() > 0) {
                insertWhereExpr = ASTUtil.getRemoveExpr(insertNode.getChild(0), this.astExprNodeMap);
            }
        }
        CreateWindowDesc desc = new CreateWindowDesc(windowName, this.viewSpecs, streamSpecOptions, isInsert, insertWhereExpr);
        this.statementSpec.setCreateWindowDesc(desc);
        FilterSpecRaw rawFilterSpec = new FilterSpecRaw(eventName, new LinkedList<ExprNode>(), null);
        FilterStreamSpecRaw streamSpec = new FilterStreamSpecRaw(rawFilterSpec, new LinkedList<ViewSpec>(), null, streamSpecOptions);
        this.statementSpec.getStreamSpecs().add(streamSpec);
    }

    private List<SelectClauseElementRaw> getColTypeList(Tree node) {
        ArrayList<SelectClauseElementRaw> result = new ArrayList<SelectClauseElementRaw>();
        for (int nodeNum = 0; nodeNum < node.getChildCount(); ++nodeNum) {
            if (node.getChild(nodeNum).getType() != 226) continue;
            Tree parent = node.getChild(nodeNum);
            for (int i = 0; i < parent.getChildCount(); ++i) {
                String name = parent.getChild(i).getChild(0).getText();
                String type = parent.getChild(i).getChild(1).getText();
                Class clazz = JavaClassHelper.getClassForSimpleName(type);
                if (clazz == null) {
                    throw new ASTWalkException("The type '" + type + "' is not a recognized type");
                }
                SelectClauseExprRawSpec selectElement = new SelectClauseExprRawSpec(new ExprConstantNode(clazz), name);
                result.add(selectElement);
            }
        }
        return result;
    }

    private void leaveCreateIndex(Tree node) {
        log.debug(".leaveCreateIndex");
        String indexName = node.getChild(0).getText();
        String windowName = node.getChild(1).getText();
        Tree nodeExpr = node.getChild(2);
        ArrayList<String> columns = new ArrayList<String>();
        for (int i = 0; i < nodeExpr.getChildCount(); ++i) {
            if (nodeExpr.getChild(i).getType() != 262) continue;
            columns.add(nodeExpr.getChild(i).getText());
        }
        this.statementSpec.setCreateIndexDesc(new CreateIndexDesc(indexName, windowName, columns));
    }

    private void leaveCreateSchema(Tree node) {
        int i;
        log.debug(".leaveCreateSchema");
        String schemaName = node.getChild(0).getText();
        ArrayList<ColumnDesc> columnTypes = new ArrayList<ColumnDesc>();
        for (int nodeNum = 0; nodeNum < node.getChildCount(); ++nodeNum) {
            if (node.getChild(nodeNum).getType() != 226) continue;
            Tree parent = node.getChild(nodeNum);
            for (i = 0; i < parent.getChildCount(); ++i) {
                String name = parent.getChild(i).getChild(0).getText();
                String type = parent.getChild(i).getChild(1).getText();
                boolean isArray = false;
                if (parent.getChild(i).getChildCount() > 2) {
                    isArray = true;
                }
                columnTypes.add(new ColumnDesc(name, type, isArray));
            }
        }
        HashSet<String> typeNames = new HashSet<String>();
        for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
            if (node.getChild(i2).getType() != 239) continue;
            for (int j = 0; j < node.getChild(i2).getChildCount(); ++j) {
                typeNames.add(node.getChild(i2).getChild(j).getText());
            }
        }
        LinkedHashSet<String> inherited = new LinkedHashSet<String>();
        for (i = 0; i < node.getChildCount(); ++i) {
            Tree p = node.getChild(i);
            if (p.getType() != 238) continue;
            if (!p.getChild(0).getText().toLowerCase().equals("inherits")) {
                throw new EPException("Expected 'inherits' keyword after create-schema clause but encountered '" + p.getChild(0).getText() + "'");
            }
            for (int j = 1; j < p.getChildCount(); ++j) {
                if (p.getChild(j).getType() != 175) continue;
                for (int k = 0; k < p.getChild(j).getChildCount(); ++k) {
                    inherited.add(p.getChild(j).getChild(k).getText());
                }
            }
        }
        boolean variant = false;
        for (int i3 = 0; i3 < node.getChildCount(); ++i3) {
            Tree p = node.getChild(i3);
            if (p.getType() != 237) continue;
            if (!p.getChild(0).getText().toLowerCase().equals("variant")) {
                throw new EPException("Expected 'variant' keyword after create-schema clause but encountered '" + p.getChild(0).getText() + "'");
            }
            variant = true;
        }
        this.statementSpec.getStreamSpecs().add(new FilterStreamSpecRaw(new FilterSpecRaw(Object.class.getName(), Collections.EMPTY_LIST, null), Collections.EMPTY_LIST, null, new StreamSpecOptions()));
        this.statementSpec.setCreateSchemaDesc(new CreateSchemaDesc(schemaName, typeNames, columnTypes, inherited, variant));
    }

    private void leaveCreateVariable(Tree node) {
        log.debug(".leaveCreateVariable");
        Tree child = node.getChild(0);
        String variableType = child.getText();
        child = node.getChild(1);
        String variableName = child.getText();
        ExprNode assignment = null;
        if (node.getChildCount() > 2) {
            child = node.getChild(2);
            assignment = this.astExprNodeMap.get(child);
            this.astExprNodeMap.remove(child);
        }
        CreateVariableDesc desc = new CreateVariableDesc(variableType, variableName, assignment);
        this.statementSpec.setCreateVariableDesc(desc);
    }

    private void leaveCreateWindowSelect(Tree node) {
        log.debug(".leaveCreateWindowSelect");
    }

    private void leaveOnExpr(Tree node) {
        log.debug(".leaveOnExpr");
        boolean isOnDelete = false;
        Tree typeChildNode = null;
        for (int i = 0; i < node.getChildCount(); ++i) {
            Tree childNode = node.getChild(i);
            if (childNode.getType() == 212) {
                typeChildNode = childNode;
                isOnDelete = true;
            }
            if (childNode.getType() == 213) {
                typeChildNode = childNode;
            }
            if (childNode.getType() == 214) {
                typeChildNode = childNode;
            }
            if (childNode.getType() != 218) continue;
            typeChildNode = childNode;
        }
        if (typeChildNode == null) {
            throw new IllegalStateException("Could not determine on-expr type");
        }
        if (typeChildNode.getType() != 218) {
            UniformPair<String> windowName = this.getWindowName(typeChildNode);
            if (windowName == null) {
                ArrayList<OnTriggerSplitStream> splitStreams = new ArrayList<OnTriggerSplitStream>();
                for (int i = 1; i <= this.statementSpecStack.size() - 1; ++i) {
                    StatementSpecRaw raw = (StatementSpecRaw)this.statementSpecStack.get(i);
                    splitStreams.add(new OnTriggerSplitStream(raw.getInsertIntoDesc(), raw.getSelectClauseSpec(), raw.getFilterExprRootNode()));
                }
                splitStreams.add(new OnTriggerSplitStream(this.statementSpec.getInsertIntoDesc(), this.statementSpec.getSelectClauseSpec(), this.statementSpec.getFilterExprRootNode()));
                if (!this.statementSpecStack.isEmpty()) {
                    this.statementSpec = (StatementSpecRaw)this.statementSpecStack.get(0);
                }
                boolean isFirst = this.isSelectInsertFirst(node);
                this.statementSpec.setOnTriggerDesc(new OnTriggerSplitStreamDesc(OnTriggerType.ON_SPLITSTREAM, isFirst, splitStreams));
                this.statementSpecStack.clear();
            } else if (typeChildNode.getType() == 214) {
                List<OnTriggerSetAssignment> assignments = EPLTreeWalker.getOnTriggerSetAssignments(typeChildNode, this.astExprNodeMap);
                this.statementSpec.setOnTriggerDesc(new OnTriggerWindowUpdateDesc(windowName.getFirst(), windowName.getSecond(), assignments));
                this.statementSpec.setFilterExprRootNode(this.getRemoveFirstByType(typeChildNode, 139));
            } else {
                this.statementSpec.setOnTriggerDesc(new OnTriggerWindowDesc(windowName.getFirst(), windowName.getSecond(), isOnDelete ? OnTriggerType.ON_DELETE : OnTriggerType.ON_SELECT));
            }
        } else {
            List<OnTriggerSetAssignment> assignments = EPLTreeWalker.getOnTriggerSetAssignments(typeChildNode, this.astExprNodeMap);
            this.statementSpec.setOnTriggerDesc(new OnTriggerSetDesc(assignments));
        }
    }

    private void leaveOnStream(Tree node) {
        StreamSpecBase streamSpec;
        log.debug(".leaveOnStream");
        Tree childNode = node.getChild(1);
        String streamAsName = null;
        if (childNode != null && childNode.getType() == 262) {
            streamAsName = childNode.getText();
        }
        if (node.getChild(0).getType() == 119) {
            streamSpec = new FilterStreamSpecRaw(this.filterSpec, new ArrayList<ViewSpec>(), streamAsName, new StreamSpecOptions());
        } else if (node.getChild(0).getType() == 137) {
            if (this.astPatternNodeMap.size() > 1 || this.astPatternNodeMap.isEmpty()) {
                throw new ASTWalkException("Unexpected AST tree contains zero or more then 1 child elements for root");
            }
            EvalNode evalNode = this.astPatternNodeMap.values().iterator().next();
            streamSpec = new PatternStreamSpecRaw(evalNode, this.viewSpecs, streamAsName, new StreamSpecOptions());
            this.astPatternNodeMap.clear();
        } else {
            throw new IllegalStateException("Invalid AST type node, cannot map to stream specification");
        }
        this.statementSpec.getStreamSpecs().add((StreamSpecRaw)((Object)streamSpec));
    }

    private void leaveForClause(Tree node) {
        log.debug(".leaveForClause");
        if (this.statementSpec.getForClauseSpec() == null) {
            this.statementSpec.setForClauseSpec(new ForClauseSpec());
        }
        String ident = node.getChild(0).getText();
        List<ExprNode> expressions = this.getExprNodes(node, 1);
        this.statementSpec.getForClauseSpec().getClauses().add(new ForClauseItemSpec(ident, expressions));
    }

    private void leaveUpdateExpr(Tree node) {
        log.debug(".leaveUpdateExpr");
        String eventTypeName = node.getChild(0).getText();
        FilterStreamSpecRaw streamSpec = new FilterStreamSpecRaw(new FilterSpecRaw(eventTypeName, Collections.EMPTY_LIST, null), new ArrayList<ViewSpec>(), eventTypeName, new StreamSpecOptions());
        this.statementSpec.getStreamSpecs().add(streamSpec);
        String optionalStreamName = null;
        if (node.getChildCount() > 1 && node.getChild(1).getType() == 262) {
            optionalStreamName = node.getChild(1).getText();
        }
        List<OnTriggerSetAssignment> assignments = EPLTreeWalker.getOnTriggerSetAssignments(node, this.astExprNodeMap);
        ExprNode whereClause = this.getRemoveFirstByType(node, 139);
        this.statementSpec.setUpdateDesc(new UpdateDesc(optionalStreamName, assignments, whereClause));
    }

    protected static List<OnTriggerSetAssignment> getOnTriggerSetAssignments(Tree node, Map<Tree, ExprNode> astExprNodeMap) {
        ArrayList<OnTriggerSetAssignment> assignments = new ArrayList<OnTriggerSetAssignment>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (node.getChild(i).getType() != 235) continue;
            Tree childNode = node.getChild(i);
            String variableName = ASTFilterSpecHelper.getPropertyName(childNode.getChild(0), 0);
            ExprNode childEvalNode = astExprNodeMap.get(childNode.getChild(1));
            astExprNodeMap.remove(childNode.getChild(1));
            assignments.add(new OnTriggerSetAssignment(variableName, childEvalNode));
        }
        return assignments;
    }

    private UniformPair<String> getWindowName(Tree typeChildNode) {
        String windowName = null;
        String windowStreamName = null;
        for (int i = 0; i < typeChildNode.getChildCount(); ++i) {
            Tree child = typeChildNode.getChild(i);
            if (child.getType() != 217) continue;
            windowName = child.getChild(0).getText();
            if (child.getChildCount() <= 1) break;
            windowStreamName = child.getChild(1).getText();
            break;
        }
        if (windowName == null) {
            return null;
        }
        return new UniformPair<Object>(windowName, windowStreamName);
    }

    private void leavePrevious(Tree node) {
        log.debug(".leavePrevious");
        ExprPreviousNode previousNode = new ExprPreviousNode();
        this.astExprNodeMap.put(node, previousNode);
    }

    private void leavePrior(Tree node) {
        log.debug(".leavePrior");
        ExprPriorNode priorNode = new ExprPriorNode();
        this.astExprNodeMap.put(node, priorNode);
    }

    private void leaveInstanceOf(Tree node) {
        log.debug(".leaveInstanceOf");
        ArrayList<String> classes = new ArrayList<String>();
        for (int i = 1; i < node.getChildCount(); ++i) {
            Tree classIdent = node.getChild(i);
            classes.add(classIdent.getText());
        }
        String[] idents = classes.toArray(new String[classes.size()]);
        ExprInstanceofNode instanceofNode = new ExprInstanceofNode(idents);
        this.astExprNodeMap.put(node, instanceofNode);
    }

    private void leaveExists(Tree node) {
        log.debug(".leaveExists");
        ExprPropertyExistsNode instanceofNode = new ExprPropertyExistsNode();
        this.astExprNodeMap.put(node, instanceofNode);
    }

    private void leaveCast(Tree node) {
        log.debug(".leaveCast");
        String classIdent = node.getChild(1).getText();
        ExprCastNode castNode = new ExprCastNode(classIdent);
        this.astExprNodeMap.put(node, castNode);
    }

    private void leaveTimestamp(Tree node) {
        log.debug(".leaveTimestamp");
        ExprTimestampNode timeNode = new ExprTimestampNode();
        this.astExprNodeMap.put(node, timeNode);
    }

    private void leaveTimePeriod(Tree node) {
        log.debug(".leaveTimePeriod");
        ExprNode[] nodes = new ExprNode[5];
        for (int i = 0; i < node.getChildCount(); ++i) {
            Tree child = node.getChild(i);
            if (child.getType() == 185) {
                nodes[4] = this.astExprNodeMap.remove(child.getChild(0));
            }
            if (child.getType() == 184) {
                nodes[3] = this.astExprNodeMap.remove(child.getChild(0));
            }
            if (child.getType() == 183) {
                nodes[2] = this.astExprNodeMap.remove(child.getChild(0));
            }
            if (child.getType() == 182) {
                nodes[1] = this.astExprNodeMap.remove(child.getChild(0));
            }
            if (child.getType() != 181) continue;
            nodes[0] = this.astExprNodeMap.remove(child.getChild(0));
        }
        ExprTimePeriod timeNode = new ExprTimePeriod(nodes[0] != null, nodes[1] != null, nodes[2] != null, nodes[3] != null, nodes[4] != null);
        if (nodes[0] != null) {
            timeNode.addChildNode(nodes[0]);
        }
        if (nodes[1] != null) {
            timeNode.addChildNode(nodes[1]);
        }
        if (nodes[2] != null) {
            timeNode.addChildNode(nodes[2]);
        }
        if (nodes[3] != null) {
            timeNode.addChildNode(nodes[3]);
        }
        if (nodes[4] != null) {
            timeNode.addChildNode(nodes[4]);
        }
        this.astExprNodeMap.put(node, timeNode);
    }

    private void leaveNumberSetStar(Tree node) {
        log.debug(".leaveNumberSetStar");
        ExprNumberSetWildcard exprNode = new ExprNumberSetWildcard();
        this.astExprNodeMap.put(node, exprNode);
    }

    private void leaveNumberSetFrequency(Tree node) {
        log.debug(".leaveNumberSetFrequency");
        ExprNumberSetFrequency exprNode = new ExprNumberSetFrequency();
        this.astExprNodeMap.put(node, exprNode);
    }

    private void leaveNumberSetRange(Tree node) {
        log.debug(".leaveNumberSetRange");
        ExprNumberSetRange exprNode = new ExprNumberSetRange();
        this.astExprNodeMap.put(node, exprNode);
    }

    private void leaveNumberSetList(Tree node) {
        log.debug(".leaveNumberSetList");
        ExprNumberSetList exprNode = new ExprNumberSetList();
        this.astExprNodeMap.put(node, exprNode);
    }

    private void leaveLastNumberSetOperator(Tree node) {
        log.debug(".leaveLastNumberSetOperator");
        ExprNumberSetCronParam exprNode = new ExprNumberSetCronParam(CronOperatorEnum.LASTDAY);
        this.astExprNodeMap.put(node, exprNode);
    }

    private void leaveLastWeekdayNumberSetOperator(Tree node) {
        log.debug(".leaveLastWeekdayNumberSetOperator");
        ExprNumberSetCronParam exprNode = new ExprNumberSetCronParam(CronOperatorEnum.LASTWEEKDAY);
        this.astExprNodeMap.put(node, exprNode);
    }

    private void leaveWeekdayNumberSetOperator(Tree node) {
        log.debug(".leaveWeekdayNumberSetOperator");
        ExprNumberSetCronParam exprNode = new ExprNumberSetCronParam(CronOperatorEnum.WEEKDAY);
        this.astExprNodeMap.put(node, exprNode);
    }

    private void leaveObjectParamOrderedExpression(Tree node) {
        log.debug(".leaveObjectParamOrderedExpression");
        boolean isDescending = false;
        if (node.getChildCount() > 1 && node.getChild(1).getText().toUpperCase().equals("DESC")) {
            isDescending = true;
        }
        ExprOrderedExpr exprNode = new ExprOrderedExpr(isDescending);
        this.astExprNodeMap.put(node, exprNode);
    }

    private void leaveAnnotation(Tree node) {
        log.debug(".leaveAnnotation");
        this.statementSpec.getAnnotations().add(ASTAnnotationHelper.walk(node, this.engineImportService));
    }

    private void leaveArray(Tree node) {
        log.debug(".leaveArray");
        ExprArrayNode arrayNode = new ExprArrayNode();
        this.astExprNodeMap.put(node, arrayNode);
    }

    private void leaveSubselectRow(Tree node) {
        log.debug(".leaveSubselectRow");
        StatementSpecRaw currentSpec = this.popStacks();
        ExprSubselectRowNode subselectNode = new ExprSubselectRowNode(currentSpec);
        this.astExprNodeMap.put(node, subselectNode);
    }

    private void leaveSubselectExists(Tree node) {
        log.debug(".leaveSubselectExists");
        StatementSpecRaw currentSpec = this.popStacks();
        ExprSubselectExistsNode subselectNode = new ExprSubselectExistsNode(currentSpec);
        this.astExprNodeMap.put(node, subselectNode);
    }

    private void leaveSubselectIn(Tree node) {
        log.debug(".leaveSubselectIn");
        Tree nodeSubquery = node.getChild(1);
        boolean isNot = false;
        if (node.getType() == 201) {
            isNot = true;
        }
        ExprSubselectInNode subqueryNode = (ExprSubselectInNode)this.astExprNodeMap.remove(nodeSubquery);
        subqueryNode.setNotIn(isNot);
        this.astExprNodeMap.put(node, subqueryNode);
    }

    private void leaveSubselectQueryIn(Tree node) {
        log.debug(".leaveSubselectQueryIn");
        StatementSpecRaw currentSpec = this.popStacks();
        ExprSubselectInNode subselectNode = new ExprSubselectInNode(currentSpec);
        this.astExprNodeMap.put(node, subselectNode);
    }

    private StatementSpecRaw popStacks() {
        log.debug(".popStacks");
        StatementSpecRaw currentSpec = this.statementSpec;
        this.statementSpec = this.statementSpecStack.pop();
        if (currentSpec.isHasVariables()) {
            this.statementSpec.setHasVariables(true);
        }
        if (currentSpec.getReferencedVariables() != null) {
            for (String var : currentSpec.getReferencedVariables()) {
                this.addVariable(this.statementSpec, var);
            }
        }
        this.astExprNodeMap = this.astExprNodeMapStack.pop();
        return currentSpec;
    }

    @Override
    protected void endPattern() throws ASTWalkException {
        log.debug(".endPattern");
        if (this.astPatternNodeMap.size() > 1 || this.astPatternNodeMap.isEmpty()) {
            throw new ASTWalkException("Unexpected AST tree contains zero or more then 1 child elements for root");
        }
        EvalNode evalNode = this.astPatternNodeMap.values().iterator().next();
        PatternStreamSpecRaw streamSpec = new PatternStreamSpecRaw(evalNode, new LinkedList<ViewSpec>(), null, new StreamSpecOptions());
        this.statementSpec.getStreamSpecs().add(streamSpec);
        this.statementSpec.setSubstitutionParameters(this.substitutionParamNodes);
        this.astPatternNodeMap.clear();
    }

    @Override
    protected void end() throws ASTWalkException {
        log.debug(".end");
        if (this.astExprNodeMap.size() > 1) {
            throw new ASTWalkException("Unexpected AST tree contains left over child elements, not all expression nodes have been removed from AST-to-expression nodes map");
        }
        if (this.astPatternNodeMap.size() > 1) {
            throw new ASTWalkException("Unexpected AST tree contains left over child elements, not all pattern nodes have been removed from AST-to-pattern nodes map");
        }
        this.statementSpec.setSubstitutionParameters(this.substitutionParamNodes);
    }

    private void leaveSelectionElement(Tree node) throws ASTWalkException {
        log.debug(".leaveSelectionElement");
        if (this.astExprNodeMap.size() > 1 || this.astExprNodeMap.isEmpty()) {
            throw new ASTWalkException("Unexpected AST tree contains zero or more then 1 child element for root");
        }
        ExprNode exprNode = this.astExprNodeMap.values().iterator().next();
        this.astExprNodeMap.clear();
        String optionalName = null;
        if (node.getChildCount() > 1) {
            optionalName = node.getChild(1).getText();
        }
        this.statementSpec.getSelectClauseSpec().add(new SelectClauseExprRawSpec(exprNode, optionalName));
    }

    private void leavePropertySelectionElement(Tree node) throws ASTWalkException {
        log.debug(".leavePropertySelectionElement");
        if (this.astExprNodeMap.size() > 1 || this.astExprNodeMap.isEmpty()) {
            throw new ASTWalkException("Unexpected AST tree contains zero or more then 1 child element for root");
        }
        ExprNode exprNode = this.astExprNodeMap.values().iterator().next();
        this.astExprNodeMap.clear();
        String optionalName = null;
        if (node.getChildCount() > 1) {
            optionalName = node.getChild(1).getText();
        }
        if (this.propertySelectRaw == null) {
            this.propertySelectRaw = new ArrayList<SelectClauseElementRaw>();
        }
        this.propertySelectRaw.add(new SelectClauseExprRawSpec(exprNode, optionalName));
    }

    private void leavePropertySelectionStream(Tree node) throws ASTWalkException {
        log.debug(".leavePropertySelectionStream");
        String streamName = node.getChild(0).getText();
        String optionalName = null;
        if (node.getChildCount() > 1) {
            optionalName = node.getChild(1).getText();
        }
        if (this.propertySelectRaw == null) {
            this.propertySelectRaw = new ArrayList<SelectClauseElementRaw>();
        }
        this.propertySelectRaw.add(new SelectClauseStreamRawSpec(streamName, optionalName));
    }

    private void leaveSelectionStream(Tree node) throws ASTWalkException {
        log.debug(".leaveSelectionStream");
        String streamName = node.getChild(0).getText();
        String optionalName = null;
        if (node.getChildCount() > 1) {
            optionalName = node.getChild(1).getText();
        }
        this.statementSpec.getSelectClauseSpec().add(new SelectClauseStreamRawSpec(streamName, optionalName));
    }

    private void leaveWildcardSelect() {
        log.debug(".leaveWildcardSelect");
        this.statementSpec.getSelectClauseSpec().add(new SelectClauseElementWildcard());
    }

    private void leavePropertyWildcardSelect() {
        log.debug(".leavePropertyWildcardSelect");
        if (this.propertySelectRaw == null) {
            this.propertySelectRaw = new ArrayList<SelectClauseElementRaw>();
        }
        this.propertySelectRaw.add(new SelectClauseElementWildcard());
    }

    private void leavePropertySelectAtom(Tree node) {
        log.debug(".leavePropertySelectAtom");
        if (this.propertyEvalSpec == null) {
            this.propertyEvalSpec = new PropertyEvalSpec();
        }
        SelectClauseSpecRaw optionalSelectClause = new SelectClauseSpecRaw();
        if (this.propertySelectRaw != null) {
            optionalSelectClause.getSelectExprList().addAll(this.propertySelectRaw);
            this.propertySelectRaw = null;
        }
        ExprNode optionalWhereClause = null;
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (node.getChild(i).getType() != 139) continue;
            optionalWhereClause = this.astExprNodeMap.remove(node.getChild(i).getChild(0));
        }
        String propertyName = null;
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (node.getChild(i).getType() != 161) continue;
            propertyName = ASTFilterSpecHelper.getPropertyName(node.getChild(i), 0);
        }
        String optionalAsName = null;
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (node.getChild(i).getType() != 262) continue;
            optionalAsName = node.getChild(i).getText();
        }
        PropertyEvalAtom atom = new PropertyEvalAtom(propertyName, optionalAsName, optionalSelectClause, optionalWhereClause);
        this.propertyEvalSpec.add(atom);
    }

    private void leaveView(Tree node) throws ASTWalkException {
        log.debug(".leaveView");
        String objectNamespace = node.getChild(0).getText();
        String objectName = node.getChild(1).getText();
        List<ExprNode> viewParameters = this.getExprNodes(node, 2);
        this.viewSpecs.add(new ViewSpec(objectNamespace, objectName, viewParameters));
    }

    private void leaveMatchRecognizeMeasureItem(Tree node) throws ASTWalkException {
        Tree currentNode;
        ExprNode exprNode;
        log.debug(".leaveMatchRecognizeMeasureItem");
        if (this.statementSpec.getMatchRecognizeSpec() == null) {
            this.statementSpec.setMatchRecognizeSpec(new MatchRecognizeSpec());
        }
        if ((exprNode = this.astExprNodeMap.get(currentNode = node.getChild(0))) == null) {
            throw new IllegalStateException("Expression node for AST node not found for type " + currentNode.getType() + " and text " + currentNode.getText());
        }
        this.astExprNodeMap.remove(currentNode);
        String name = null;
        if (node.getChildCount() > 1) {
            name = node.getChild(1).getText();
        }
        this.statementSpec.getMatchRecognizeSpec().addMeasureItem(new MatchRecognizeMeasureItem(exprNode, name));
    }

    private void leaveMatchRecognizePatternAtom(Tree node) throws ASTWalkException {
        log.debug(".leaveMatchRecognizePatternAtom");
        String first = node.getChild(0).getText();
        RegexNFATypeEnum type = RegexNFATypeEnum.SINGLE;
        if (node.getChildCount() > 2) {
            type = RegexNFATypeEnum.fromString(node.getChild(1).getText(), node.getChild(2).getText());
        } else if (node.getChildCount() > 1) {
            type = RegexNFATypeEnum.fromString(node.getChild(1).getText(), null);
        }
        RowRegexExprNodeAtom item = new RowRegexExprNodeAtom(first, type);
        this.astRowRegexNodeMap.put(node, item);
    }

    private void leaveMatchRecognizePatternAlter(Tree node) throws ASTWalkException {
        log.debug(".leaveMatchRecognizePatternAlter");
        RowRegexExprNodeAlteration alterNode = new RowRegexExprNodeAlteration();
        this.astRowRegexNodeMap.put(node, alterNode);
    }

    private void leaveMatchRecognizePatternConcat(Tree node) throws ASTWalkException {
        RowRegexExprNodeConcatenation concatNode = new RowRegexExprNodeConcatenation();
        this.astRowRegexNodeMap.put(node, concatNode);
    }

    private void leaveMatchRecognizePatternNested(Tree node) throws ASTWalkException {
        RegexNFATypeEnum type = RegexNFATypeEnum.SINGLE;
        if (node.getChildCount() > 2) {
            type = RegexNFATypeEnum.fromString(node.getChild(1).getText(), node.getChild(2).getText());
        } else if (node.getChildCount() > 1) {
            type = RegexNFATypeEnum.fromString(node.getChild(1).getText(), null);
        }
        RowRegexExprNodeNested nestedNode = new RowRegexExprNodeNested(type);
        this.astRowRegexNodeMap.put(node, nestedNode);
    }

    private void leaveMatchRecognizePattern(Tree node) throws ASTWalkException {
        Tree currentNode = node.getChild(0);
        RowRegexExprNode exprNode = this.astRowRegexNodeMap.get(currentNode);
        if (exprNode == null) {
            throw new IllegalStateException("Expression node for AST node not found for type " + currentNode.getType() + " and text " + currentNode.getText());
        }
        this.astRowRegexNodeMap.remove(currentNode);
        this.statementSpec.getMatchRecognizeSpec().setPattern(exprNode);
    }

    private void leaveMatchRecognizeDefineItem(Tree node) throws ASTWalkException {
        log.debug(".leaveMatchRecognizeDefineItem");
        String first = node.getChild(0).getText();
        Tree currentNode = node.getChild(1);
        ExprNode exprNode = this.astExprNodeMap.get(currentNode);
        if (exprNode == null) {
            throw new IllegalStateException("Expression node for AST node not found for type " + currentNode.getType() + " and text " + currentNode.getText());
        }
        this.astExprNodeMap.remove(currentNode);
        this.statementSpec.getMatchRecognizeSpec().getDefines().add(new MatchRecognizeDefineItem(first, exprNode));
    }

    private void leaveMatchRecognize(Tree node) throws ASTWalkException {
        int i;
        log.debug(".leaveMatchRecognize");
        boolean allMatches = false;
        for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
            if (node.getChild(i2).getType() != 47) continue;
            allMatches = true;
        }
        for (i = 0; i < node.getChildCount(); ++i) {
            if (node.getChild(i).getType() != 254) continue;
            MatchRecognizeSkipEnum skip = ASTMatchRecognizeHelper.parseSkip(node.getChild(i));
            this.statementSpec.getMatchRecognizeSpec().getSkip().setSkip(skip);
        }
        for (i = 0; i < node.getChildCount(); ++i) {
            ExprTimePeriod timePeriodExpr;
            if (node.getChild(i).getType() != 255) continue;
            Tree intervalParent = node.getChild(i);
            if (!intervalParent.getChild(0).getText().toLowerCase().equals("interval")) {
                throw new ASTWalkException("Invalid interval-clause within match-recognize, expecting keyword INTERVAL");
            }
            ExprNode expression = this.astExprNodeMap.remove(intervalParent.getChild(1));
            try {
                timePeriodExpr = (ExprTimePeriod)expression.getValidatedSubtree(new StreamTypeServiceImpl(this.engineURI), null, null, this.timeProvider, this.variableService, this.exprEvaluatorContext);
            }
            catch (ExprValidationException ex) {
                throw new ASTWalkException("Invalid interval-clause within match-recognize: " + ex.getMessage(), ex);
            }
            this.statementSpec.getMatchRecognizeSpec().setInterval(new MatchRecognizeInterval(timePeriodExpr));
        }
        this.statementSpec.getMatchRecognizeSpec().setAllMatches(allMatches);
    }

    private void leaveOnSelect(Tree node) throws ASTWalkException {
        log.debug(".leaveOnSelect");
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (node.getChild(i).getType() != 46) continue;
            this.statementSpec.getSelectClauseSpec().setDistinct(true);
        }
    }

    private void leaveMatchRecognizePartition(Tree node) throws ASTWalkException {
        log.debug(".leaveMatchRecognizePartition");
        if (this.statementSpec.getMatchRecognizeSpec() == null) {
            this.statementSpec.setMatchRecognizeSpec(new MatchRecognizeSpec());
        }
        this.statementSpec.getMatchRecognizeSpec().getPartitionByExpressions().addAll(this.getExprNodes(node, 0));
    }

    private void leaveStreamExpr(Tree node) {
        StreamSpecBase streamSpec;
        log.debug(".leaveStreamExpr");
        Tree streamNameNode = null;
        for (int i = 1; i < node.getChildCount(); ++i) {
            Tree child = node.getChild(i);
            if (child.getType() != 262) continue;
            streamNameNode = child;
            break;
        }
        String streamName = null;
        if (streamNameNode != null) {
            streamName = streamNameNode.getText();
        }
        boolean isUnidirectional = false;
        boolean isRetainUnion = false;
        boolean isRetainIntersection = false;
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (node.getChild(i).getType() == 63) {
                isUnidirectional = true;
                break;
            }
            if (node.getChild(i).getType() == 64) {
                isRetainUnion = true;
                break;
            }
            if (node.getChild(i).getType() != 65) continue;
            isRetainIntersection = true;
            break;
        }
        StreamSpecOptions options = new StreamSpecOptions(isUnidirectional, isRetainUnion, isRetainIntersection);
        if (node.getChild(0).getType() == 119) {
            streamSpec = new FilterStreamSpecRaw(this.filterSpec, this.viewSpecs, streamName, options);
        } else if (node.getChild(0).getType() == 137) {
            if (this.astPatternNodeMap.size() > 1 || this.astPatternNodeMap.isEmpty()) {
                throw new ASTWalkException("Unexpected AST tree contains zero or more then 1 child elements for root");
            }
            EvalNode evalNode = this.astPatternNodeMap.values().iterator().next();
            streamSpec = new PatternStreamSpecRaw(evalNode, this.viewSpecs, streamName, options);
            this.astPatternNodeMap.clear();
        } else if (node.getChild(0).getType() == 138) {
            Tree dbrootNode = node.getChild(0);
            String dbName = dbrootNode.getChild(0).getText();
            String sqlWithParams = StringValue.parseString(dbrootNode.getChild(1).getText().trim());
            try {
                List<PlaceholderParser.Fragment> sqlFragments = PlaceholderParser.parsePlaceholder(sqlWithParams);
                for (PlaceholderParser.Fragment fragment : sqlFragments) {
                    List<ExprNode> listExp;
                    String expression;
                    if (!(fragment instanceof PlaceholderParser.ParameterFragment) || (expression = fragment.getValue()).toUpperCase().equals("$ESPER-SAMPLE-WHERE")) continue;
                    if (expression.trim().length() == 0) {
                        throw new ASTWalkException("Missing expression within ${...} in SQL statement");
                    }
                    String toCompile = "select * from java.lang.Object where " + expression;
                    StatementSpecRaw raw = EPAdministratorHelper.compileEPL(toCompile, expression, false, null, SelectClauseStreamSelectorEnum.ISTREAM_ONLY, this.engineImportService, this.variableService, this.schedulingService, this.engineURI, this.configurationInformation);
                    if (raw.getSubstitutionParameters() != null && raw.getSubstitutionParameters().size() > 0) {
                        throw new ASTWalkException("EPL substitution parameters are not allowed in SQL ${...} expressions, consider using a variable instead");
                    }
                    if (raw.isHasVariables()) {
                        this.statementSpec.setHasVariables(true);
                    }
                    if (this.statementSpec.getSqlParameters() == null) {
                        this.statementSpec.setSqlParameters(new HashMap<Integer, List<ExprNode>>());
                    }
                    if ((listExp = this.statementSpec.getSqlParameters().get(this.statementSpec.getStreamSpecs().size())) == null) {
                        listExp = new ArrayList<ExprNode>();
                        this.statementSpec.getSqlParameters().put(this.statementSpec.getStreamSpecs().size(), listExp);
                    }
                    listExp.add(raw.getFilterRootNode());
                }
            }
            catch (PlaceholderParseException ex) {
                log.warn("Failed to parse SQL text '" + sqlWithParams + "' :" + ex.getMessage());
            }
            String sampleSQL = null;
            if (dbrootNode.getChildCount() > 2) {
                sampleSQL = dbrootNode.getChild(2).getText();
                sampleSQL = StringValue.parseString(sampleSQL.trim());
            }
            streamSpec = new DBStatementStreamSpec(streamName, this.viewSpecs, dbName, sqlWithParams, sampleSQL);
        } else if (node.getChild(0).getType() == 220) {
            String methodNamePart;
            String classNamePart;
            Tree methodRootNode = node.getChild(0);
            String prefixIdent = methodRootNode.getChild(0).getText();
            String className = methodRootNode.getChild(1).getText();
            int indexDot = className.lastIndexOf(46);
            if (indexDot == -1) {
                classNamePart = className;
                methodNamePart = null;
            } else {
                classNamePart = className.substring(0, indexDot);
                methodNamePart = className.substring(indexDot + 1);
            }
            List<ExprNode> exprNodes = this.getExprNodes(methodRootNode, 2);
            streamSpec = new MethodStreamSpec(streamName, this.viewSpecs, prefixIdent, classNamePart, methodNamePart, exprNodes);
        } else {
            throw new ASTWalkException("Unexpected AST child node to stream expression, type=" + node.getChild(0).getType());
        }
        this.viewSpecs.clear();
        this.statementSpec.getStreamSpecs().add((StreamSpecRaw)((Object)streamSpec));
    }

    private void leaveEventPropertyExpr(Tree node) {
        ExprNode exprNode;
        String propertyName;
        log.debug(".leaveEventPropertyExpr");
        if (node.getChildCount() == 0) {
            throw new IllegalStateException("Empty event property expression encountered");
        }
        if (node.getChildCount() == 1 || node.getChild(0).getType() != 162) {
            propertyName = ASTFilterSpecHelper.getPropertyName(node, 0);
            exprNode = new ExprIdentNode(propertyName);
        } else {
            String leadingIdentifier = node.getChild(0).getChild(0).getText();
            String streamOrNestedPropertyName = ASTFilterSpecHelper.escapeDot(leadingIdentifier);
            propertyName = ASTFilterSpecHelper.getPropertyName(node, 1);
            if (this.variableService.getReader(leadingIdentifier) != null) {
                exprNode = new ExprVariableNode(leadingIdentifier + "." + propertyName);
                this.statementSpec.setHasVariables(true);
                this.addVariable(this.statementSpec, propertyName);
            } else {
                exprNode = new ExprIdentNode(propertyName, streamOrNestedPropertyName);
            }
        }
        if (this.variableService.getReader(propertyName) != null) {
            exprNode = new ExprVariableNode(propertyName);
            this.statementSpec.setHasVariables(true);
            this.addVariable(this.statementSpec, propertyName);
        }
        this.astExprNodeMap.put(node, exprNode);
    }

    private void addVariable(StatementSpecRaw statementSpec, String propertyName) {
        if (statementSpec.getReferencedVariables() == null) {
            statementSpec.setReferencedVariables(new HashSet<String>());
        }
        statementSpec.getReferencedVariables().add(propertyName);
    }

    private void leaveLibFunction(Tree node) {
        log.debug(".leaveLibFunction");
        String childNodeText = node.getChild(0).getText();
        if (childNodeText.toLowerCase().equals("max") || childNodeText.toLowerCase().equals("min")) {
            this.handleMinMax(node);
            return;
        }
        if (node.getChild(0).getType() == 133) {
            String className = node.getChild(0).getText();
            String methodName = node.getChild(1).getText();
            this.astExprNodeMap.put(node, new ExprStaticMethodNode(className, methodName, this.configurationInformation.getEngineDefaults().getExpression().isUdfCache()));
            return;
        }
        boolean isDistinct = false;
        if (node.getChild(1) != null && node.getChild(1).getType() == 46) {
            isDistinct = true;
        }
        try {
            AggregationSupport aggregation = this.engineImportService.resolveAggregation(childNodeText);
            this.astExprNodeMap.put(node, new ExprPlugInAggFunctionNode(isDistinct, aggregation, childNodeText));
            return;
        }
        catch (EngineImportUndefinedException e2) {
        }
        catch (EngineImportException e3) {
            throw new IllegalStateException("Error resolving aggregation: " + e3.getMessage(), e3);
        }
        ExprNode extentedBuiltIn = this.engineImportService.resolveAggExtendedBuiltin(childNodeText, isDistinct);
        if (extentedBuiltIn != null) {
            this.astExprNodeMap.put(node, extentedBuiltIn);
            return;
        }
        throw new IllegalStateException("Unknown method named '" + childNodeText + "' could not be resolved");
    }

    private void leaveEqualsExpr(Tree node) {
        log.debug(".leaveEqualsExpr");
        boolean isNot = false;
        if (node.getType() == 145) {
            isNot = true;
        }
        ExprEqualsNode identNode = new ExprEqualsNode(isNot);
        this.astExprNodeMap.put(node, identNode);
    }

    private void leaveEqualsGroupExpr(Tree node) {
        log.debug(".leaveEqualsGroupExpr");
        boolean isNot = false;
        if (node.getType() == 147) {
            isNot = true;
        }
        boolean isAll = false;
        if (node.getChild(1).getType() == 47) {
            isAll = true;
        }
        if (node.getChildCount() > 2 && node.getChild(2).getType() == 198) {
            StatementSpecRaw currentSpec = this.popStacks();
            ExprSubselectAllSomeAnyNode subselectNode = new ExprSubselectAllSomeAnyNode(currentSpec, isNot, isAll, null);
            this.astExprNodeMap.put(node, subselectNode);
        } else {
            ExprEqualsAllAnyNode groupNode = new ExprEqualsAllAnyNode(isNot, isAll);
            this.astExprNodeMap.put(node, groupNode);
        }
    }

    private void leaveJoinAndExpr(Tree node) {
        log.debug(".leaveJoinAndExpr");
        ExprAndNode identNode = new ExprAndNode();
        this.astExprNodeMap.put(node, identNode);
    }

    private void leaveJoinOrExpr(Tree node) {
        log.debug(".leaveJoinOrExpr");
        ExprOrNode identNode = new ExprOrNode();
        this.astExprNodeMap.put(node, identNode);
    }

    private void leaveConstant(Tree node) {
        log.debug(".leaveConstant value '" + node.getText() + "'");
        ExprConstantNode constantNode = new ExprConstantNode(ASTConstantHelper.parse(node));
        this.astExprNodeMap.put(node, constantNode);
    }

    private void leaveSubstitution(Tree node) {
        log.debug(".leaveSubstitution");
        int currentSize = this.substitutionParamNodes.size();
        ExprSubstitutionNode substitutionNode = new ExprSubstitutionNode(currentSize + 1);
        this.substitutionParamNodes.add(substitutionNode);
        this.astExprNodeMap.put(node, substitutionNode);
    }

    private void leaveMath(Tree node) {
        MathArithTypeEnum mathArithTypeEnum;
        log.debug(".leaveMath");
        switch (node.getType()) {
            case 286: {
                mathArithTypeEnum = MathArithTypeEnum.DIVIDE;
                break;
            }
            case 269: {
                mathArithTypeEnum = MathArithTypeEnum.MULTIPLY;
                break;
            }
            case 271: {
                mathArithTypeEnum = MathArithTypeEnum.ADD;
                break;
            }
            case 285: {
                mathArithTypeEnum = MathArithTypeEnum.SUBTRACT;
                break;
            }
            case 287: {
                mathArithTypeEnum = MathArithTypeEnum.MODULO;
                break;
            }
            default: {
                throw new IllegalArgumentException("Node type " + node.getType() + " not a recognized math node type");
            }
        }
        ExprMathNode mathNode = new ExprMathNode(mathArithTypeEnum, this.configurationInformation.getEngineDefaults().getExpression().isIntegerDivision(), this.configurationInformation.getEngineDefaults().getExpression().isDivisionByZeroReturnsNull());
        this.astExprNodeMap.put(node, mathNode);
    }

    private void handleMinMax(Tree libNode) {
        MinMaxTypeEnum minMaxTypeEnum;
        log.debug(".handleMinMax");
        Tree childNode = libNode.getChild(0);
        if (childNode.getText().equals("min")) {
            minMaxTypeEnum = MinMaxTypeEnum.MIN;
        } else if (childNode.getText().equals("max")) {
            minMaxTypeEnum = MinMaxTypeEnum.MAX;
        } else {
            throw new IllegalArgumentException("Node type " + childNode.getType() + ' ' + childNode.getText() + " not a recognized min max node");
        }
        Tree nextNode = libNode.getChild(1);
        boolean isDistinct = false;
        if (nextNode.getType() == 46) {
            isDistinct = true;
        }
        if (libNode.getChildCount() > 3 && isDistinct) {
            throw new ASTWalkException("The distinct keyword is not valid in per-row min and max functions with multiple sub-expressions");
        }
        ExprNode minMaxNode = !isDistinct && libNode.getChildCount() > 2 ? new ExprMinMaxRowNode(minMaxTypeEnum) : new ExprMinMaxAggrNode(isDistinct, minMaxTypeEnum);
        this.astExprNodeMap.put(libNode, minMaxNode);
    }

    private void leaveCoalesce(Tree node) {
        log.debug(".leaveCoalesce");
        ExprCoalesceNode coalesceNode = new ExprCoalesceNode();
        this.astExprNodeMap.put(node, coalesceNode);
    }

    private void leaveAggregate(Tree node) {
        ExprAggregateNode aggregateNode;
        log.debug(".leaveAggregate");
        boolean isDistinct = false;
        if (node.getChild(0) != null && node.getChild(0).getType() == 46) {
            isDistinct = true;
        }
        switch (node.getType()) {
            case 19: {
                aggregateNode = new ExprAvgNode(isDistinct);
                break;
            }
            case 18: {
                aggregateNode = new ExprSumNode(isDistinct);
                break;
            }
            case 26: {
                aggregateNode = new ExprCountNode(isDistinct);
                break;
            }
            case 23: {
                aggregateNode = new ExprMedianNode(isDistinct);
                break;
            }
            case 24: {
                aggregateNode = new ExprStddevNode(isDistinct);
                break;
            }
            case 25: {
                aggregateNode = new ExprAvedevNode(isDistinct);
                break;
            }
            case 232: {
                aggregateNode = new ExprFirstNode(isDistinct);
                break;
            }
            case 233: {
                aggregateNode = new ExprLastNode(isDistinct);
                break;
            }
            default: {
                throw new IllegalArgumentException("Node type " + node.getType() + " not a recognized aggregate node type");
            }
        }
        this.astExprNodeMap.put(node, aggregateNode);
    }

    private void leaveRelationalOp(Tree node) {
        ExprNode result;
        RelationalOpEnum relationalOpEnum;
        log.debug(".leaveRelationalOp");
        switch (node.getType()) {
            case 280: {
                relationalOpEnum = RelationalOpEnum.LT;
                break;
            }
            case 281: {
                relationalOpEnum = RelationalOpEnum.GT;
                break;
            }
            case 282: {
                relationalOpEnum = RelationalOpEnum.LE;
                break;
            }
            case 283: {
                relationalOpEnum = RelationalOpEnum.GE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Node type " + node.getType() + " not a recognized relational op node type");
            }
        }
        boolean isAll = false;
        boolean isAny = false;
        if (node.getChild(1).getType() == 47) {
            isAll = true;
        }
        if (node.getChild(1).getType() == 48 || node.getChild(1).getType() == 49) {
            isAny = true;
        }
        if (isAll || isAny) {
            if (node.getChildCount() > 2 && node.getChild(2).getType() == 198) {
                StatementSpecRaw currentSpec = this.popStacks();
                result = new ExprSubselectAllSomeAnyNode(currentSpec, false, isAll, relationalOpEnum);
            } else {
                result = new ExprRelationalOpAllAnyNode(relationalOpEnum, isAll);
            }
        } else {
            result = new ExprRelationalOpNode(relationalOpEnum);
        }
        this.astExprNodeMap.put(node, result);
    }

    private void leaveBitWise(Tree node) {
        BitWiseOpEnum bitWiseOpEnum;
        log.debug(".leaveBitWise");
        switch (node.getType()) {
            case 276: {
                bitWiseOpEnum = BitWiseOpEnum.BAND;
                break;
            }
            case 270: {
                bitWiseOpEnum = BitWiseOpEnum.BOR;
                break;
            }
            case 277: {
                bitWiseOpEnum = BitWiseOpEnum.BXOR;
                break;
            }
            default: {
                throw new IllegalArgumentException("Node type " + node.getType() + " not a recognized bit wise node type");
            }
        }
        ExprBitWiseNode bwNode = new ExprBitWiseNode(bitWiseOpEnum);
        this.astExprNodeMap.put(node, bwNode);
    }

    private void leaveWhereClause() {
        log.debug(".leaveWhereClause");
        if (this.astExprNodeMap.size() != 1) {
            throw new IllegalStateException("Where clause generated zero or more then one expression nodes");
        }
        this.statementSpec.setFilterRootNode(this.astExprNodeMap.values().iterator().next());
        this.astExprNodeMap.clear();
    }

    private void leaveHavingClause() {
        log.debug(".leaveHavingClause");
        if (this.astExprNodeMap.size() != 1) {
            throw new IllegalStateException("Having clause generated zero or more then one expression nodes");
        }
        this.statementSpec.setHavingExprRootNode(this.astExprNodeMap.values().iterator().next());
        this.astExprNodeMap.clear();
    }

    private void leaveOutputLimit(Tree node) throws ASTWalkException {
        log.debug(".leaveOutputLimit");
        OutputLimitSpec spec = ASTOutputLimitHelper.buildOutputLimitSpec(node, this.astExprNodeMap, this.variableService, this.engineURI, this.timeProvider, this.exprEvaluatorContext);
        this.statementSpec.setOutputLimitSpec(spec);
        if (spec.getVariableName() != null) {
            this.statementSpec.setHasVariables(true);
            this.addVariable(this.statementSpec, spec.getVariableName());
        }
    }

    private void leaveRowLimit(Tree node) throws ASTWalkException {
        log.debug(".leaveRowLimit");
        RowLimitSpec spec = ASTOutputLimitHelper.buildRowLimitSpec(node);
        this.statementSpec.setRowLimitSpec(spec);
        if (spec.getNumRowsVariable() != null || spec.getOptionalOffsetVariable() != null) {
            this.statementSpec.setHasVariables(true);
            this.addVariable(this.statementSpec, spec.getOptionalOffsetVariable());
        }
    }

    private void leaveOuterInnerJoin(Tree node) {
        OuterJoinType joinType;
        log.debug(".leaveOuterInnerJoin");
        switch (node.getType()) {
            case 155: {
                joinType = OuterJoinType.LEFT;
                break;
            }
            case 156: {
                joinType = OuterJoinType.RIGHT;
                break;
            }
            case 157: {
                joinType = OuterJoinType.FULL;
                break;
            }
            case 154: {
                joinType = OuterJoinType.INNER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Node type " + node.getType() + " not a recognized outer join node type");
            }
        }
        ExprIdentNode left = (ExprIdentNode)this.astExprNodeMap.get(node.getChild(0));
        ExprIdentNode right = (ExprIdentNode)this.astExprNodeMap.get(node.getChild(1));
        this.astExprNodeMap.remove(node.getChild(0));
        this.astExprNodeMap.remove(node.getChild(1));
        ExprIdentNode[] addLeftArr = null;
        ExprIdentNode[] addRightArr = null;
        if (node.getChildCount() > 2) {
            ArrayList<ExprIdentNode> addLeft = new ArrayList<ExprIdentNode>();
            ArrayList<ExprIdentNode> addRight = new ArrayList<ExprIdentNode>();
            for (int i = 2; i < node.getChildCount(); i += 2) {
                Tree child = node.getChild(i);
                addLeft.add((ExprIdentNode)this.astExprNodeMap.remove(child));
                addRight.add((ExprIdentNode)this.astExprNodeMap.remove(node.getChild(i + 1)));
            }
            addLeftArr = addLeft.toArray(new ExprIdentNode[addLeft.size()]);
            addRightArr = addRight.toArray(new ExprIdentNode[addRight.size()]);
        }
        OuterJoinDesc outerJoinDesc = new OuterJoinDesc(joinType, left, right, addLeftArr, addRightArr);
        this.statementSpec.getOuterJoinDescList().add(outerJoinDesc);
    }

    private void leaveGroupBy(Tree node) {
        log.debug(".leaveGroupBy");
        if (this.astExprNodeMap.size() < 1) {
            throw new IllegalStateException("Group-by clause generated no expression nodes");
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            Tree child = node.getChild(i);
            ExprNode exprNode = this.astExprNodeMap.get(child);
            if (exprNode == null) {
                throw new IllegalStateException("Expression node as a result of group-by child node not found in collection");
            }
            this.statementSpec.getGroupByExpressions().add(exprNode);
        }
        this.astExprNodeMap.clear();
    }

    private void leaveInsertInto(Tree node) {
        log.debug(".leaveInsertInto");
        int count = 0;
        Tree child = node.getChild(count);
        boolean isIStream = true;
        if (child.getType() == 59) {
            isIStream = false;
            child = node.getChild(++count);
        }
        if (child.getType() == 60) {
            child = node.getChild(++count);
        }
        String eventTypeName = child.getText();
        InsertIntoDesc insertIntoDesc = new InsertIntoDesc(isIStream, eventTypeName);
        if ((child = node.getChild(++count)) != null && child.getType() == 175) {
            for (int i = 0; i < child.getChildCount(); ++i) {
                Tree childNode = child.getChild(i);
                insertIntoDesc.add(childNode.getText());
            }
        }
        this.statementSpec.setInsertIntoDesc(insertIntoDesc);
    }

    private void leaveOrderByElement(Tree node) throws ASTWalkException {
        log.debug(".leaveOrderByElement");
        if (this.astExprNodeMap.size() > 1 || this.astExprNodeMap.isEmpty()) {
            throw new ASTWalkException("Unexpected AST tree contains zero or more then 1 child element for root");
        }
        ExprNode exprNode = this.astExprNodeMap.values().iterator().next();
        this.astExprNodeMap.clear();
        boolean descending = false;
        if (node.getChildCount() > 1) {
            descending = node.getChild(1).getType() == 58;
        }
        this.statementSpec.getOrderByList().add(new OrderByItem(exprNode, descending));
    }

    private void leaveConcat(Tree node) {
        ExprConcatNode concatNode = new ExprConcatNode();
        this.astExprNodeMap.put(node, concatNode);
    }

    private void leaveEvery(Tree node) {
        log.debug(".leaveEvery");
        EvalEveryNode everyNode = new EvalEveryNode();
        this.astPatternNodeMap.put(node, everyNode);
    }

    private void leaveEveryDistinct(Tree node) {
        log.debug(".leaveEveryDistinct");
        List<ExprNode> exprNodes = this.getExprNodes(node.getChild(0), 0);
        EvalEveryDistinctNode everyNode = new EvalEveryDistinctNode(exprNodes, null);
        this.astPatternNodeMap.put(node, everyNode);
    }

    private void leaveStreamFilter(Tree node) {
        log.debug(".leaveStreamFilter");
        int count = 0;
        Tree startNode = node.getChild(0);
        if (startNode.getType() == 262) {
            startNode = node.getChild(++count);
        }
        String eventName = startNode.getText();
        if (node.getChildCount() > ++count && node.getChild(count).getType() == 120) {
            ++count;
        }
        List<ExprNode> exprNodes = this.getExprNodes(node, count);
        FilterSpecRaw rawFilterSpec = new FilterSpecRaw(eventName, exprNodes, this.propertyEvalSpec);
        this.propertyEvalSpec = null;
        this.filterSpec = rawFilterSpec;
        this.astExprNodeMap.clear();
    }

    private void leavePatternFilter(Tree node) {
        log.debug(".leavePatternFilter");
        int count = 0;
        Tree startNode = node.getChild(0);
        String optionalPatternTagName = null;
        if (startNode.getType() == 262) {
            optionalPatternTagName = startNode.getText();
            startNode = node.getChild(++count);
        }
        String eventName = startNode.getText();
        if (node.getChildCount() > ++count && node.getChild(count).getType() == 120) {
            ++count;
        }
        List<ExprNode> exprNodes = this.getExprNodes(node, count);
        FilterSpecRaw rawFilterSpec = new FilterSpecRaw(eventName, exprNodes, this.propertyEvalSpec);
        this.propertyEvalSpec = null;
        EvalFilterNode filterNode = new EvalFilterNode(rawFilterSpec, optionalPatternTagName);
        this.astPatternNodeMap.put(node, filterNode);
    }

    private void leaveFollowedBy(Tree node) {
        log.debug(".leaveFollowedBy");
        EvalFollowedByNode fbNode = new EvalFollowedByNode();
        this.astPatternNodeMap.put(node, fbNode);
    }

    private void leaveAnd(Tree node) {
        log.debug(".leaveAnd");
        EvalAndNode andNode = new EvalAndNode();
        this.astPatternNodeMap.put(node, andNode);
    }

    private void leaveOr(Tree node) {
        log.debug(".leaveOr");
        EvalOrNode orNode = new EvalOrNode();
        this.astPatternNodeMap.put(node, orNode);
    }

    private void leaveInSet(Tree node) {
        log.debug(".leaveInSet");
        ExprInNode inNode = new ExprInNode(node.getType() == 186);
        this.astExprNodeMap.put(node, inNode);
    }

    private void leaveInRange(Tree node) {
        log.debug(".leaveInRange");
        Tree bracesNode = node.getChild(1);
        if (bracesNode.getType() != 267 && bracesNode.getType() != 265) {
            throw new IllegalStateException("Invalid in-range syntax, no braces but type '" + bracesNode.getType() + "'");
        }
        boolean isLowInclude = bracesNode.getType() == 267;
        bracesNode = node.getChild(4);
        if (bracesNode.getType() != 268 && bracesNode.getType() != 266) {
            throw new IllegalStateException("Invalid in-range syntax, no braces but type '" + bracesNode.getType() + "'");
        }
        boolean isHighInclude = bracesNode.getType() == 268;
        ExprBetweenNode betweenNode = new ExprBetweenNode(isLowInclude, isHighInclude, node.getType() == 196);
        this.astExprNodeMap.put(node, betweenNode);
    }

    private void leaveBetween(Tree node) {
        log.debug(".leaveBetween");
        ExprBetweenNode betweenNode = new ExprBetweenNode(true, true, node.getType() == 187);
        this.astExprNodeMap.put(node, betweenNode);
    }

    private void leaveLike(Tree node) {
        log.debug(".leaveLike");
        boolean isNot = node.getType() == 188;
        ExprLikeNode likeNode = new ExprLikeNode(isNot);
        this.astExprNodeMap.put(node, likeNode);
    }

    private void leaveRegexp(Tree node) {
        log.debug(".leaveRegexp");
        boolean isNot = node.getType() == 189;
        ExprRegexpNode regExpNode = new ExprRegexpNode(isNot);
        this.astExprNodeMap.put(node, regExpNode);
    }

    private void leaveExprNot(Tree node) {
        log.debug(".leaveExprNot");
        ExprNotNode notNode = new ExprNotNode();
        this.astExprNodeMap.put(node, notNode);
    }

    private void leavePatternNot(Tree node) {
        log.debug(".leavePatternNot");
        EvalNotNode notNode = new EvalNotNode();
        this.astPatternNodeMap.put(node, notNode);
    }

    private void leaveGuard(Tree node) throws ASTWalkException {
        List<ExprNode> obsParameters;
        String objectName;
        String objectNamespace;
        log.debug(".leaveGuard");
        if (node.getChild(1).getType() == 262 && node.getChild(2).getType() == 262) {
            objectNamespace = node.getChild(1).getText();
            objectName = node.getChild(2).getText();
            obsParameters = this.getExprNodes(node, 3);
        } else {
            objectNamespace = GuardEnum.WHILE_GUARD.getNamespace();
            objectName = GuardEnum.WHILE_GUARD.getName();
            obsParameters = this.getExprNodes(node, 1);
        }
        PatternGuardSpec guardSpec = new PatternGuardSpec(objectNamespace, objectName, obsParameters);
        EvalGuardNode guardNode = new EvalGuardNode(guardSpec);
        this.astPatternNodeMap.put(node, guardNode);
    }

    private void leaveCaseNode(Tree node, boolean inCase2) {
        if (log.isDebugEnabled()) {
            log.debug(".leaveCase2Node inCase2=" + inCase2);
        }
        if (this.astExprNodeMap.isEmpty()) {
            throw new ASTWalkException("Unexpected AST tree contains zero child element for case node");
        }
        if (this.astExprNodeMap.size() == 1) {
            throw new ASTWalkException("AST tree doesn not contain at least when node for case node");
        }
        ExprCaseNode caseNode = new ExprCaseNode(inCase2);
        this.astExprNodeMap.put(node, caseNode);
    }

    private void leaveObserver(Tree node) throws ASTWalkException {
        log.debug(".leaveObserver");
        String objectNamespace = node.getChild(0).getText();
        String objectName = node.getChild(1).getText();
        List<ExprNode> obsParameters = this.getExprNodes(node, 2);
        PatternObserverSpec observerSpec = new PatternObserverSpec(objectNamespace, objectName, obsParameters);
        EvalObserverNode observerNode = new EvalObserverNode(observerSpec);
        this.astPatternNodeMap.put(node, observerNode);
    }

    private void leaveMatch(Tree node) throws ASTWalkException {
        EvalMatchUntilSpec spec;
        Double low;
        log.debug(".leaveMatch");
        boolean hasRange = true;
        int type = node.getChild(0).getType();
        if (type == 222) {
            low = DoubleValue.parseString(node.getChild(0).getChild(0).getText());
            spec = new EvalMatchUntilSpec(low.intValue(), null);
        } else if (type == 223) {
            Double highVal;
            String high = node.getChild(0).getChild(0).getText();
            if (high.charAt(0) == '.') {
                high = high.substring(1);
            }
            if ((highVal = Double.valueOf(DoubleValue.parseString(high))).intValue() == 0) {
                throw new ASTWalkException("Incorrect range specification, a high endpoint of zero is not allowed");
            }
            spec = new EvalMatchUntilSpec(null, highVal.intValue());
        } else if (type == 225) {
            low = DoubleValue.parseString(node.getChild(0).getChild(0).getText());
            if (low == 0.0) {
                throw new ASTWalkException("Incorrect range specification, a bounds of zero is not allowed");
            }
            spec = new EvalMatchUntilSpec(low.intValue(), low.intValue());
        } else if (type == 224) {
            Double highVal;
            low = DoubleValue.parseString(node.getChild(0).getChild(0).getText());
            String high = node.getChild(0).getChild(1).getText();
            if (high.charAt(0) == '.') {
                high = high.substring(1);
            }
            if ((highVal = Double.valueOf(DoubleValue.parseString(high))) < low) {
                throw new ASTWalkException("Incorrect range specification, lower bounds value '" + low.intValue() + "' is higher then higher bounds '" + highVal.intValue() + "'");
            }
            if (highVal == 0.0 && low == 0.0) {
                throw new ASTWalkException("Incorrect range specification, lower bounds and higher bounds values are zero");
            }
            spec = new EvalMatchUntilSpec(low.intValue(), highVal.intValue());
        } else {
            spec = new EvalMatchUntilSpec(null, null);
            hasRange = false;
        }
        if (node.getChildCount() == 2 && hasRange && !spec.isTightlyBound()) {
            throw new ASTWalkException("Variable bounds repeat operator requires an until-expression");
        }
        EvalMatchUntilNode fbNode = new EvalMatchUntilNode(spec);
        this.astPatternNodeMap.put(node, fbNode);
    }

    private void leaveSelectClause(Tree node) {
        log.debug(".leaveSelectClause");
        int nodeType = node.getChild(0).getType();
        if (nodeType == 59) {
            this.statementSpec.setSelectStreamDirEnum(SelectClauseStreamSelectorEnum.RSTREAM_ONLY);
        }
        if (nodeType == 60) {
            this.statementSpec.setSelectStreamDirEnum(SelectClauseStreamSelectorEnum.ISTREAM_ONLY);
        }
        if (nodeType == 61) {
            this.statementSpec.setSelectStreamDirEnum(SelectClauseStreamSelectorEnum.RSTREAM_ISTREAM_BOTH);
        }
        boolean isDistinct = false;
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (node.getChild(i).getType() != 46) continue;
            isDistinct = true;
        }
        this.statementSpec.getSelectClauseSpec().setDistinct(isDistinct);
    }

    private ExprNode getRemoveFirstByType(Tree parent, int type) {
        ExprNode exprNode = null;
        for (int i = 0; i < parent.getChildCount(); ++i) {
            if (parent.getChild(i).getType() != 139) continue;
            exprNode = this.astExprNodeMap.get(parent.getChild(i).getChild(0));
            if (exprNode == null) {
                throw new IllegalStateException("Expression node for AST node not found for type " + parent.getChild(i).getType() + " and text " + parent.getChild(i).getText());
            }
            this.astExprNodeMap.remove(parent.getChild(i));
        }
        return exprNode;
    }

    private List<ExprNode> getExprNodes(Tree parentNode, int startIndex) {
        LinkedList<ExprNode> exprNodes = new LinkedList<ExprNode>();
        for (int i = startIndex; i < parentNode.getChildCount(); ++i) {
            Tree currentNode = parentNode.getChild(i);
            ExprNode exprNode = this.astExprNodeMap.get(currentNode);
            if (exprNode == null) {
                throw new IllegalStateException("Expression node for AST node not found for type " + currentNode.getType() + " and text " + currentNode.getText());
            }
            exprNodes.add(exprNode);
            this.astExprNodeMap.remove(currentNode);
        }
        return exprNodes;
    }

    private boolean isSelectInsertFirst(Tree child) {
        for (int i = 0; i < child.getChildCount(); ++i) {
            if (child.getChild(i).getType() != 216 || child.getChild(i).getChild(0).getType() != 47) continue;
            return false;
        }
        return true;
    }
}

