/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.parse;

import com.espertech.esper.client.EPStatementSyntaxException;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.epl.generated.EsperEPL2Ast;
import com.espertech.esper.epl.generated.EsperEPL2GrammarParser;
import java.util.Set;
import java.util.Stack;
import org.antlr.runtime.EarlyExitException;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionConvertor {
    public static EPStatementSyntaxException convertStatement(RecognitionException e2, String expression, boolean addPleaseCheck, EsperEPL2GrammarParser parser) {
        UniformPair<String> pair = ExceptionConvertor.convert(e2, expression, addPleaseCheck, parser);
        return new EPStatementSyntaxException(pair.getFirst(), pair.getSecond());
    }

    public static PropertyAccessException convertProperty(RecognitionException e2, String expression, boolean addPleaseCheck, EsperEPL2GrammarParser parser) {
        UniformPair<String> pair = ExceptionConvertor.convert(e2, expression, addPleaseCheck, parser);
        return new PropertyAccessException(pair.getFirst(), pair.getSecond());
    }

    public static UniformPair<String> convert(RecognitionException e2, String expression, boolean addPleaseCheck, EsperEPL2GrammarParser parser) {
        Set<String> keywords;
        Token t;
        if (expression.trim().length() == 0) {
            String message = "Unexpected end of input";
            return new UniformPair<String>(message, expression);
        }
        Token tBefore = null;
        Token tAfter = null;
        if (e2.index < parser.getTokenStream().size()) {
            t = parser.getTokenStream().get(e2.index);
            if (e2.index + 1 < parser.getTokenStream().size()) {
                tAfter = parser.getTokenStream().get(e2.index + 1);
            }
            if (e2.index - 1 >= 0) {
                tBefore = parser.getTokenStream().get(e2.index - 1);
            }
        } else {
            if (parser.getTokenStream().size() >= 2) {
                tBefore = parser.getTokenStream().get(parser.getTokenStream().size() - 2);
            }
            t = parser.getTokenStream().get(parser.getTokenStream().size() - 1);
        }
        String positionInfo = ExceptionConvertor.getPositionInfo(t);
        String token = "'" + t.getText() + "'";
        Stack stack = parser.getParaphrases();
        String check = "";
        if (stack.size() > 0 && addPleaseCheck) {
            String delimiter = "";
            StringBuilder checkList = new StringBuilder();
            checkList.append(", please check the ");
            while (stack.size() != 0) {
                checkList.append(delimiter);
                checkList.append(stack.pop());
                delimiter = " within the ";
            }
            check = checkList.toString();
        }
        if ((keywords = parser.getKeywords()).contains(token.toLowerCase())) {
            token = token + " (a reserved keyword)";
        } else if (tBefore != null && tAfter != null && keywords.contains("'" + tBefore.getText().toLowerCase() + "'") && keywords.contains("'" + tAfter.getText().toLowerCase() + "'")) {
            token = token + " ('" + tBefore.getText() + "' and '" + tAfter.getText() + "' are a reserved keyword)";
        } else if (tBefore != null && keywords.contains("'" + tBefore.getText().toLowerCase() + "'")) {
            token = token + " ('" + tBefore.getText() + "' is a reserved keyword)";
        }
        String message = "Incorrect syntax near " + token + positionInfo + check;
        if (e2 instanceof NoViableAltException) {
            NoViableAltException nvae = (NoViableAltException)e2;
            if (nvae.token.getType() == -1) {
                message = "Unexpected end of input near " + token + positionInfo + check;
            } else if (parser.getParserTokenParaphrases().get(nvae.token.getType()) != null) {
                message = "Incorrect syntax near " + token + positionInfo + check;
            } else {
                for (int currentIndex = e2.index + 1; currentIndex > 0 && currentIndex < parser.getTokenStream().size() - 1 && currentIndex < e2.index + 3; ++currentIndex) {
                    Token next = parser.getTokenStream().get(currentIndex);
                    String quotedToken = "'" + next.getText() + "'";
                    if (!parser.getKeywords().contains(quotedToken)) continue;
                    check = check + " near reserved keyword '" + next.getText() + "'";
                    break;
                }
                message = "Incorrect syntax near " + token + positionInfo + check;
            }
        }
        if (e2 instanceof MismatchedTokenException) {
            MismatchedTokenException mismatched = (MismatchedTokenException)e2;
            String expected = "end of input";
            if (mismatched.expecting >= 0 && mismatched.expecting < parser.getTokenNames().length) {
                expected = parser.getTokenNames()[mismatched.expecting];
            }
            if (parser.getLexerTokenParaphrases().get(mismatched.expecting) != null) {
                expected = parser.getLexerTokenParaphrases().get(mismatched.expecting);
            }
            if (parser.getParserTokenParaphrases().get(mismatched.expecting) != null) {
                expected = parser.getParserTokenParaphrases().get(mismatched.expecting);
            }
            String unexpected = mismatched.getUnexpectedType() < 0 || mismatched.getUnexpectedType() >= parser.getTokenNames().length ? "end of input" : parser.getTokenNames()[mismatched.getUnexpectedType()];
            if (parser.getLexerTokenParaphrases().get(mismatched.getUnexpectedType()) != null) {
                unexpected = parser.getLexerTokenParaphrases().get(mismatched.getUnexpectedType());
            }
            if (parser.getParserTokenParaphrases().get(mismatched.getUnexpectedType()) != null) {
                unexpected = parser.getParserTokenParaphrases().get(mismatched.getUnexpectedType());
            }
            String expecting = " expecting " + expected.trim() + " but found " + unexpected.trim();
            message = "Incorrect syntax near " + token + expecting + positionInfo + check;
        }
        if (e2 instanceof EarlyExitException) {
            EarlyExitException ee = (EarlyExitException)e2;
            char c = (char)ee.c;
            message = "Incorrect syntax near " + token + positionInfo + " unexpected character '" + c + "', check for an invalid identifier";
        }
        return new UniformPair<String>(message, expression);
    }

    public static EPStatementSyntaxException convert(RecognitionException e2, String expression, EsperEPL2Ast treeWalker) {
        String positionInfo = ExceptionConvertor.getPositionInfo(e2.token);
        String tokenName = "end of input";
        if (e2.token != null && e2.token.getType() >= 0 && e2.token.getType() < treeWalker.getTokenNames().length) {
            tokenName = treeWalker.getTokenNames()[e2.token.getType()];
        }
        String message = "Unexpected error processing statement near token " + tokenName + positionInfo;
        if (e2 instanceof MismatchedTokenException) {
            MismatchedTokenException mismatched = (MismatchedTokenException)e2;
            String expected = "end of input";
            if (mismatched.expecting >= 0 && mismatched.expecting < treeWalker.getTokenNames().length) {
                expected = treeWalker.getTokenNames()[mismatched.expecting];
            }
            String unexpected = mismatched.getUnexpectedType() < 0 || mismatched.getUnexpectedType() >= treeWalker.getTokenNames().length ? "end of input" : treeWalker.getTokenNames()[mismatched.getUnexpectedType()];
            String expecting = " expecting " + expected.trim() + " but found " + unexpected.trim();
            message = "Unexpected error processing statement near token " + tokenName + expecting + positionInfo;
        }
        return new EPStatementSyntaxException(message, expression);
    }

    private static String getPositionInfo(Token t) {
        return t.getLine() > 0 && t.getCharPositionInLine() > 0 ? " at line " + t.getLine() + " column " + t.getCharPositionInLine() : "";
    }
}

