/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.parse;

import com.espertech.esper.antlr.ASTUtil;
import com.espertech.esper.antlr.NoCaseSensitiveStream;
import com.espertech.esper.client.EPException;
import com.espertech.esper.epl.generated.EsperEPL2GrammarLexer;
import com.espertech.esper.epl.generated.EsperEPL2GrammarParser;
import com.espertech.esper.epl.parse.EPLTreeWalker;
import com.espertech.esper.epl.parse.ExceptionConvertor;
import com.espertech.esper.epl.parse.ParseResult;
import com.espertech.esper.epl.parse.ParseRuleSelector;
import com.espertech.esper.epl.parse.WalkRuleSelector;
import java.io.IOException;
import java.io.StringReader;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParseHelper {
    public static final String newline = System.getProperty("line.separator");
    private static Log log = LogFactory.getLog(ParseHelper.class);

    public static void walk(Tree ast, EPLTreeWalker walker, WalkRuleSelector walkRuleSelector, String expression, String eplStatementForErrorMsg) {
        try {
            if (log.isDebugEnabled()) {
                log.debug(".walk Walking AST using walker " + walker.getClass().getName());
            }
            walkRuleSelector.invokeWalkRule(walker);
            if (log.isDebugEnabled()) {
                log.debug(".walk AST tree after walking");
                ASTUtil.dumpAST(ast);
            }
        }
        catch (RuntimeException e2) {
            log.info("Error walking statement [" + expression + "]", e2);
            if (e2.getCause() instanceof RecognitionException) {
                throw ExceptionConvertor.convert((RecognitionException)e2.getCause(), eplStatementForErrorMsg, walker);
            }
            throw e2;
        }
        catch (RecognitionException e3) {
            log.info("Error walking statement [" + expression + "]", e3);
            throw ExceptionConvertor.convert(e3, eplStatementForErrorMsg, walker);
        }
    }

    public static ParseResult parse(String expression, String eplStatementErrorMsg, boolean addPleaseCheck, ParseRuleSelector parseRuleSelector) throws EPException {
        Tree tree;
        NoCaseSensitiveStream input;
        if (log.isDebugEnabled()) {
            log.debug(".parse Parsing expr=" + expression);
        }
        try {
            input = new NoCaseSensitiveStream(new StringReader(expression));
        }
        catch (IOException ex) {
            throw new EPException("IOException parsing expression '" + expression + '\'', ex);
        }
        EsperEPL2GrammarLexer lex = new EsperEPL2GrammarLexer(input);
        CommonTokenStream tokens2 = new CommonTokenStream(lex);
        EsperEPL2GrammarParser parser = new EsperEPL2GrammarParser(tokens2);
        try {
            tree = parseRuleSelector.invokeParseRule(parser);
        }
        catch (RuntimeException e2) {
            if (log.isDebugEnabled()) {
                log.debug("Error parsing statement [" + eplStatementErrorMsg + "]", e2);
            }
            if (e2.getCause() instanceof RecognitionException) {
                throw ExceptionConvertor.convertStatement((RecognitionException)e2.getCause(), eplStatementErrorMsg, addPleaseCheck, parser);
            }
            throw e2;
        }
        catch (RecognitionException ex) {
            log.debug("Error parsing statement [" + expression + "]", ex);
            throw ExceptionConvertor.convertStatement(ex, eplStatementErrorMsg, addPleaseCheck, parser);
        }
        if (log.isDebugEnabled()) {
            log.debug(".parse Dumping AST...");
            ASTUtil.dumpAST(tree);
        }
        return new ParseResult(tree, ParseHelper.getNoAnnotation(expression, tree, tokens2));
    }

    private static String getNoAnnotation(String expression, Tree tree, CommonTokenStream tokens2) {
        Token lastAnnotationToken = null;
        for (int i = 0; i < tree.getChildCount() && tree.getChild(i).getType() == 229; ++i) {
            lastAnnotationToken = tokens2.get(tree.getChild(i).getTokenStopIndex());
        }
        if (lastAnnotationToken == null) {
            return null;
        }
        try {
            int line = lastAnnotationToken.getLine();
            int charpos = lastAnnotationToken.getCharPositionInLine();
            int fromChar = charpos + lastAnnotationToken.getText().length();
            if (line == 1) {
                return expression.substring(fromChar).trim();
            }
            String[] lines = expression.split("\r\n|\r|\n");
            StringBuilder buf = new StringBuilder();
            buf.append(lines[line - 1].substring(fromChar));
            for (int i = line; i < lines.length; ++i) {
                buf.append(lines[i]);
                if (i >= lines.length - 1) continue;
                buf.append(newline);
            }
            return buf.toString().trim();
        }
        catch (RuntimeException ex) {
            log.error("Error determining non-annotated expression sting: " + ex.getMessage(), ex);
            return null;
        }
    }
}

