/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.property;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.FragmentEventType;
import com.espertech.esper.collection.ArrayDequeJDK6Backport;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.property.PropertyEvaluator;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyEvaluatorNested
implements PropertyEvaluator {
    private static final Log log = LogFactory.getLog(PropertyEvaluatorNested.class);
    private final EventPropertyGetter[] getter;
    private final FragmentEventType[] fragmentEventType;
    private final ExprNode[] whereClauses;
    private final EventBean[] eventsPerStream;
    private final int lastLevel;
    private final List<String> propertyNames;

    public PropertyEvaluatorNested(EventPropertyGetter[] getter, FragmentEventType[] fragmentEventType, ExprNode[] whereClauses, List<String> propertyNames) {
        this.fragmentEventType = fragmentEventType;
        this.getter = getter;
        this.whereClauses = whereClauses;
        this.lastLevel = fragmentEventType.length - 1;
        this.eventsPerStream = new EventBean[fragmentEventType.length + 1];
        this.propertyNames = propertyNames;
    }

    @Override
    public EventBean[] getProperty(EventBean event, ExprEvaluatorContext exprEvaluatorContext) {
        ArrayDequeJDK6Backport<EventBean> resultEvents = new ArrayDequeJDK6Backport<EventBean>();
        this.eventsPerStream[0] = event;
        this.populateEvents(event, 0, resultEvents, exprEvaluatorContext);
        if (resultEvents.isEmpty()) {
            return null;
        }
        return resultEvents.toArray(new EventBean[resultEvents.size()]);
    }

    private void populateEvents(EventBean branch, int level, Collection<EventBean> events, ExprEvaluatorContext exprEvaluatorContext) {
        try {
            Object result = this.getter[level].getFragment(branch);
            if (this.fragmentEventType[level].isIndexed()) {
                EventBean[] fragments = (EventBean[])result;
                if (level == this.lastLevel) {
                    if (this.whereClauses[level] != null) {
                        EventBean[] arr$ = fragments;
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$; ++i$) {
                            EventBean event;
                            this.eventsPerStream[level + 1] = event = arr$[i$];
                            if (!ExprNodeUtility.applyFilterExpression(this.whereClauses[level], this.eventsPerStream, exprEvaluatorContext)) continue;
                            events.add(event);
                        }
                    } else {
                        events.addAll(Arrays.asList(fragments));
                    }
                } else if (this.whereClauses[level] != null) {
                    EventBean[] arr$ = fragments;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        EventBean next;
                        this.eventsPerStream[level + 1] = next = arr$[i$];
                        if (!ExprNodeUtility.applyFilterExpression(this.whereClauses[level], this.eventsPerStream, exprEvaluatorContext)) continue;
                        this.populateEvents(next, level + 1, events, exprEvaluatorContext);
                    }
                } else {
                    EventBean[] arr$ = fragments;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        EventBean next;
                        this.eventsPerStream[level + 1] = next = arr$[i$];
                        this.populateEvents(next, level + 1, events, exprEvaluatorContext);
                    }
                }
            } else {
                EventBean fragment = (EventBean)result;
                if (level == this.lastLevel) {
                    if (this.whereClauses[level] != null) {
                        this.eventsPerStream[level + 1] = fragment;
                        if (ExprNodeUtility.applyFilterExpression(this.whereClauses[level], this.eventsPerStream, exprEvaluatorContext)) {
                            events.add(fragment);
                        }
                    } else {
                        events.add(fragment);
                    }
                } else if (this.whereClauses[level] != null) {
                    this.eventsPerStream[level + 1] = fragment;
                    if (ExprNodeUtility.applyFilterExpression(this.whereClauses[level], this.eventsPerStream, exprEvaluatorContext)) {
                        this.populateEvents(fragment, level + 1, events, exprEvaluatorContext);
                    }
                } else {
                    this.eventsPerStream[level + 1] = fragment;
                    this.populateEvents(fragment, level + 1, events, exprEvaluatorContext);
                }
            }
        }
        catch (RuntimeException ex) {
            log.error("Unexpected error evaluating property expression for event of type '" + branch.getEventType().getName() + "' and property '" + this.propertyNames.get(level + 1) + "': " + ex.getMessage(), ex);
        }
    }

    @Override
    public EventType getFragmentEventType() {
        return this.fragmentEventType[this.lastLevel].getFragmentType();
    }

    @Override
    public boolean compareTo(PropertyEvaluator otherEval) {
        return false;
    }
}

