/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.spec;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.FilterSpecRaw;
import com.espertech.esper.epl.spec.FilterStreamSpecCompiled;
import com.espertech.esper.epl.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.epl.spec.StreamSpecBase;
import com.espertech.esper.epl.spec.StreamSpecCompiled;
import com.espertech.esper.epl.spec.StreamSpecOptions;
import com.espertech.esper.epl.spec.StreamSpecRaw;
import com.espertech.esper.epl.spec.ViewSpec;
import com.espertech.esper.event.EventAdapterException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.filter.FilterSpecCompiler;
import com.espertech.esper.util.MetaDefItem;
import java.io.Serializable;
import java.net.URI;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterStreamSpecRaw
extends StreamSpecBase
implements StreamSpecRaw,
MetaDefItem,
Serializable {
    private static Log log = LogFactory.getLog(FilterStreamSpecRaw.class);
    private FilterSpecRaw rawFilterSpec;
    private static final long serialVersionUID = -7919060568262701953L;

    public FilterStreamSpecRaw(FilterSpecRaw rawFilterSpec, List<ViewSpec> viewSpecs, String optionalStreamName, StreamSpecOptions streamSpecOptions) {
        super(optionalStreamName, viewSpecs, streamSpecOptions);
        this.rawFilterSpec = rawFilterSpec;
    }

    public FilterStreamSpecRaw() {
    }

    public FilterSpecRaw getRawFilterSpec() {
        return this.rawFilterSpec;
    }

    @Override
    public StreamSpecCompiled compile(StatementContext context, Set<String> eventTypeReferences, boolean isInsertInto) throws ExprValidationException {
        String eventName = this.rawFilterSpec.getEventTypeName();
        if (context.getNamedWindowService().isNamedWindow(eventName)) {
            EventType namedWindowType = context.getNamedWindowService().getProcessor(eventName).getTailView().getEventType();
            StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(new EventType[]{namedWindowType}, new String[]{"s0"}, new boolean[]{true}, context.getEngineURI());
            List<ExprNode> validatedNodes = FilterSpecCompiler.validateAllowSubquery(this.rawFilterSpec.getFilterExpressions(), streamTypeService, context, null, null);
            eventTypeReferences.add(((EventTypeSPI)namedWindowType).getMetadata().getPrimaryName());
            return new NamedWindowConsumerStreamSpec(eventName, this.getOptionalStreamName(), this.getViewSpecs(), validatedNodes, this.getOptions());
        }
        EventType eventType = null;
        if (context.getValueAddEventService().isRevisionTypeName(eventName)) {
            eventType = context.getValueAddEventService().getValueAddUnderlyingType(eventName);
            eventTypeReferences.add(((EventTypeSPI)eventType).getMetadata().getPrimaryName());
        }
        if (eventType == null && (eventType = FilterStreamSpecRaw.resolveType(context.getEngineURI(), eventName, context.getEventAdapterService(), context.getPlugInTypeResolutionURIs())) instanceof EventTypeSPI) {
            eventTypeReferences.add(((EventTypeSPI)eventType).getMetadata().getPrimaryName());
        }
        StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(new EventType[]{eventType}, new String[]{super.getOptionalStreamName()}, new boolean[]{true}, context.getEngineURI());
        FilterSpecCompiled spec = FilterSpecCompiler.makeFilterSpec(eventType, eventName, this.rawFilterSpec.getFilterExpressions(), this.rawFilterSpec.getOptionalPropertyEvalSpec(), null, null, streamTypeService, context.getMethodResolutionService(), context.getSchedulingService(), context.getVariableService(), context.getEventAdapterService(), context.getEngineURI(), this.getOptionalStreamName(), context);
        return new FilterStreamSpecCompiled(spec, this.getViewSpecs(), this.getOptionalStreamName(), this.getOptions());
    }

    protected static EventType resolveType(String engineURI, String eventName, EventAdapterService eventAdapterService, URI[] optionalResolutionURIs) throws ExprValidationException {
        int indexDot;
        EventType eventType = eventAdapterService.getExistsTypeByName(eventName);
        if (eventType != null) {
            return eventType;
        }
        String engineURIQualifier = engineURI;
        if (engineURI == null || "default".equals(engineURI)) {
            engineURIQualifier = "default";
        }
        if (eventName.startsWith(engineURIQualifier) && (indexDot = eventName.indexOf(".")) > 0) {
            String eventNameURI = eventName.substring(0, indexDot);
            String eventNameRemainder = eventName.substring(indexDot + 1);
            if (engineURIQualifier.equals(eventNameURI)) {
                eventType = eventAdapterService.getExistsTypeByName(eventNameRemainder);
            }
        }
        if (eventType != null) {
            return eventType;
        }
        String message = null;
        try {
            eventType = eventAdapterService.addBeanType(eventName, eventName, true);
        }
        catch (EventAdapterException ex) {
            log.info(".resolveType Event type name '" + eventName + "' not resolved as Java-Class event");
            message = "Failed to resolve event type: " + ex.getMessage();
        }
        try {
            eventType = eventAdapterService.addPlugInEventType(eventName, optionalResolutionURIs, null);
        }
        catch (EventAdapterException ex) {
            log.debug(".resolveType Event type name '" + eventName + "' not resolved by plug-in event representations");
        }
        if (eventType == null) {
            throw new ExprValidationException(message);
        }
        return eventType;
    }
}

