/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.variable;

import com.espertech.esper.epl.variable.CurrentValue;
import com.espertech.esper.epl.variable.VersionedValue;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionedValueList<T> {
    private static final Log log = LogFactory.getLog(VersionedValueList.class);
    private final String name;
    private final Lock readLock;
    private final int highWatermark;
    private final boolean errorWhenNotFound;
    private final long millisecondLifetimeOldVersions;
    private volatile CurrentValue<T> currentAndPriorValue;
    private ArrayList<VersionedValue<T>> olderVersions;

    public VersionedValueList(String name, int initialVersion, T initialValue, long timestamp2, long millisecondLifetimeOldVersions, Lock readLock, int highWatermark, boolean errorWhenNotFound) {
        this.name = name;
        this.readLock = readLock;
        this.highWatermark = highWatermark;
        this.olderVersions = new ArrayList();
        this.errorWhenNotFound = errorWhenNotFound;
        this.millisecondLifetimeOldVersions = millisecondLifetimeOldVersions;
        this.currentAndPriorValue = new CurrentValue<Object>(new VersionedValue<T>(initialVersion, initialValue, timestamp2), new VersionedValue<Object>(-1, null, timestamp2));
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getVersion(int versionAndOlder) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".getVersion Thread " + Thread.currentThread().getId() + " for '" + this.name + "' retrieving version " + versionAndOlder + " or older");
        }
        T resultValue = null;
        CurrentValue<T> current = this.currentAndPriorValue;
        if (current.getCurrentVersion().getVersion() <= versionAndOlder) {
            resultValue = current.getCurrentVersion().getValue();
        } else if (current.getPriorVersion().getVersion() != -1 && current.getPriorVersion().getVersion() <= versionAndOlder) {
            resultValue = current.getPriorVersion().getValue();
        } else {
            this.readLock.lock();
            try {
                current = this.currentAndPriorValue;
                if (current.getCurrentVersion().getVersion() <= versionAndOlder) {
                    resultValue = current.getCurrentVersion().getValue();
                } else if (current.getPriorVersion().getVersion() != -1 && current.getPriorVersion().getVersion() <= versionAndOlder) {
                    resultValue = current.getPriorVersion().getValue();
                } else {
                    boolean found = false;
                    for (int i = this.olderVersions.size() - 1; i >= 0; --i) {
                        VersionedValue<T> entry = this.olderVersions.get(i);
                        if (entry.getVersion() > versionAndOlder) continue;
                        resultValue = entry.getValue();
                        found = true;
                        break;
                    }
                    if (!found) {
                        int currentVersion = current.getCurrentVersion().getVersion();
                        int priorVersion = current.getPriorVersion().getVersion();
                        Integer oldestVersion = this.olderVersions.size() > 0 ? Integer.valueOf(this.olderVersions.get(0).getVersion()) : null;
                        Object oldestValue = this.olderVersions.size() > 0 ? this.olderVersions.get(0).getValue() : null;
                        String text = "Variables value for version '" + versionAndOlder + "' and older could not be found" + " (currentVersion=" + currentVersion + " priorVersion=" + priorVersion + " oldestVersion=" + oldestVersion + " numOldVersions=" + this.olderVersions.size() + " oldestValue=" + oldestValue + ")";
                        if (this.errorWhenNotFound) {
                            throw new IllegalStateException(text);
                        }
                        log.warn(text);
                        T t = current.getCurrentVersion().getValue();
                        return t;
                    }
                }
            }
            finally {
                this.readLock.unlock();
            }
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".getVersion Thread " + Thread.currentThread().getId() + " for '" + this.name + " version " + versionAndOlder + " or older result is " + resultValue);
        }
        return resultValue;
    }

    public Object addValue(int version2, T value, long timestamp2) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".addValue Thread " + Thread.currentThread().getId() + " for '" + this.name + "' adding version " + version2 + " at value " + value);
        }
        if (this.currentAndPriorValue.getPriorVersion().getVersion() == -1) {
            this.currentAndPriorValue = new CurrentValue<T>(new VersionedValue<T>(version2, value, timestamp2), this.currentAndPriorValue.getCurrentVersion());
            return this.currentAndPriorValue.getPriorVersion().getValue();
        }
        VersionedValue<T> priorVersion = this.currentAndPriorValue.getPriorVersion();
        this.olderVersions.add(priorVersion);
        if (this.olderVersions.size() >= this.highWatermark) {
            VersionedValue<T> oldestVersion;
            long expireBefore = timestamp2 - this.millisecondLifetimeOldVersions;
            while (this.olderVersions.size() > 0 && (oldestVersion = this.olderVersions.get(0)).getTimestamp() <= expireBefore) {
                this.olderVersions.remove(0);
            }
        }
        this.currentAndPriorValue = new CurrentValue<T>(new VersionedValue<T>(version2, value, timestamp2), this.currentAndPriorValue.getCurrentVersion());
        return this.currentAndPriorValue.getPriorVersion().getValue();
    }

    protected CurrentValue<T> getCurrentAndPriorValue() {
        return this.currentAndPriorValue;
    }

    protected ArrayList<VersionedValue<T>> getOlderVersions() {
        return this.olderVersions;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Variable '").append(this.name).append("' ");
        buffer.append(" current=").append(this.currentAndPriorValue.getCurrentVersion().toString());
        buffer.append(" prior=").append(this.currentAndPriorValue.getCurrentVersion().toString());
        int count = 0;
        for (VersionedValue<T> old : this.olderVersions) {
            buffer.append(" old(").append(count).append(")=").append(old.toString()).append("\n");
            ++count;
        }
        return buffer.toString();
    }
}

