/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.core.EPStatementHandleCallback;
import com.espertech.esper.core.ExtensionServicesContext;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.view.OutputCallback;
import com.espertech.esper.epl.view.OutputCondition;
import com.espertech.esper.schedule.ScheduleHandle;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleParameterException;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.schedule.ScheduleSpec;
import com.espertech.esper.schedule.ScheduleSpecUtil;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OutputConditionCrontab
implements OutputCondition {
    private static final boolean DO_OUTPUT = true;
    private static final boolean FORCE_UPDATE = true;
    private final OutputCallback outputCallback;
    private final ScheduleSlot scheduleSlot;
    private Long currentReferencePoint;
    private StatementContext context;
    private boolean isCallbackScheduled;
    private ScheduleSpec scheduleSpec;
    private static final Log log = LogFactory.getLog(OutputConditionCrontab.class);

    public OutputConditionCrontab(List<ExprNode> scheduleSpecExpressionList, StatementContext context, OutputCallback outputCallback) throws ExprValidationException {
        if (outputCallback == null) {
            throw new NullPointerException("Output condition crontab requires a non-null callback");
        }
        if (context == null) {
            String message = "OutputConditionTime requires a non-null view context";
            throw new NullPointerException(message);
        }
        this.context = context;
        this.outputCallback = outputCallback;
        this.scheduleSlot = context.getScheduleBucket().allocateSlot();
        ExprNode[] expressions = new ExprNode[scheduleSpecExpressionList.size()];
        int count = 0;
        for (ExprNode parameters : scheduleSpecExpressionList) {
            ExprNode node = parameters.getValidatedSubtree(new StreamTypeServiceImpl(context.getEngineURI()), context.getMethodResolutionService(), null, context.getSchedulingService(), context.getVariableService(), context);
            expressions[count++] = node;
        }
        try {
            Object[] scheduleSpecParameterList = OutputConditionCrontab.evaluate(expressions, context);
            this.scheduleSpec = ScheduleSpecUtil.computeValues(scheduleSpecParameterList);
        }
        catch (ScheduleParameterException e2) {
            throw new IllegalArgumentException("Invalid schedule specification : " + e2.getMessage(), e2);
        }
    }

    @Override
    public final void updateOutputCondition(int newEventsCount, int oldEventsCount) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".updateOutputCondition,   newEventsCount==" + newEventsCount + "  oldEventsCount==" + oldEventsCount);
        }
        if (this.currentReferencePoint == null) {
            this.currentReferencePoint = this.context.getSchedulingService().getTime();
        }
        if (!this.isCallbackScheduled) {
            this.scheduleCallback();
        }
    }

    public final String toString() {
        return this.getClass().getName() + " spec=" + this.scheduleSpec;
    }

    private void scheduleCallback() {
        this.isCallbackScheduled = true;
        long current = this.context.getSchedulingService().getTime();
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".scheduleCallback Scheduled new callback for  now=" + current + " currentReferencePoint=" + this.currentReferencePoint + " spec=" + this.scheduleSpec);
        }
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            public void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
                OutputConditionCrontab.this.isCallbackScheduled = false;
                OutputConditionCrontab.this.outputCallback.continueOutputProcessing(true, true);
                OutputConditionCrontab.this.scheduleCallback();
            }
        };
        EPStatementHandleCallback handle = new EPStatementHandleCallback(this.context.getEpStatementHandle(), callback);
        this.context.getSchedulingService().add(this.scheduleSpec, (ScheduleHandle)handle, this.scheduleSlot);
    }

    private static Object[] evaluate(ExprNode[] parameters, ExprEvaluatorContext exprEvaluatorContext) {
        Object[] results = new Object[parameters.length];
        int count = 0;
        for (ExprNode expr : parameters) {
            try {
                results[count] = expr.evaluate(null, true, exprEvaluatorContext);
                ++count;
            }
            catch (RuntimeException ex) {
                String message = "Failed expression evaluation in crontab timer-at for parameter " + count + ": " + ex.getMessage();
                log.error(message, ex);
                throw new IllegalArgumentException(message);
            }
        }
        return results;
    }
}

