/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.core.EPStatementHandleCallback;
import com.espertech.esper.core.ExtensionServicesContext;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.expression.ExprTimePeriod;
import com.espertech.esper.epl.view.OutputCallback;
import com.espertech.esper.epl.view.OutputCondition;
import com.espertech.esper.schedule.ScheduleHandle;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.util.ExecutionPathDebugLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class OutputConditionTime
implements OutputCondition {
    private static final boolean DO_OUTPUT = true;
    private static final boolean FORCE_UPDATE = true;
    private ExprTimePeriod timePeriod;
    private long msecIntervalSize;
    private final OutputCallback outputCallback;
    private final ScheduleSlot scheduleSlot;
    private Long currentReferencePoint;
    private StatementContext context;
    private boolean isCallbackScheduled;
    private EPStatementHandleCallback handle;
    private static final Log log = LogFactory.getLog(OutputConditionTime.class);

    public OutputConditionTime(ExprTimePeriod timePeriod, StatementContext context, OutputCallback outputCallback) {
        if (outputCallback == null) {
            throw new NullPointerException("Output condition by count requires a non-null callback");
        }
        if (context == null) {
            String message = "OutputConditionTime requires a non-null view context";
            throw new NullPointerException(message);
        }
        this.context = context;
        this.outputCallback = outputCallback;
        this.scheduleSlot = context.getScheduleBucket().allocateSlot();
        this.timePeriod = timePeriod;
        Double numSeconds = (Double)timePeriod.evaluate(null, true, context);
        if (numSeconds == null) {
            throw new IllegalArgumentException("Output condition by time returned a null value for the interval size");
        }
        if (numSeconds < 0.001 && !timePeriod.hasVariable()) {
            throw new IllegalArgumentException("Output condition by time requires a interval size of at least 1 msec or a variable");
        }
        this.msecIntervalSize = Math.round(1000.0 * numSeconds);
    }

    public final long getMsecIntervalSize() {
        return this.msecIntervalSize;
    }

    public final void updateOutputCondition(int newEventsCount, int oldEventsCount) {
        long newMsecIntervalSize;
        Double numSeconds;
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".updateOutputCondition,   newEventsCount==" + newEventsCount + "  oldEventsCount==" + oldEventsCount);
        }
        if (this.currentReferencePoint == null) {
            this.currentReferencePoint = this.context.getSchedulingService().getTime();
        }
        if (this.timePeriod.hasVariable() && (numSeconds = (Double)this.timePeriod.evaluate(null, true, this.context)) != null && (newMsecIntervalSize = Math.round(1000.0 * numSeconds)) != this.msecIntervalSize && this.isCallbackScheduled) {
            this.context.getSchedulingService().remove(this.handle, this.scheduleSlot);
            this.scheduleCallback();
        }
        if (!this.isCallbackScheduled) {
            this.scheduleCallback();
        }
    }

    public final String toString() {
        return this.getClass().getName() + " msecIntervalSize=" + this.msecIntervalSize;
    }

    private void scheduleCallback() {
        Double param;
        if (this.timePeriod.hasVariable() && (param = (Double)this.timePeriod.evaluate(null, true, this.context)) != null) {
            this.msecIntervalSize = Math.round(1000.0 * param);
        }
        this.isCallbackScheduled = true;
        long current = this.context.getSchedulingService().getTime();
        long afterMSec = OutputConditionTime.computeWaitMSec(current, this.currentReferencePoint, this.msecIntervalSize);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".scheduleCallback Scheduled new callback for  afterMsec=" + afterMSec + " now=" + current + " currentReferencePoint=" + this.currentReferencePoint + " msecIntervalSize=" + this.msecIntervalSize);
        }
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            public void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
                OutputConditionTime.this.isCallbackScheduled = false;
                OutputConditionTime.this.outputCallback.continueOutputProcessing(true, true);
                OutputConditionTime.this.scheduleCallback();
            }
        };
        this.handle = new EPStatementHandleCallback(this.context.getEpStatementHandle(), callback);
        this.context.getSchedulingService().add(afterMSec, (ScheduleHandle)this.handle, this.scheduleSlot);
    }

    protected static long computeWaitMSec(long current, long reference, long interval) {
        long solution;
        long n = (long)((float)(current - reference) / ((float)interval * 1.0f));
        if (reference > current) {
            --n;
        }
        if ((solution = reference + (n + 1L) * interval - current) == 0L) {
            return interval;
        }
        return solution;
    }
}

