/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.EventDistinctIterator;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.core.StatementResultListener;
import com.espertech.esper.core.StatementResultService;
import com.espertech.esper.core.UpdateDispatchView;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.expression.ExprTimePeriod;
import com.espertech.esper.epl.join.JoinExecutionStrategy;
import com.espertech.esper.epl.join.JoinSetIndicator;
import com.espertech.esper.epl.view.OutputStrategy;
import com.espertech.esper.event.EventBeanReader;
import com.espertech.esper.event.EventBeanReaderDefaultImpl;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.view.View;
import com.espertech.esper.view.Viewable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OutputProcessView
implements View,
JoinSetIndicator {
    private static final Log log = LogFactory.getLog(OutputProcessView.class);
    private JoinExecutionStrategy joinExecutionStrategy;
    private Long afterConditionTime;
    private Integer afterConditionNumberOfEvents;
    private int afterConditionEventsFound;
    protected StatementContext statementContext;
    protected boolean isAfterConditionSatisfied;
    protected final ResultSetProcessor resultSetProcessor;
    protected final OutputStrategy outputStrategy;
    protected final StatementResultService statementResultService;
    protected UpdateDispatchView childView;
    protected Viewable parentView;
    protected boolean isGenerateSynthetic;
    protected final boolean isDistinct;
    protected EventBeanReader eventBeanReader;

    protected OutputProcessView(ResultSetProcessor resultSetProcessor, OutputStrategy outputStrategy, boolean isInsertInto, StatementContext statementContext, boolean isDistinct, ExprTimePeriod afterTimePeriod, Integer afterConditionNumberOfEvents) {
        this.resultSetProcessor = resultSetProcessor;
        this.outputStrategy = outputStrategy;
        this.statementResultService = statementContext.getStatementResultService();
        this.statementContext = statementContext;
        this.isGenerateSynthetic = isInsertInto;
        this.isDistinct = isDistinct;
        if (isDistinct) {
            if (resultSetProcessor.getResultEventType() instanceof EventTypeSPI) {
                EventTypeSPI eventTypeSPI = (EventTypeSPI)resultSetProcessor.getResultEventType();
                this.eventBeanReader = eventTypeSPI.getReader();
            }
            if (this.eventBeanReader == null) {
                this.eventBeanReader = new EventBeanReaderDefaultImpl(resultSetProcessor.getResultEventType());
            }
        }
        this.isAfterConditionSatisfied = true;
        if (afterConditionNumberOfEvents != null) {
            this.afterConditionNumberOfEvents = afterConditionNumberOfEvents;
            this.isAfterConditionSatisfied = false;
        } else if (afterTimePeriod != null) {
            this.isAfterConditionSatisfied = false;
            Object result = afterTimePeriod.evaluate(null, true, statementContext);
            if (result == null) {
                log.warn("The expression in the 'after' clause time period has returned a null value, ignoring after-clause");
                this.isAfterConditionSatisfied = true;
            } else {
                double sec = ((Number)result).doubleValue();
                long msec = (long)(sec * 1000.0);
                this.afterConditionTime = statementContext.getTimeProvider().getTime() + msec;
            }
        }
    }

    public boolean checkAfterCondition(EventBean[] newEvents) {
        return this.isAfterConditionSatisfied || this.checkAfterCondition(newEvents == null ? 0 : newEvents.length);
    }

    public boolean checkAfterCondition(Set<MultiKey<EventBean>> newEvents) {
        return this.isAfterConditionSatisfied || this.checkAfterCondition(newEvents == null ? 0 : newEvents.size());
    }

    public boolean checkAfterCondition(UniformPair<EventBean[]> newOldEvents) {
        return this.isAfterConditionSatisfied || this.checkAfterCondition(newOldEvents == null ? 0 : (newOldEvents.getFirst() == null ? 0 : newOldEvents.getFirst().length));
    }

    private boolean checkAfterCondition(int numOutputEvents) {
        if (this.afterConditionTime != null) {
            long time = this.statementContext.getTimeProvider().getTime();
            if (time < this.afterConditionTime) {
                return false;
            }
            this.isAfterConditionSatisfied = true;
            return true;
        }
        if (this.afterConditionNumberOfEvents != null) {
            this.afterConditionEventsFound += numOutputEvents;
            if (this.afterConditionEventsFound <= this.afterConditionNumberOfEvents) {
                return false;
            }
            this.isAfterConditionSatisfied = true;
            return true;
        }
        this.isAfterConditionSatisfied = true;
        return true;
    }

    @Override
    public Viewable getParent() {
        return this.parentView;
    }

    @Override
    public void setParent(Viewable parent) {
        this.parentView = parent;
    }

    @Override
    public View addView(View view) {
        if (this.childView != null) {
            throw new IllegalStateException("Child view has already been supplied");
        }
        this.childView = (UpdateDispatchView)view;
        return this;
    }

    @Override
    public List<View> getViews() {
        ArrayList<View> views = new ArrayList<View>();
        if (this.childView != null) {
            views.add(this.childView);
        }
        return views;
    }

    @Override
    public void removeAllViews() {
        this.childView = null;
    }

    @Override
    public boolean removeView(View view) {
        if (view != this.childView) {
            throw new IllegalStateException("Cannot remove child view, view has not been supplied");
        }
        this.childView = null;
        return true;
    }

    @Override
    public boolean hasViews() {
        return this.childView != null;
    }

    @Override
    public EventType getEventType() {
        EventType eventType = this.resultSetProcessor.getResultEventType();
        if (eventType != null) {
            return eventType;
        }
        return this.parentView.getEventType();
    }

    public void setJoinExecutionStrategy(JoinExecutionStrategy joinExecutionStrategy) {
        this.joinExecutionStrategy = joinExecutionStrategy;
    }

    @Override
    public Iterator<EventBean> iterator() {
        EventType eventType;
        Iterator<EventBean> iterator;
        if (this.joinExecutionStrategy != null) {
            Set<MultiKey<EventBean>> joinSet = this.joinExecutionStrategy.staticJoin();
            iterator = this.resultSetProcessor.getIterator(joinSet);
            eventType = this.resultSetProcessor.getResultEventType();
        } else if (this.resultSetProcessor != null) {
            iterator = this.resultSetProcessor.getIterator(this.parentView);
            eventType = this.resultSetProcessor.getResultEventType();
        } else {
            iterator = this.parentView.iterator();
            eventType = this.parentView.getEventType();
        }
        if (!this.isDistinct) {
            return iterator;
        }
        return new EventDistinctIterator(iterator, eventType);
    }

    public void indicateEarlyReturn(UniformPair<EventBean[]> newOldEvents) {
        if (newOldEvents == null) {
            return;
        }
        if (this.statementContext.getMetricReportingService() != null && this.statementContext.getMetricReportingService().getStatementOutputHooks() != null && !this.statementContext.getMetricReportingService().getStatementOutputHooks().isEmpty()) {
            for (StatementResultListener listener : this.statementContext.getMetricReportingService().getStatementOutputHooks()) {
                listener.update(newOldEvents.getFirst(), newOldEvents.getSecond(), this.statementContext.getStatementName(), null, null);
            }
        }
    }
}

