/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.epl.spec.OutputLimitSpec;
import com.espertech.esper.epl.view.OutputCallback;
import com.espertech.esper.epl.view.OutputCondition;
import com.espertech.esper.epl.view.OutputProcessView;
import com.espertech.esper.epl.view.OutputStrategy;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.util.AuditPath;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputProcessViewPolicy
extends OutputProcessView {
    private final OutputCondition outputCondition;
    private final OutputLimitLimitType outputLimitLimitType;
    private List<UniformPair<EventBean[]>> viewEventsList = new ArrayList<UniformPair<EventBean[]>>();
    private List<UniformPair<Set<MultiKey<EventBean>>>> joinEventsSet = new ArrayList<UniformPair<Set<MultiKey<EventBean>>>>();
    private static final Log log = LogFactory.getLog(OutputProcessViewPolicy.class);

    public OutputProcessViewPolicy(ResultSetProcessor resultSetProcessor, OutputStrategy outputStrategy, boolean isInsertInto, int streamCount, OutputLimitSpec outputLimitSpec, StatementContext statementContext, boolean isDistinct) throws ExprValidationException {
        super(resultSetProcessor, outputStrategy, isInsertInto, statementContext, isDistinct, outputLimitSpec.getAfterTimePeriodExpr(), outputLimitSpec.getAfterNumberOfEvents());
        log.debug(".ctor");
        if (streamCount < 1) {
            throw new IllegalArgumentException("Output process view is part of at least 1 stream");
        }
        OutputCallback outputCallback = this.getCallbackToLocal(streamCount);
        this.outputCondition = statementContext.getOutputConditionFactory().createCondition(outputLimitSpec, statementContext, outputCallback);
        this.outputLimitLimitType = outputLimitSpec.getDisplayLimit();
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".update Received update,   newData.length==" + (newData == null ? 0 : newData.length) + "  oldData.length==" + (oldData == null ? 0 : oldData.length));
        }
        if (!super.checkAfterCondition(newData)) {
            return;
        }
        int newDataLength = 0;
        int oldDataLength = 0;
        if (newData != null) {
            newDataLength = newData.length;
        }
        if (oldData != null) {
            oldDataLength = oldData.length;
        }
        this.viewEventsList.add(new UniformPair<EventBean[]>(newData, oldData));
        this.outputCondition.updateOutputCondition(newDataLength, oldDataLength);
    }

    @Override
    public void process(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents, ExprEvaluatorContext exprEvaluatorContext) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".process Received update,   newData.length==" + (newEvents == null ? 0 : newEvents.size()) + "  oldData.length==" + (oldEvents == null ? 0 : oldEvents.size()));
        }
        if (!super.checkAfterCondition(newEvents)) {
            return;
        }
        int newEventsSize = 0;
        if (newEvents != null) {
            newEventsSize = newEvents.size();
        }
        int oldEventsSize = 0;
        if (oldEvents != null) {
            oldEventsSize = oldEvents.size();
        }
        LinkedHashSet<Object> copyNew = newEvents != null ? new LinkedHashSet<MultiKey<EventBean>>(newEvents) : new LinkedHashSet();
        LinkedHashSet<Object> copyOld = oldEvents != null ? new LinkedHashSet<MultiKey<EventBean>>(oldEvents) : new LinkedHashSet();
        this.joinEventsSet.add(new UniformPair(copyNew, copyOld));
        this.outputCondition.updateOutputCondition(newEventsSize, oldEventsSize);
    }

    protected void continueOutputProcessingView(boolean doOutput, boolean forceUpdate) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".continueOutputProcessingView");
        }
        boolean isGenerateSynthetic = this.statementResultService.isMakeSynthetic();
        boolean isGenerateNatural = this.statementResultService.isMakeNatural();
        UniformPair<EventBean[]> newOldEvents = this.resultSetProcessor.processOutputLimitedView(this.viewEventsList, isGenerateSynthetic, this.outputLimitLimitType);
        if (this.isDistinct) {
            newOldEvents.setFirst(EventBeanUtility.getDistinctByProp(newOldEvents.getFirst(), this.eventBeanReader));
            newOldEvents.setSecond(EventBeanUtility.getDistinctByProp(newOldEvents.getSecond(), this.eventBeanReader));
        }
        if (!isGenerateSynthetic && !isGenerateNatural) {
            if (AuditPath.isAuditEnabled) {
                super.indicateEarlyReturn(newOldEvents);
            }
            return;
        }
        if (doOutput) {
            this.output(forceUpdate, newOldEvents);
        }
        this.resetEventBatches();
    }

    private void output(boolean forceUpdate, UniformPair<EventBean[]> results) {
        if (this.childView != null) {
            this.outputStrategy.output(forceUpdate, results, this.childView);
        }
    }

    private void resetEventBatches() {
        this.viewEventsList.clear();
        this.joinEventsSet.clear();
    }

    protected void continueOutputProcessingJoin(boolean doOutput, boolean forceUpdate) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".continueOutputProcessingJoin");
        }
        boolean isGenerateSynthetic = this.statementResultService.isMakeSynthetic();
        boolean isGenerateNatural = this.statementResultService.isMakeNatural();
        UniformPair<EventBean[]> newOldEvents = this.resultSetProcessor.processOutputLimitedJoin(this.joinEventsSet, isGenerateSynthetic, this.outputLimitLimitType);
        if (this.isDistinct) {
            newOldEvents.setFirst(EventBeanUtility.getDistinctByProp(newOldEvents.getFirst(), this.eventBeanReader));
            newOldEvents.setSecond(EventBeanUtility.getDistinctByProp(newOldEvents.getSecond(), this.eventBeanReader));
        }
        if (!isGenerateSynthetic && !isGenerateNatural) {
            if (AuditPath.isAuditEnabled) {
                super.indicateEarlyReturn(newOldEvents);
            }
            return;
        }
        if (doOutput) {
            this.output(forceUpdate, newOldEvents);
        }
        this.resetEventBatches();
    }

    private OutputCallback getCallbackToLocal(int streamCount) {
        if (streamCount == 1) {
            return new OutputCallback(){

                public void continueOutputProcessing(boolean doOutput, boolean forceUpdate) {
                    OutputProcessViewPolicy.this.continueOutputProcessingView(doOutput, forceUpdate);
                }
            };
        }
        return new OutputCallback(){

            public void continueOutputProcessing(boolean doOutput, boolean forceUpdate) {
                OutputProcessViewPolicy.this.continueOutputProcessingJoin(doOutput, forceUpdate);
            }
        };
    }
}

