/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.EPStatementHandle;
import com.espertech.esper.core.InternalEventRouter;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.core.UpdateDispatchView;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.epl.view.OutputStrategy;
import com.espertech.esper.event.NaturalEventBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputStrategyPostProcess
implements OutputStrategy {
    private final boolean isRoute;
    private final boolean isRouteRStream;
    private final SelectClauseStreamSelectorEnum selectStreamDirEnum;
    private final InternalEventRouter internalEventRouter;
    private final EPStatementHandle epStatementHandle;
    private final StatementContext statementContext;
    private final boolean addToFront;

    public OutputStrategyPostProcess(boolean route, boolean routeRStream, SelectClauseStreamSelectorEnum selectStreamDirEnum, InternalEventRouter internalEventRouter, EPStatementHandle epStatementHandle, StatementContext statementContext, boolean addToFront) {
        this.isRoute = route;
        this.isRouteRStream = routeRStream;
        this.selectStreamDirEnum = selectStreamDirEnum;
        this.internalEventRouter = internalEventRouter;
        this.epStatementHandle = epStatementHandle;
        this.statementContext = statementContext;
        this.addToFront = addToFront;
    }

    @Override
    public void output(boolean forceUpdate, UniformPair<EventBean[]> result, UpdateDispatchView finalView) {
        EventBean[] oldEvents;
        EventBean[] newEvents = result != null ? result.getFirst() : null;
        EventBean[] eventBeanArray = oldEvents = result != null ? result.getSecond() : null;
        if (this.isRoute) {
            if (newEvents != null && !this.isRouteRStream) {
                this.route(newEvents, this.statementContext);
            }
            if (oldEvents != null && this.isRouteRStream) {
                this.route(oldEvents, this.statementContext);
            }
        }
        if (this.selectStreamDirEnum == SelectClauseStreamSelectorEnum.RSTREAM_ONLY) {
            newEvents = oldEvents;
            oldEvents = null;
        } else if (this.selectStreamDirEnum == SelectClauseStreamSelectorEnum.ISTREAM_ONLY) {
            oldEvents = null;
        }
        if (newEvents != null || oldEvents != null) {
            finalView.newResult(new UniformPair<EventBean[]>(newEvents, oldEvents));
        } else if (forceUpdate) {
            finalView.newResult(new UniformPair<Object>(null, null));
        }
    }

    private void route(EventBean[] events, ExprEvaluatorContext exprEvaluatorContext) {
        for (EventBean routed : events) {
            if (routed instanceof NaturalEventBean) {
                NaturalEventBean natural = (NaturalEventBean)routed;
                this.internalEventRouter.route(natural.getOptionalSynthetic(), this.epStatementHandle, this.statementContext.getInternalEventEngineRouteDest(), exprEvaluatorContext, this.addToFront);
                continue;
            }
            this.internalEventRouter.route(routed, this.epStatementHandle, this.statementContext.getInternalEventEngineRouteDest(), exprEvaluatorContext, this.addToFront);
        }
    }
}

